/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.actions;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.ImplementationViewComponent;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.navigation.BackgroundUpdaterTask;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.presentation.java.SymbolPresentationUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.reference.SoftReference;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.PopupPositionManager;
import com.intellij.ui.popup.PopupUpdateProcessor;
import com.intellij.usages.UsageView;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowImplementationsAction
extends AnAction
implements PopupAction {
    @NonNls
    public static final String CODEASSISTS_QUICKDEFINITION_LOOKUP_FEATURE = "codeassists.quickdefinition.lookup";
    @NonNls
    public static final String CODEASSISTS_QUICKDEFINITION_FEATURE = "codeassists.quickdefinition";
    private static final Logger LOG = Logger.getInstance((String)("#" + ShowImplementationsAction.class.getName()));
    private Reference<JBPopup> myPopupRef;
    private Reference<ImplementationsUpdaterTask> myTaskRef;

    public ShowImplementationsAction() {
        this.setEnabledInModalContext(true);
        this.setInjectedContext(true);
    }

    public boolean startInTransaction() {
        return true;
    }

    public void actionPerformed(AnActionEvent e) {
        this.performForContext(e.getDataContext(), true);
    }

    public void performForContext(DataContext dataContext) {
        this.performForContext(dataContext, true);
    }

    public void update(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        DataContext dataContext = e.getDataContext();
        Editor editor = ShowImplementationsAction.getEditor(dataContext);
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        PsiFile containingFile = (element = ShowImplementationsAction.getElement(project2, file2, editor, element)) != null ? element.getContainingFile() : file2;
        boolean enabled = containingFile != null && containingFile.getViewProvider().isPhysical();
        e.getPresentation().setEnabled(enabled);
    }

    protected static Editor getEditor(@NotNull DataContext dataContext) {
        FileEditor fileEditor;
        VirtualFile virtualFile;
        PsiFile file2;
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null && (file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext)) != null && (virtualFile = file2.getVirtualFile()) != null && (fileEditor = FileEditorManager.getInstance((Project)file2.getProject()).getSelectedEditor(virtualFile)) instanceof TextEditor) {
            editor = ((TextEditor)fileEditor).getEditor();
        }
        return editor;
    }

    public void performForContext(@NotNull DataContext dataContext, boolean invokedByShortcut) {
        PsiFile containingFile;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        PsiFile file2 = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        Editor editor = ShowImplementationsAction.getEditor(dataContext);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        boolean isInvokedFromEditor = CommonDataKeys.EDITOR.getData(dataContext) != null;
        element = ShowImplementationsAction.getElement(project2, file2, editor, element);
        if (element == null && file2 == null) {
            return;
        }
        PsiFile psiFile = containingFile = element != null ? element.getContainingFile() : file2;
        if (containingFile == null || !containingFile.getViewProvider().isPhysical()) {
            return;
        }
        PsiReference ref = null;
        if (editor != null) {
            ref = TargetElementUtil.findReference(editor, editor.getCaretModel().getOffset());
            if (element == null && ref != null) {
                element = TargetElementUtil.getInstance().adjustReference(ref);
            }
        }
        if (element instanceof PsiCompiledElement) {
            element = element.getNavigationElement();
        }
        String text = "";
        PsiElement[] impls = PsiElement.EMPTY_ARRAY;
        if (element != null) {
            impls = ShowImplementationsAction.getSelfAndImplementations(editor, element, this.createImplementationsSearcher());
            text = SymbolPresentationUtil.getSymbolPresentableText(element);
        }
        if (impls.length == 0 && ref instanceof PsiPolyVariantReference) {
            PsiPolyVariantReference polyReference = (PsiPolyVariantReference)ref;
            PsiElement refElement = polyReference.getElement();
            TextRange rangeInElement = polyReference.getRangeInElement();
            String refElementText = refElement.getText();
            LOG.assertTrue(rangeInElement.getEndOffset() <= refElementText.length(), (Object)("Ref:" + polyReference + "; refElement: " + refElement + "; refText:" + refElementText));
            text = rangeInElement.substring(refElementText);
            ResolveResult[] results = polyReference.multiResolve(false);
            ArrayList<PsiElement> implsList = new ArrayList<PsiElement>(results.length);
            for (ResolveResult result2 : results) {
                PsiElement resolvedElement = result2.getElement();
                if (resolvedElement == null || !resolvedElement.isPhysical()) continue;
                implsList.add(resolvedElement);
            }
            if (!implsList.isEmpty()) {
                impls = implsList.toArray(new PsiElement[implsList.size()]);
            }
        }
        this.showImplementations(impls, project2, text, editor, file2, element, isInvokedFromEditor, invokedByShortcut);
    }

    protected static PsiElement getElement(@NotNull Project project2, PsiFile file2, Editor editor, PsiElement element) {
        if (element == null && editor != null) {
            element = TargetElementUtil.findTargetElement(editor, TargetElementUtil.getInstance().getAllAccepted());
            PsiElement adjustedElement = TargetElementUtil.getInstance().adjustElement(editor, TargetElementUtil.getInstance().getAllAccepted(), element, null);
            if (adjustedElement != null) {
                element = adjustedElement;
            } else if (file2 != null) {
                element = DocumentationManager.getInstance(project2).getElementFromLookup(editor, file2);
            }
        }
        return element;
    }

    @NotNull
    ImplementationSearcher createImplementationsSearcher() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return new ImplementationSearcher(){

                @Override
                protected PsiElement[] filterElements(PsiElement element, PsiElement[] targetElements) {
                    return ShowImplementationsAction.filterElements(targetElements);
                }
            };
        }
        return new ImplementationSearcher.FirstImplementationsSearcher(){

            @Override
            protected PsiElement[] filterElements(PsiElement element, PsiElement[] targetElements) {
                return ShowImplementationsAction.filterElements(targetElements);
            }

            @Override
            protected boolean isSearchDeep() {
                return ShowImplementationsAction.this.isSearchDeep();
            }
        };
    }

    private void updateElementImplementations(PsiElement element, Editor editor, @NotNull Project project2, PsiFile file2) {
        PsiElement[] impls = new PsiElement[]{};
        String text = "";
        if (element != null) {
            PsiFile containingFile = element.getContainingFile();
            if (containingFile == null || !containingFile.getViewProvider().isPhysical()) {
                return;
            }
            impls = ShowImplementationsAction.getSelfAndImplementations(editor, element, this.createImplementationsSearcher());
            text = SymbolPresentationUtil.getSymbolPresentableText(element);
        }
        this.showImplementations(impls, project2, text, editor, file2, element, false, false);
    }

    protected void showImplementations(@NotNull PsiElement[] impls, final @NotNull Project project2, String text, final Editor editor, final PsiFile file2, PsiElement element, boolean invokedFromEditor, boolean invokedByShortcut) {
        if (impls.length == 0) {
            return;
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKDEFINITION_FEATURE);
        if (LookupManager.getInstance(project2).getActiveLookup() != null) {
            FeatureUsageTracker.getInstance().triggerFeatureUsed(CODEASSISTS_QUICKDEFINITION_LOOKUP_FEATURE);
        }
        int index = 0;
        if (invokedFromEditor && file2 != null && impls.length > 1) {
            PsiFile secondContainingFile;
            VirtualFile virtualFile = file2.getVirtualFile();
            PsiFile containingFile = impls[0].getContainingFile();
            if (virtualFile != null && containingFile != null && virtualFile.equals(containingFile.getVirtualFile()) && (secondContainingFile = impls[1].getContainingFile()) != containingFile) {
                index = 1;
            }
        }
        Ref usageView = new Ref();
        String title = CodeInsightBundle.message((String)"implementation.view.title", (Object[])new Object[]{text});
        JBPopup popup = (JBPopup)SoftReference.dereference(this.myPopupRef);
        if (popup != null && popup.isVisible() && popup instanceof AbstractPopup) {
            ImplementationViewComponent component = (ImplementationViewComponent)((AbstractPopup)popup).getComponent();
            ((AbstractPopup)popup).setCaption(title);
            component.update(impls, index);
            this.updateInBackground(editor, element, component, title, (AbstractPopup)popup, (Ref<UsageView>)usageView);
            if (invokedByShortcut) {
                ((AbstractPopup)popup).focusPreferredComponent();
            }
            return;
        }
        ImplementationViewComponent component = new ImplementationViewComponent(impls, index);
        if (component.hasElementsToShow()) {
            PopupUpdateProcessor updateProcessor = new PopupUpdateProcessor(project2){

                public void updatePopup(Object lookupItemObject) {
                    PsiElement element = lookupItemObject instanceof PsiElement ? (PsiElement)lookupItemObject : DocumentationManager.getInstance(project2).getElementFromLookup(editor, file2);
                    ShowImplementationsAction.this.updateElementImplementations(element, editor, project2, file2);
                }
            };
            popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)component, component.getPreferredFocusableComponent()).setProject(project2).addListener((JBPopupListener)updateProcessor).addUserData((Object)updateProcessor).setDimensionServiceKey(project2, "javadoc.popup", false).setResizable(true).setMovable(true).setRequestFocus(invokedFromEditor && LookupManager.getActiveLookup(editor) == null).setTitle(title).setCouldPin(popup1 -> {
                usageView.set((Object)component.showInUsageView());
                popup1.cancel();
                this.myTaskRef = null;
                return false;
            }).setCancelCallback(() -> {
                ImplementationsUpdaterTask task = (ImplementationsUpdaterTask)((Object)((Object)SoftReference.dereference(this.myTaskRef)));
                if (task != null) {
                    task.cancelTask();
                }
                return Boolean.TRUE;
            }).createPopup();
            this.updateInBackground(editor, element, component, title, (AbstractPopup)popup, (Ref<UsageView>)usageView);
            PopupPositionManager.positionPopupInBestPosition(popup, editor, DataManager.getInstance().getDataContext());
            component.setHint(popup, title);
            this.myPopupRef = new WeakReference<JBPopup>(popup);
        }
    }

    private void updateInBackground(Editor editor, @Nullable PsiElement element, @NotNull ImplementationViewComponent component, String title, @NotNull AbstractPopup popup, @NotNull Ref<UsageView> usageView) {
        ImplementationsUpdaterTask updaterTask = (ImplementationsUpdaterTask)((Object)SoftReference.dereference(this.myTaskRef));
        if (updaterTask != null) {
            updaterTask.cancelTask();
        }
        if (element == null) {
            return;
        }
        ImplementationsUpdaterTask task = new ImplementationsUpdaterTask(element, editor, title, this.isIncludeAlwaysSelf());
        task.init(popup, component, usageView);
        this.myTaskRef = new WeakReference<ImplementationsUpdaterTask>(task);
        ProgressManager.getInstance().runProcessWithProgressAsynchronously((Task.Backgroundable)task, (ProgressIndicator)new BackgroundableProcessIndicator(task));
    }

    protected boolean isIncludeAlwaysSelf() {
        return true;
    }

    @NotNull
    private static PsiElement[] getSelfAndImplementations(Editor editor, @NotNull PsiElement element, @NotNull ImplementationSearcher handler2) {
        return ShowImplementationsAction.getSelfAndImplementations(editor, element, handler2, !(element instanceof PomTargetPsiElement));
    }

    @NotNull
    static PsiElement[] getSelfAndImplementations(Editor editor, @NotNull PsiElement element, @NotNull ImplementationSearcher handler2, boolean includeSelfAlways) {
        PsiElement[] handlerImplementations = handler2.searchImplementations(element, editor, includeSelfAlways, true);
        if (handlerImplementations.length > 0) {
            return handlerImplementations;
        }
        return (PsiElement[])ReadAction.compute(() -> {
            PsiElement psiElement = element;
            PsiFile psiFile = psiElement.getContainingFile();
            if (psiFile == null && (psiFile = (psiElement = psiElement.getNavigationElement()).getContainingFile()) == null) {
                return PsiElement.EMPTY_ARRAY;
            }
            if (psiFile.getVirtualFile() != null && (psiElement.getTextRange() != null || psiElement instanceof PsiFile)) {
                return new PsiElement[]{psiElement};
            }
            return PsiElement.EMPTY_ARRAY;
        });
    }

    @NotNull
    private static PsiElement[] filterElements(final @NotNull PsiElement[] targetElements) {
        LinkedHashSet<PsiElement> unique = new LinkedHashSet<PsiElement>(Arrays.asList(targetElements));
        for (PsiElement elt : targetElements) {
            ApplicationManager.getApplication().runReadAction(() -> {
                PsiFile containingFile = elt.getContainingFile();
                LOG.assertTrue(containingFile != null, (Object)elt);
                PsiFile psiFile = containingFile.getOriginalFile();
                if (psiFile.getVirtualFile() == null) {
                    unique.remove(elt);
                }
            });
        }
        for (int i = 1; i < targetElements.length; ++i) {
            final PsiElement targetElement = targetElements[i];
            if (!((Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

                public Boolean compute() {
                    return PsiTreeUtil.isAncestor((PsiElement)targetElement, (PsiElement)targetElements[0], (boolean)true);
                }
            })).booleanValue()) continue;
            unique.remove(targetElements[0]);
            break;
        }
        return PsiUtilCore.toPsiElementArray(unique);
    }

    protected boolean isSearchDeep() {
        return false;
    }

    private class ImplementationsUpdaterTask
    extends BackgroundUpdaterTask<ImplementationViewComponent> {
        private final String myCaption;
        private final Editor myEditor;
        @NotNull
        private final PsiElement myElement;
        private final boolean myIncludeSelf;
        private PsiElement[] myElements;

        private ImplementationsUpdaterTask(PsiElement element, Editor editor, String caption, boolean includeSelf) {
            super(element.getProject(), ImplementationSearcher.SEARCHING_FOR_IMPLEMENTATIONS);
            this.myCaption = caption;
            this.myEditor = editor;
            this.myElement = element;
            this.myIncludeSelf = includeSelf;
        }

        @Override
        public String getCaption(int size) {
            return this.myCaption;
        }

        @Override
        protected void paintBusy(boolean paintBusy) {
        }

        @Override
        protected void replaceModel(@NotNull List<PsiElement> data) {
            PsiElement[] elements = ((ImplementationViewComponent)this.myComponent).getElements();
            int includeSelfIdx = this.myElement instanceof PomTargetPsiElement ? 0 : 1;
            int startIdx = elements.length - includeSelfIdx;
            PsiElement[] result2 = new PsiElement[data.size() + includeSelfIdx];
            System.arraycopy(elements, 0, result2, 0, elements.length);
            System.arraycopy(PsiUtilCore.toPsiElementArray(data), startIdx, result2, elements.length, data.size() - startIdx);
            ((ImplementationViewComponent)this.myComponent).update(result2, ((ImplementationViewComponent)this.myComponent).getIndex());
        }

        @Override
        public void run(final @NotNull ProgressIndicator indicator) {
            super.run(indicator);
            ImplementationSearcher.BackgroundableImplementationSearcher implementationSearcher = new ImplementationSearcher.BackgroundableImplementationSearcher(){

                @Override
                protected boolean isSearchDeep() {
                    return ShowImplementationsAction.this.isSearchDeep();
                }

                @Override
                protected void processElement(PsiElement element) {
                    if (!ImplementationsUpdaterTask.this.updateComponent(element, null)) {
                        indicator.cancel();
                    }
                    indicator.checkCanceled();
                }

                @Override
                protected PsiElement[] filterElements(PsiElement element, PsiElement[] targetElements) {
                    return ShowImplementationsAction.filterElements(targetElements);
                }
            };
            this.myElements = !this.myIncludeSelf ? ShowImplementationsAction.getSelfAndImplementations(this.myEditor, this.myElement, implementationSearcher, false) : ShowImplementationsAction.getSelfAndImplementations(this.myEditor, this.myElement, implementationSearcher);
        }

        @Override
        public int getCurrentSize() {
            if (this.myElements != null) {
                return this.myElements.length;
            }
            return super.getCurrentSize();
        }

        @Override
        public void onSuccess() {
            if (!this.cancelTask()) {
                ((ImplementationViewComponent)this.myComponent).update(this.myElements, ((ImplementationViewComponent)this.myComponent).getIndex());
            }
            super.onSuccess();
        }
    }
}

