/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.api.impls;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionMemory;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.CompletionParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<PsiExpressionList, Object, PsiExpression>,
DumbAware {
    private static final Set<Class> ourArgumentListAllowedParentClassesSet = ContainerUtil.newHashSet((Object[])new Class[]{PsiMethodCallExpression.class, PsiNewExpression.class, PsiAnonymousClass.class, PsiEnumConstant.class});
    private static final Set<? extends Class> ourStopSearch = Collections.singleton(PsiMethod.class);

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        List<? extends PsiElement> elements = JavaCompletionUtil.getAllPsiElements(item);
        return elements != null && !elements.isEmpty() && elements.get(0) instanceof PsiMethod ? elements.toArray() : null;
    }

    public Object[] getParametersForDocumentation(Object p, ParameterInfoContext context) {
        if (p instanceof MethodCandidateInfo) {
            return ((MethodCandidateInfo)p).getElement().getParameterList().getParameters();
        }
        if (p instanceof PsiMethod) {
            return ((PsiMethod)p).getParameterList().getParameters();
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean couldShowInLookup() {
        return true;
    }

    @Nullable
    public PsiExpressionList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        PsiExpressionList argumentList = this.findArgumentList(context.getFile(), context.getOffset(), context.getParameterListStart());
        if (argumentList != null) {
            return MethodParameterInfoHandler.findMethodsForArgumentList(context, argumentList);
        }
        return null;
    }

    private PsiExpressionList findArgumentList(PsiFile file2, int offset, int parameterStart) {
        PsiMethodCallExpression methodCall;
        PsiExpressionList argumentList = (PsiExpressionList)ParameterInfoUtils.findArgumentList((PsiFile)file2, (int)offset, (int)parameterStart, (ParameterInfoHandlerWithTabActionSupport)this);
        if (argumentList == null && (methodCall = (PsiMethodCallExpression)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file2, (int)offset, PsiMethodCallExpression.class, (Class[])new Class[]{PsiMethod.class})) != null) {
            argumentList = methodCall.getArgumentList();
        }
        return argumentList;
    }

    private static PsiExpressionList findMethodsForArgumentList(CreateParameterInfoContext context, @NotNull PsiExpressionList argumentList) {
        Object[] candidates = MethodParameterInfoHandler.getMethods(argumentList);
        if (candidates.length == 0) {
            DaemonCodeAnalyzer.getInstance((Project)context.getProject()).updateVisibleHighlighters(context.getEditor());
            return null;
        }
        context.setItemsToShow(candidates);
        return argumentList;
    }

    public void showParameterInfo(@NotNull PsiExpressionList element, @NotNull CreateParameterInfoContext context) {
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public PsiExpressionList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        return this.findArgumentList(context.getFile(), context.getOffset(), context.getParameterListStart());
    }

    public void updateParameterInfo(@NotNull PsiExpressionList o, @NotNull UpdateParameterInfoContext context) {
        PsiElement parameterOwner = context.getParameterOwner();
        if (parameterOwner != o) {
            context.removeHint();
            return;
        }
        int index = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)o.getNode(), (int)context.getOffset(), (IElementType)JavaTokenType.COMMA);
        context.setCurrentParameter(index);
        Object[] candidates = context.getObjectsToView();
        PsiExpression[] args = o.getExpressions();
        PsiCall call = MethodParameterInfoHandler.getCall(o);
        PsiMethod realResolve = call != null ? call.resolveMethod() : null;
        PsiMethod chosenMethod = CompletionMemory.getChosenMethod(call);
        CandidateInfo chosenInfo = null;
        CandidateInfo completeMatch = null;
        for (int i2 = 0; i2 < candidates.length; ++i2) {
            CandidateInfo candidate = (CandidateInfo)candidates[i2];
            PsiMethod method2 = (PsiMethod)candidate.getElement();
            if (!method2.isValid()) continue;
            PsiSubstitutor substitutor = MethodParameterInfoHandler.getCandidateInfoSubstitutor(candidate);
            assert (substitutor != null);
            if (!method2.isValid() || !substitutor.isValid()) {
                context.setUIComponentEnabled(i2, false);
                continue;
            }
            PsiParameter[] parms = method2.getParameterList().getParameters();
            boolean enabled = true;
            if (parms.length <= index) {
                if (parms.length > 0) {
                    if (method2.isVarArgs()) {
                        for (int j = 0; j < parms.length - 1; ++j) {
                            PsiType parmType = substitutor.substitute(parms[j].getType());
                            PsiType argType = args[j].getType();
                            if (argType == null || parmType.isAssignableFrom(argType)) continue;
                            enabled = false;
                            break;
                        }
                        if (enabled) {
                            PsiArrayType lastParmType = (PsiArrayType)substitutor.substitute(parms[parms.length - 1].getType());
                            PsiType componentType = lastParmType.getComponentType();
                            if (parms.length == args.length) {
                                PsiType lastArgType = args[args.length - 1].getType();
                                if (lastArgType != null && !lastParmType.isAssignableFrom(lastArgType) && !componentType.isAssignableFrom(lastArgType)) {
                                    enabled = false;
                                }
                            } else {
                                for (int j = parms.length; j <= index && j < args.length; ++j) {
                                    PsiExpression arg = args[j];
                                    PsiType argType = arg.getType();
                                    if (argType == null || componentType.isAssignableFrom(argType)) continue;
                                    enabled = false;
                                    break;
                                }
                            }
                        }
                    } else {
                        enabled = false;
                    }
                } else {
                    enabled = index == 0;
                }
            } else {
                enabled = MethodParameterInfoHandler.isAssignableParametersBeforeGivenIndex(parms, args, index, substitutor);
            }
            context.setUIComponentEnabled(i2, enabled);
            if (candidates.length <= 1 || !enabled) continue;
            if (chosenMethod == method2) {
                chosenInfo = candidate;
            }
            if (parms.length != args.length || realResolve != method2 || !MethodParameterInfoHandler.isAssignableParametersBeforeGivenIndex(parms, args, args.length, substitutor)) continue;
            completeMatch = candidate;
        }
        if (chosenInfo != null) {
            context.setHighlightedParameter(chosenInfo);
        } else if (completeMatch != null) {
            context.setHighlightedParameter(completeMatch);
        }
    }

    private static PsiSubstitutor getCandidateInfoSubstitutor(CandidateInfo candidate) {
        return candidate instanceof MethodCandidateInfo && ((MethodCandidateInfo)candidate).isInferencePossible() ? ((MethodCandidateInfo)candidate).inferTypeArguments((ParameterTypeInferencePolicy)CompletionParameterTypeInferencePolicy.INSTANCE, true) : candidate.getSubstitutor();
    }

    private static boolean isAssignableParametersBeforeGivenIndex(PsiParameter[] parms, PsiExpression[] args, int length, PsiSubstitutor substitutor) {
        for (int j = 0; j < length; ++j) {
            PsiParameter parm = parms[j];
            PsiExpression arg = args[j];
            assert (parm.isValid());
            assert (arg.isValid());
            PsiType parmType = parm.getType();
            PsiType argType = arg.getType();
            if (argType == null) continue;
            if (parmType instanceof PsiEllipsisType && parmType.getArrayDimensions() == argType.getArrayDimensions() + 1) {
                parmType = ((PsiEllipsisType)parmType).getComponentType();
            }
            if ((parmType = substitutor.substitute(parmType)).isAssignableFrom(argType)) continue;
            return false;
        }
        return true;
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    @NotNull
    public Class<PsiExpressionList> getArgumentListClass() {
        return PsiExpressionList.class;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        return JavaTokenType.RBRACE;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        return ourArgumentListAllowedParentClassesSet;
    }

    @NotNull
    public Set<? extends Class> getArgListStopSearchClasses() {
        return ourStopSearch;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        return JavaTokenType.COMMA;
    }

    @NotNull
    public PsiExpression[] getActualParameters(@NotNull PsiExpressionList psiExpressionList) {
        return psiExpressionList.getExpressions();
    }

    private static PsiCall getCall(PsiExpressionList list) {
        PsiElement listParent = list.getParent();
        if (listParent instanceof PsiMethodCallExpression) {
            return (PsiCall)listParent;
        }
        if (listParent instanceof PsiNewExpression) {
            return (PsiCall)listParent;
        }
        if (listParent instanceof PsiAnonymousClass) {
            return (PsiCall)listParent.getParent();
        }
        if (listParent instanceof PsiEnumConstant) {
            return (PsiCall)listParent;
        }
        return null;
    }

    private static CandidateInfo[] getMethods(PsiExpressionList argList) {
        PsiCall call = MethodParameterInfoHandler.getCall(argList);
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)argList.getProject()).getResolveHelper();
        if (call instanceof PsiCallExpression) {
            CandidateInfo[] candidates = MethodParameterInfoHandler.getCandidates((PsiCallExpression)call);
            ArrayList<CandidateInfo> result2 = new ArrayList<CandidateInfo>();
            if (!(argList.getParent() instanceof PsiAnonymousClass)) {
                block0: for (CandidateInfo candidate : candidates) {
                    PsiMethod methodCandidate = (PsiMethod)candidate.getElement();
                    for (CandidateInfo info : result2) {
                        if (!MethodSignatureUtil.isSuperMethod((PsiMethod)methodCandidate, (PsiMethod)((PsiMethod)info.getElement()))) continue;
                        continue block0;
                    }
                    if (!candidate.isStaticsScopeCorrect()) continue;
                    boolean accessible = candidate.isAccessible();
                    if (!accessible && methodCandidate.getModifierList().hasModifierProperty("private")) {
                        accessible = JavaPsiFacade.getInstance((Project)methodCandidate.getProject()).getResolveHelper().isAccessible((PsiMember)methodCandidate, methodCandidate.getModifierList(), (PsiElement)call, null, null);
                    }
                    if (!accessible) continue;
                    result2.add(candidate);
                }
            } else {
                PsiClass aClass = (PsiClass)argList.getParent();
                for (CandidateInfo candidate : candidates) {
                    if (!candidate.isStaticsScopeCorrect() || !helper.isAccessible((PsiMember)((PsiMethod)candidate.getElement()), (PsiElement)argList, aClass)) continue;
                    result2.add(candidate);
                }
            }
            return result2.isEmpty() ? candidates : result2.toArray(new CandidateInfo[result2.size()]);
        }
        assert (call instanceof PsiEnumConstant);
        PsiMethod[] constructors = ((PsiEnumConstant)call).getContainingClass().getConstructors();
        CandidateInfo[] result3 = new CandidateInfo[constructors.length];
        for (int i2 = 0; i2 < constructors.length; ++i2) {
            result3[i2] = new CandidateInfo((PsiElement)constructors[i2], PsiSubstitutor.EMPTY);
        }
        return result3;
    }

    private static CandidateInfo[] getCandidates(PsiCallExpression call) {
        MethodResolverProcessor processor2 = new MethodResolverProcessor((PsiElement)call, call.getContainingFile(), new PsiConflictResolver[0]){

            @Override
            protected boolean acceptVarargs() {
                return false;
            }
        };
        try {
            PsiScopesUtil.setupAndRunProcessor(processor2, call, true);
        }
        catch (MethodProcessorSetupFailedException e) {
            return CandidateInfo.EMPTY_ARRAY;
        }
        List<CandidateInfo> results = processor2.getResults();
        return results.toArray(new CandidateInfo[results.size()]);
    }

    public static String updateMethodPresentation(@NotNull PsiMethod method2, @Nullable PsiSubstitutor substitutor, @NotNull ParameterInfoUIContext context) {
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (!method2.isValid() || substitutor != null && !substitutor.isValid()) {
            context.setUIComponentEnabled(false);
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
            if (!method2.isConstructor()) {
                PsiType returnType = method2.getReturnType();
                if (substitutor != null) {
                    returnType = substitutor.substitute(returnType);
                }
                assert (returnType != null) : method2;
                MethodParameterInfoHandler.appendModifierList(buffer, (PsiModifierListOwner)method2);
                buffer.append(returnType.getPresentableText(true));
                buffer.append(" ");
            }
            buffer.append(method2.getName());
            buffer.append("(");
        }
        int currentParameter = context.getCurrentParameterIndex();
        PsiParameter[] parms = method2.getParameterList().getParameters();
        int numParams = parms.length;
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (numParams > 0) {
            for (int j = 0; j < numParams; ++j) {
                PsiParameter param = parms[j];
                int startOffset = buffer.length();
                if (param.isValid()) {
                    PsiType paramType = param.getType();
                    assert (paramType.isValid());
                    if (substitutor != null) {
                        assert (substitutor.isValid());
                        paramType = substitutor.substitute(paramType);
                    }
                    MethodParameterInfoHandler.appendModifierList(buffer, (PsiModifierListOwner)param);
                    buffer.append(paramType.getPresentableText(true));
                    String name = param.getName();
                    if (name != null) {
                        buffer.append(" ");
                        buffer.append(name);
                    }
                }
                int endOffset = buffer.length();
                if (j < numParams - 1) {
                    buffer.append(", ");
                }
                if (!context.isUIComponentEnabled() || j != currentParameter && (j != numParams - 1 || !param.isVarArgs() || currentParameter < numParams)) continue;
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
        } else {
            buffer.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
            buffer.append(")");
        }
        return context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, !context.isUIComponentEnabled(), method2.isDeprecated(), false, context.getDefaultParameterColor());
    }

    private static void appendModifierList(@NotNull StringBuilder buffer, @NotNull PsiModifierListOwner owner) {
        int lastSize = buffer.length();
        HashSet shownAnnotations = ContainerUtil.newHashSet();
        for (PsiAnnotation annotation : AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner, (boolean)false, null, (!DumbService.isDumb((Project)owner.getProject()) ? 1 : 0) != 0)) {
            String referenceName;
            PsiElement resolved;
            PsiJavaCodeReferenceElement element = annotation.getNameReferenceElement();
            if (element == null || (resolved = element.resolve()) instanceof PsiClass && (!JavaDocInfoGenerator.isDocumentedAnnotationType((PsiClass)resolved) || AnnotationTargetUtil.findAnnotationTarget((PsiClass)((PsiClass)resolved), (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE}) != null) || !shownAnnotations.add(referenceName = element.getReferenceName()) && !JavaDocInfoGenerator.isRepeatableAnnotationType(resolved)) continue;
            if (lastSize != buffer.length()) {
                buffer.append(' ');
            }
            buffer.append('@').append(referenceName);
        }
        if (lastSize != buffer.length()) {
            buffer.append(' ');
        }
    }

    public void updateUI(Object p, @NotNull ParameterInfoUIContext context) {
        if (p instanceof CandidateInfo) {
            CandidateInfo info = (CandidateInfo)p;
            PsiMethod method2 = (PsiMethod)info.getElement();
            if (!method2.isValid()) {
                context.setUIComponentEnabled(false);
                return;
            }
            MethodParameterInfoHandler.updateMethodPresentation(method2, MethodParameterInfoHandler.getCandidateInfoSubstitutor(info), context);
        } else {
            MethodParameterInfoHandler.updateMethodPresentation((PsiMethod)p, null, context);
        }
    }
}

