/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeHighlighting.EditorBoundHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPass;
import com.intellij.codeHighlighting.TextEditorHighlightingPassFactory;
import com.intellij.codeHighlighting.TextEditorHighlightingPassRegistrar;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.codeInsight.hints.filtering.Matcher;
import com.intellij.codeInsight.hints.filtering.MatcherConstructor;
import com.intellij.codeInsight.hints.settings.Diff;
import com.intellij.codeInsight.hints.settings.ParameterNameHintsSettings;
import com.intellij.lang.Language;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.editor.ex.util.CaretVisualPositionKeeper;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import gnu.trove.TIntObjectHashMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterHintsPassFactory
extends AbstractProjectComponent
implements TextEditorHighlightingPassFactory {
    private static final Key<Boolean> REPEATED_PASS = Key.create((String)"RepeatedParameterHintsPass");

    public ParameterHintsPassFactory(Project project2, TextEditorHighlightingPassRegistrar registrar) {
        super(project2);
        registrar.registerTextEditorHighlightingPass((TextEditorHighlightingPassFactory)this, null, null, false, -1);
    }

    @Override
    @Nullable
    public TextEditorHighlightingPass createHighlightingPass(@NotNull PsiFile file2, @NotNull Editor editor) {
        if (editor.isOneLineMode()) {
            return null;
        }
        return new ParameterHintsPass(file2, editor);
    }

    private static class ParameterHintsPass
    extends EditorBoundHighlightingPass {
        private final Map<Integer, String> myAnnotations = new HashMap<Integer, String>();

        private ParameterHintsPass(@NotNull PsiFile file2, @NotNull Editor editor) {
            super(editor, file2, true);
        }

        @Override
        public void doCollectInformation(@NotNull ProgressIndicator progress) {
            assert (this.myDocument != null);
            this.myAnnotations.clear();
            if (!ParameterHintsPass.isEnabled()) {
                return;
            }
            Language language = this.myFile.getLanguage();
            InlayParameterHintsProvider provider2 = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
            if (provider2 == null) {
                return;
            }
            Set<String> blackList = ParameterHintsPass.getBlackList(language);
            Language dependentLanguage = provider2.getBlackListDependencyLanguage();
            if (dependentLanguage != null) {
                blackList.addAll(ParameterHintsPass.getBlackList(dependentLanguage));
            }
            List matchers = blackList.stream().map(item -> MatcherConstructor.INSTANCE.createMatcher((String)item)).filter(e -> e != null).collect(Collectors.toList());
            SyntaxTraverser.psiTraverser((PsiElement)this.myFile).forEach(element -> this.process((PsiElement)element, provider2, matchers));
        }

        private static Set<String> getBlackList(Language language) {
            InlayParameterHintsProvider provider2 = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(language);
            if (provider2 != null) {
                ParameterNameHintsSettings settings = ParameterNameHintsSettings.getInstance();
                Diff diff = settings.getBlackListDiff(language);
                return diff.applyOn(provider2.getDefaultBlackList());
            }
            return ContainerUtil.newHashOrEmptySet((Iterable)ContainerUtil.emptyIterable());
        }

        private static boolean isEnabled() {
            return EditorSettingsExternalizable.getInstance().isShowParameterNameHints();
        }

        private static boolean isMatchedByAny(HintInfo info, List<Matcher> matchers) {
            if (info instanceof HintInfo.MethodInfo) {
                HintInfo.MethodInfo methodInfo = (HintInfo.MethodInfo)info;
                return matchers.stream().anyMatch(e -> e.isMatching(methodInfo.getFullyQualifiedName(), methodInfo.getParamNames()));
            }
            return false;
        }

        private void process(PsiElement element, InlayParameterHintsProvider provider2, List<Matcher> blackListMatchers) {
            List hints = provider2.getParameterHints(element);
            if (hints.isEmpty()) {
                return;
            }
            HintInfo info = provider2.getHintInfo(element);
            if (info == null || !ParameterHintsPass.isMatchedByAny(info, blackListMatchers)) {
                hints.forEach(hint -> {
                    String presentation = provider2.getInlayPresentation(hint.getText());
                    this.myAnnotations.put(hint.getOffset(), presentation);
                });
            }
        }

        @Override
        public void doApplyInformationToEditor() {
            int offset;
            assert (this.myDocument != null);
            boolean firstTime = this.myEditor.getUserData(REPEATED_PASS) == null;
            ParameterHintsPresentationManager presentationManager = ParameterHintsPresentationManager.getInstance();
            HashSet removedHints = new HashSet();
            TIntObjectHashMap caretMap = new TIntObjectHashMap();
            CaretVisualPositionKeeper keeper = new CaretVisualPositionKeeper(this.myEditor);
            for (Caret caret : this.myEditor.getCaretModel().getAllCarets()) {
                caretMap.put(caret.getOffset(), (Object)caret);
            }
            for (Inlay inlay : this.myEditor.getInlayModel().getInlineElementsInRange(0, this.myDocument.getTextLength())) {
                if (!presentationManager.isParameterHint(inlay)) continue;
                offset = inlay.getOffset();
                String newText = this.myAnnotations.remove(offset);
                String oldText = presentationManager.getHintText(inlay);
                if (this.delayRemoval(inlay, (TIntObjectHashMap<Caret>)caretMap) || Objects.equals(newText, oldText)) continue;
                if (newText == null) {
                    removedHints.add(oldText);
                    presentationManager.deleteHint(this.myEditor, inlay);
                    continue;
                }
                presentationManager.replaceHint(this.myEditor, inlay, newText);
            }
            for (Map.Entry entry : this.myAnnotations.entrySet()) {
                offset = (Integer)entry.getKey();
                String text = (String)entry.getValue();
                presentationManager.addHint(this.myEditor, offset, text, !firstTime && !removedHints.contains(text));
            }
            keeper.restoreOriginalLocation();
            this.myEditor.putUserData(REPEATED_PASS, (Object)Boolean.TRUE);
        }

        private boolean delayRemoval(Inlay inlay, TIntObjectHashMap<Caret> caretMap) {
            int offset = inlay.getOffset();
            Caret caret = (Caret)caretMap.get(offset);
            if (caret == null) {
                return false;
            }
            CharSequence text = this.myEditor.getDocument().getImmutableCharSequence();
            if (offset >= text.length()) {
                return false;
            }
            char afterCaret = text.charAt(offset);
            if (afterCaret != ',' && afterCaret != ')') {
                return false;
            }
            VisualPosition afterInlayPosition = this.myEditor.offsetToVisualPosition(offset, true, false);
            return caret.getVisualPosition().equals((Object)afterInlayPosition);
        }
    }
}

