/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hints;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.daemon.impl.ParameterHintsPresentationManager;
import com.intellij.codeInsight.hints.HintInfo;
import com.intellij.codeInsight.hints.InlayParameterHintsExtension;
import com.intellij.codeInsight.hints.InlayParameterHintsProvider;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.Inlay;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\n\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0002\u001a\u00020\u0003\u001a\b\u0010\u000b\u001a\u00020\fH\u0002\u001a\u0011\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000f*\u00020\u000eH\u0002\u001a\n\u0010\u0010\u001a\u00020\u000e*\u00020\u0011\u00a8\u0006\u0012"}, d2={"getHintInfoFromProvider", "Lcom/intellij/codeInsight/hints/HintInfo;", "offset", "", "file", "Lcom/intellij/psi/PsiFile;", "hasEditorParameterHintAtOffset", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "isPossibleHintNearOffset", "refreshAllOpenEditors", "", "capitalize", "", "Lorg/jetbrains/annotations/NotNull;", "toPattern", "Lcom/intellij/codeInsight/hints/HintInfo$MethodInfo;", "lang-impl"})
public final class PopupActionsKt {
    private static final boolean hasEditorParameterHintAtOffset(Editor editor, PsiFile file2) {
        Object v2;
        block2: {
            Iterable iterable;
            if (editor instanceof EditorWindow) {
                return false;
            }
            int offset = editor.getCaretModel().getOffset();
            PsiElement element = file2.findElementAt(offset);
            PsiElement psiElement = element;
            int startOffset = psiElement != null && (psiElement = psiElement.getTextRange()) != null ? psiElement.getStartOffset() : offset;
            PsiElement psiElement2 = element;
            int endOffset = psiElement2 != null && (psiElement2 = psiElement2.getTextRange()) != null ? psiElement2.getEndOffset() : offset;
            Iterable iterable2 = iterable = (Iterable)editor.getInlayModel().getInlineElementsInRange(startOffset, endOffset);
            for (Object t : iterable2) {
                Inlay it = (Inlay)t;
                if (!ParameterHintsPresentationManager.getInstance().isParameterHint(it)) continue;
                v2 = t;
                break block2;
            }
            v2 = null;
        }
        return v2 != null;
    }

    private static final void refreshAllOpenEditors() {
        Object[] $receiver$iv = ProjectManager.getInstance().getOpenProjects();
        for (int j = 0; j < $receiver$iv.length; ++j) {
            Object element$iv = $receiver$iv[j];
            Project it = (Project)element$iv;
            PsiManager psiManager = PsiManager.getInstance((Project)it);
            DaemonCodeAnalyzer daemonCodeAnalyzer = DaemonCodeAnalyzer.getInstance((Project)it);
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)it);
            Object[] $receiver$iv2 = fileEditorManager.getSelectedFiles();
            for (int k = 0; k < $receiver$iv2.length; ++k) {
                PsiFile psiFile;
                Object element$iv2 = $receiver$iv2[k];
                VirtualFile it2 = (VirtualFile)element$iv2;
                if (psiManager.findFile(it2) == null) continue;
                PsiFile it3 = psiFile;
                daemonCodeAnalyzer.restart(it3);
            }
        }
    }

    private static final HintInfo getHintInfoFromProvider(int offset, PsiFile file2) {
        PsiElement element = file2.findElementAt(offset);
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage());
        if (inlayParameterHintsProvider == null) {
            return null;
        }
        InlayParameterHintsProvider hintsProvider = inlayParameterHintsProvider;
        PsiElement psiElement = PsiTreeUtil.findFirstParent((PsiElement)element, (Condition)((Condition)new Condition<PsiElement>(hintsProvider){
            final /* synthetic */ InlayParameterHintsProvider $hintsProvider;

            public final boolean value(PsiElement e) {
                return this.$hintsProvider.getHintInfo(e) != null;
            }
            {
                this.$hintsProvider = inlayParameterHintsProvider;
            }
        }));
        if (psiElement == null) {
            return null;
        }
        PsiElement method2 = psiElement;
        return hintsProvider.getHintInfo(method2);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean isPossibleHintNearOffset(@NotNull PsiFile file2, int offset) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        InlayParameterHintsProvider inlayParameterHintsProvider = (InlayParameterHintsProvider)InlayParameterHintsExtension.INSTANCE.forLanguage(file2.getLanguage());
        if (inlayParameterHintsProvider == null) {
            return false;
        }
        InlayParameterHintsProvider hintProvider = inlayParameterHintsProvider;
        PsiElement element = file2.findElementAt(offset);
        int n = 0;
        int n2 = 3;
        if (n <= n2) {
            while (true) {
                void i2;
                if (element == null) {
                    return false;
                }
                List hints = hintProvider.getParameterHints(element);
                Collection collection = hints;
                if (!collection.isEmpty()) {
                    return true;
                }
                element = element.getParent();
                if (i2 == n2) break;
                ++i2;
            }
        }
        return false;
    }

    @NotNull
    public static final String toPattern(@NotNull HintInfo.MethodInfo $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.getFullyQualifiedName() + '(' + CollectionsKt.joinToString$default((Iterable)$receiver.getParamNames(), (CharSequence)",", null, null, (int)0, null, null, (int)62, null) + ')';
    }

    private static final String capitalize(@NotNull String $receiver) {
        return StringUtil.capitalizeWords((String)$receiver, (boolean)true);
    }

    @Nullable
    public static final /* synthetic */ HintInfo access$getHintInfoFromProvider(int offset, @NotNull PsiFile file2) {
        return PopupActionsKt.getHintInfoFromProvider(offset, file2);
    }

    public static final /* synthetic */ boolean access$hasEditorParameterHintAtOffset(@NotNull Editor editor, @NotNull PsiFile file2) {
        return PopupActionsKt.hasEditorParameterHintAtOffset(editor, file2);
    }

    public static final /* synthetic */ void access$refreshAllOpenEditors() {
        PopupActionsKt.refreshAllOpenEditors();
    }

    @NotNull
    public static final /* synthetic */ String access$capitalize(@NotNull String $receiver) {
        return PopupActionsKt.capitalize($receiver);
    }
}

