/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.lang.findUsages.FindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddAnnotationPsiFix
extends LocalQuickFixOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.AddAnnotationPsiFix");
    protected final String myAnnotation;
    private final String[] myAnnotationsToRemove;
    private final PsiNameValuePair[] myPairs;
    protected final String myText;

    public AddAnnotationPsiFix(@NotNull String fqn, @NotNull PsiModifierListOwner modifierListOwner, @NotNull PsiNameValuePair[] values, String ... annotationsToRemove) {
        super((PsiElement)modifierListOwner);
        this.myAnnotation = fqn;
        ObjectUtils.assertAllElementsNotNull((Object[])values);
        this.myPairs = values;
        ObjectUtils.assertAllElementsNotNull((Object[])annotationsToRemove);
        this.myAnnotationsToRemove = annotationsToRemove;
        this.myText = AddAnnotationPsiFix.calcText(modifierListOwner, this.myAnnotation);
    }

    public static String calcText(PsiModifierListOwner modifierListOwner, @NotNull String annotation) {
        String name;
        String shortName = annotation.substring(annotation.lastIndexOf(46) + 1);
        if (modifierListOwner instanceof PsiNamedElement && (name = ((PsiNamedElement)modifierListOwner).getName()) != null) {
            FindUsagesProvider provider2 = (FindUsagesProvider)LanguageFindUsages.INSTANCE.forLanguage(modifierListOwner.getLanguage());
            return CodeInsightBundle.message((String)"inspection.i18n.quickfix.annotate.element.as", (Object[])new Object[]{provider2.getType((PsiElement)modifierListOwner), name, shortName});
        }
        return CodeInsightBundle.message((String)"inspection.i18n.quickfix.annotate.as", (Object[])new Object[]{shortName});
    }

    @Nullable
    public static PsiModifierListOwner getContainer(PsiFile file2, int offset) {
        PsiElement id;
        PsiElement target;
        PsiReference reference = file2.findReferenceAt(offset);
        if (reference != null && (target = reference.resolve()) instanceof PsiMember) {
            return (PsiMember)target;
        }
        PsiElement element = file2.findElementAt(offset);
        PsiModifierListOwner listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element, PsiModifierListOwner.class, (boolean)false);
        if (listOwner instanceof PsiParameter) {
            return listOwner;
        }
        if (listOwner instanceof PsiNameIdentifierOwner && (id = ((PsiNameIdentifierOwner)listOwner).getNameIdentifier()) != null && id.getTextRange().containsOffset(offset)) {
            return listOwner;
        }
        return null;
    }

    @NotNull
    public String getText() {
        return this.myText;
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.add.annotation.family", (Object[])new Object[0]);
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (!startElement.isValid()) {
            return false;
        }
        if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)startElement)) {
            return false;
        }
        PsiModifierListOwner myModifierListOwner = (PsiModifierListOwner)startElement;
        return !AnnotationUtil.isAnnotated((PsiModifierListOwner)myModifierListOwner, (String)this.myAnnotation, (boolean)false, (boolean)false);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project2, @NotNull PsiFile file2, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        PsiModifierListOwner myModifierListOwner = (PsiModifierListOwner)startElement;
        ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance((Project)project2);
        PsiModifierList modifierList = myModifierListOwner.getModifierList();
        LOG.assertTrue(modifierList != null, (Object)(myModifierListOwner + " (" + myModifierListOwner.getClass() + ")"));
        if (modifierList.findAnnotation(this.myAnnotation) != null) {
            return;
        }
        ExternalAnnotationsManager.AnnotationPlace annotationAnnotationPlace = annotationsManager.chooseAnnotationsPlace((PsiElement)myModifierListOwner);
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.NOWHERE) {
            return;
        }
        if (annotationAnnotationPlace == ExternalAnnotationsManager.AnnotationPlace.EXTERNAL) {
            for (String fqn : this.myAnnotationsToRemove) {
                annotationsManager.deannotate(myModifierListOwner, fqn);
            }
            try {
                annotationsManager.annotateExternally(myModifierListOwner, this.myAnnotation, file2, this.myPairs);
            }
            catch (ExternalAnnotationsManager.CanceledConfigurationException canceledConfigurationException) {}
        } else {
            PsiFile containingFile = myModifierListOwner.getContainingFile();
            WriteCommandAction.runWriteCommandAction((Project)project2, null, null, () -> {
                AddAnnotationPsiFix.removePhysicalAnnotations(myModifierListOwner, this.myAnnotationsToRemove);
                PsiAnnotation inserted = AddAnnotationPsiFix.addPhysicalAnnotation(this.myAnnotation, this.myPairs, modifierList);
                JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)inserted);
            }, (PsiFile[])new PsiFile[]{containingFile});
            if (containingFile != file2) {
                UndoUtil.markPsiFileForUndo((PsiFile)file2);
            }
        }
    }

    public static PsiAnnotation addPhysicalAnnotation(String fqn, PsiNameValuePair[] pairs, PsiModifierList modifierList) {
        PsiAnnotation inserted = modifierList.addAnnotation(fqn);
        for (PsiNameValuePair pair : pairs) {
            inserted.setDeclaredAttributeValue(pair.getName(), pair.getValue());
        }
        return inserted;
    }

    public static void removePhysicalAnnotations(@NotNull PsiModifierListOwner owner, String ... fqns) {
        for (String fqn : fqns) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (boolean)true, (String[])new String[]{fqn});
            if (annotation == null || AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation)) continue;
            annotation.delete();
        }
    }

    @NotNull
    public String[] getAnnotationsToRemove() {
        return this.myAnnotationsToRemove;
    }
}

