/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ExternalAnnotationsManagerImpl;
import com.intellij.codeInsight.intention.AddAnnotationFix;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public abstract class AddAnnotationIntention
extends BaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.add.annotation.family", (Object[])new Object[0]);
    }

    @NotNull
    public abstract Pair<String, String[]> getAnnotations(@NotNull Project var1);

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiModifierListOwner owner = AddAnnotationPsiFix.getContainer(file2, editor.getCaretModel().getOffset());
        if (owner == null || !ExternalAnnotationsManagerImpl.areExternalAnnotationsApplicable(owner)) {
            return false;
        }
        Pair<String, String[]> annotations2 = this.getAnnotations(project2);
        String toAdd = (String)annotations2.first;
        String[] toRemove = (String[])annotations2.second;
        if (toRemove.length > 0 && AddAnnotationIntention.isAnnotatedSkipInferred(owner, toRemove)) {
            return false;
        }
        this.setText(AddAnnotationPsiFix.calcText(owner, toAdd));
        if (AddAnnotationIntention.isAnnotatedSkipInferred(owner, toAdd)) {
            return false;
        }
        return this.canAnnotate(owner);
    }

    protected boolean canAnnotate(@NotNull PsiModifierListOwner owner) {
        return true;
    }

    private static boolean isAnnotatedSkipInferred(PsiModifierListOwner owner, String ... annoFqns) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)owner, (boolean)false, (String[])annoFqns);
        return annotation != null && !AnnotationUtil.isInferredAnnotation((PsiAnnotation)annotation);
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiModifierListOwner owner = AddAnnotationPsiFix.getContainer(file2, editor.getCaretModel().getOffset());
        if (owner == null || !owner.isValid()) {
            return;
        }
        Pair<String, String[]> annotations2 = this.getAnnotations(project2);
        String toAdd = (String)annotations2.first;
        String[] toRemove = (String[])annotations2.second;
        AddAnnotationFix fix = new AddAnnotationFix(toAdd, owner, toRemove);
        fix.invoke(project2, editor, file2);
    }
}

