/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.FieldFromParameterUtils;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssignFieldFromParameterAction
extends BaseIntentionAction {
    private static final Logger LOG = Logger.getInstance(AssignFieldFromParameterAction.class);

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiClass targetClass;
        PsiType type2;
        PsiParameter myParameter = FieldFromParameterUtils.findParameterAtCursor(file2, editor);
        if (!FieldFromParameterUtils.isAvailable(myParameter, type2 = FieldFromParameterUtils.getType(myParameter), targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)myParameter, PsiClass.class))) {
            return false;
        }
        PsiField field = AssignFieldFromParameterAction.findFieldToAssign(project2, myParameter);
        if (field == null) {
            return false;
        }
        if (!field.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE)) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.assign.field.from.parameter.text", (Object[])new Object[]{field.getName()}));
        return true;
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.assign.field.from.parameter.family", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiParameter myParameter = FieldFromParameterUtils.findParameterAtCursor(file2, editor);
        IdeDocumentHistory.getInstance(project2).includeCurrentPlaceAsChangePlace();
        PsiField field = AssignFieldFromParameterAction.findFieldToAssign(project2, myParameter);
        if (field != null) {
            AssignFieldFromParameterAction.addFieldAssignmentStatement(project2, field, myParameter, editor);
        }
    }

    @Nullable
    private static PsiField findFieldToAssign(@NotNull Project project2, @NotNull PsiParameter myParameter) {
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project2);
        String parameterName = myParameter.getName();
        String propertyName = styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        PsiMethod method2 = (PsiMethod)myParameter.getDeclarationScope();
        boolean isMethodStatic = method2.hasModifierProperty("static");
        VariableKind kind2 = isMethodStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
        SuggestedNameInfo suggestedNameInfo = styleManager.suggestVariableName(kind2, propertyName, null, FieldFromParameterUtils.getSubstitutedType(myParameter));
        String fieldName = suggestedNameInfo.names[0];
        PsiClass aClass = method2.getContainingClass();
        if (aClass == null) {
            return null;
        }
        PsiField field = aClass.findFieldByName(fieldName, false);
        if (field == null) {
            return null;
        }
        if (!field.hasModifierProperty("static") && isMethodStatic) {
            return null;
        }
        return field;
    }

    public static PsiElement addFieldAssignmentStatement(@NotNull Project project2, @NotNull PsiField field, @NotNull PsiParameter parameter, @NotNull Editor editor) throws IncorrectOperationException {
        PsiMethod method2 = (PsiMethod)parameter.getDeclarationScope();
        PsiCodeBlock methodBody2 = method2.getBody();
        if (methodBody2 == null) {
            return null;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        String fieldName = field.getName();
        String parameterName = parameter.getName();
        boolean isMethodStatic = method2.hasModifierProperty("static");
        PsiClass targetClass = method2.getContainingClass();
        if (targetClass == null) {
            return null;
        }
        String stmtText = fieldName + " = " + parameterName + ";";
        if (Comparing.strEqual((String)fieldName, (String)parameterName) || JavaPsiFacade.getInstance((Project)project2).getResolveHelper().resolveReferencedVariable(fieldName, (PsiElement)methodBody2) != field) {
            String prefix = isMethodStatic ? (targetClass.getName() == null ? "" : targetClass.getName() + ".") : "this.";
            stmtText = prefix + stmtText;
        }
        PsiStatement assignmentStmt = (PsiStatement)CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)factory.createStatementFromText(stmtText, (PsiElement)methodBody2));
        PsiStatement[] statements = methodBody2.getStatements();
        int i2 = FieldFromParameterUtils.findFieldAssignmentAnchor(statements, null, targetClass, parameter);
        PsiElement inserted = i2 == statements.length ? methodBody2.add((PsiElement)assignmentStmt) : methodBody2.addAfter((PsiElement)assignmentStmt, i2 > 0 ? statements[i2 - 1] : null);
        editor.getCaretModel().moveToOffset(inserted.getTextRange().getEndOffset());
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        return inserted;
    }
}

