/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseColorIntentionAction
extends PsiElementBaseIntentionAction
implements HighPriorityAction {
    protected static final String JAVA_AWT_COLOR = "java.awt.Color";
    protected static final String COLOR_UI_RESOURCE = "javax.swing.plaf.ColorUIResource";

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiNewExpression expression2 = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class, (boolean)false, (Class[])new Class[]{PsiMember.class, PsiCodeBlock.class});
        return expression2 != null && BaseColorIntentionAction.isJavaAwtColor(expression2.getClassOrAnonymousClassReference()) && BaseColorIntentionAction.isValueArguments(expression2.getArgumentList());
    }

    private static boolean isJavaAwtColor(@Nullable PsiJavaCodeReferenceElement ref) {
        String fqn = BaseColorIntentionAction.getFqn(ref);
        return JAVA_AWT_COLOR.equals(fqn) || COLOR_UI_RESOURCE.equals(fqn);
    }

    @Nullable
    protected static String getFqn(@Nullable PsiJavaCodeReferenceElement ref) {
        PsiElement psiElement;
        PsiReference reference;
        if (ref != null && (reference = ref.getReference()) != null && (psiElement = reference.resolve()) instanceof PsiClass) {
            return ((PsiClass)psiElement).getQualifiedName();
        }
        return null;
    }

    private static boolean isValueArguments(@Nullable PsiExpressionList arguments) {
        if (arguments == null) {
            return false;
        }
        for (PsiExpression argument : arguments.getExpressions()) {
            if (!(argument instanceof PsiReferenceExpression)) continue;
            return false;
        }
        return true;
    }
}

