/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.generation.ClassMember;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.impl.BaseIntentionAction;
import com.intellij.codeInsight.intention.impl.CreateFieldFromParameterAction;
import com.intellij.codeInsight.intention.impl.FieldFromParameterUtils;
import com.intellij.codeInsight.intention.impl.ParameterClassMember;
import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BindFieldsFromParametersAction
extends BaseIntentionAction
implements HighPriorityAction {
    private static final Logger LOG = Logger.getInstance(CreateFieldFromParameterAction.class);
    private static final Key<Map<SmartPsiElementPointer<PsiParameter>, Boolean>> PARAMS = Key.create((String)"FIELDS_FROM_PARAMS");
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        PsiParameter psiParameter = FieldFromParameterUtils.findParameterAtCursor(file2, editor);
        PsiMethod method2 = BindFieldsFromParametersAction.findMethod(psiParameter, editor, file2);
        if (method2 == null) {
            return false;
        }
        List<PsiParameter> parameters2 = BindFieldsFromParametersAction.getAvailableParameters(method2);
        Object object = LOCK;
        synchronized (object) {
            Collection<SmartPsiElementPointer<PsiParameter>> params = BindFieldsFromParametersAction.getUnboundedParams(method2);
            params.clear();
            for (PsiParameter parameter : parameters2) {
                params.add((SmartPsiElementPointer<PsiParameter>)SmartPointerManager.getInstance((Project)project2).createSmartPsiElementPointer((PsiElement)parameter));
            }
            if (params.isEmpty()) {
                return false;
            }
            if (params.size() == 1 && psiParameter != null) {
                return false;
            }
            if (psiParameter == null) {
                psiParameter = (PsiParameter)params.iterator().next().getElement();
                LOG.assertTrue(psiParameter != null);
            }
            this.setText(CodeInsightBundle.message((String)"intention.bind.fields.from.parameters.text", (Object[])new Object[]{method2.isConstructor() ? "constructor" : "method"}));
        }
        return BindFieldsFromParametersAction.isAvailable(psiParameter);
    }

    @Nullable
    private static PsiMethod findMethod(@Nullable PsiParameter parameter, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (parameter == null) {
            PsiElement parent;
            PsiElement elementAt = file2.findElementAt(editor.getCaretModel().getOffset());
            if (elementAt instanceof PsiIdentifier && (parent = elementAt.getParent()) instanceof PsiMethod) {
                return (PsiMethod)parent;
            }
        } else {
            PsiElement declarationScope = parameter.getDeclarationScope();
            if (declarationScope instanceof PsiMethod) {
                return (PsiMethod)declarationScope;
            }
        }
        return null;
    }

    @NotNull
    private static List<PsiParameter> getAvailableParameters(@NotNull PsiMethod method2) {
        ArrayList<PsiParameter> parameters2 = new ArrayList<PsiParameter>();
        for (PsiParameter parameter : method2.getParameterList().getParameters()) {
            if (!BindFieldsFromParametersAction.isAvailable(parameter)) continue;
            parameters2.add(parameter);
        }
        return parameters2;
    }

    private static boolean isAvailable(PsiParameter psiParameter) {
        PsiClass targetClass;
        PsiType type2 = FieldFromParameterUtils.getSubstitutedType(psiParameter);
        return FieldFromParameterUtils.isAvailable(psiParameter, type2, targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiParameter, PsiClass.class)) && psiParameter.getLanguage().isKindOf((Language)JavaLanguage.INSTANCE);
    }

    @NotNull
    private static Collection<SmartPsiElementPointer<PsiParameter>> getUnboundedParams(PsiMethod psiMethod) {
        Map params = (Map)psiMethod.getUserData(PARAMS);
        if (params == null) {
            params = ContainerUtil.createConcurrentWeakMap();
            psiMethod.putUserData(PARAMS, (Object)params);
        }
        final Map finalParams = params;
        return new AbstractCollection<SmartPsiElementPointer<PsiParameter>>(){

            @Override
            public boolean add(SmartPsiElementPointer<PsiParameter> psiVariable) {
                return finalParams.put(psiVariable, Boolean.TRUE) == null;
            }

            @Override
            public Iterator<SmartPsiElementPointer<PsiParameter>> iterator() {
                return finalParams.keySet().iterator();
            }

            @Override
            public int size() {
                return finalParams.size();
            }

            @Override
            public void clear() {
                finalParams.clear();
            }
        };
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.bind.fields.from.parameters.family", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) {
        BindFieldsFromParametersAction.invoke(project2, editor, file2, !ApplicationManager.getApplication().isUnitTestMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invoke(Project project2, Editor editor, PsiFile file2, boolean isInteractive) {
        PsiParameter psiParameter = FieldFromParameterUtils.findParameterAtCursor(file2, editor);
        if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
            return;
        }
        PsiMethod method2 = psiParameter != null ? (PsiMethod)psiParameter.getDeclarationScope() : (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(editor.getCaretModel().getOffset()), PsiMethod.class);
        LOG.assertTrue(method2 != null);
        HashSet<String> usedNames = new HashSet<String>();
        Iterable<PsiParameter> parameters2 = BindFieldsFromParametersAction.selectParameters(project2, method2, BindFieldsFromParametersAction.copyUnboundedParamsAndClearOriginal(method2), isInteractive);
        MultiMap types = new MultiMap();
        for (PsiParameter parameter : parameters2) {
            types.putValue((Object)parameter.getType(), (Object)parameter);
        }
        CodeStyleSettings settings = CodeStyleSettingsManager.getSettings((Project)project2);
        boolean preferLongerNames = settings.PREFER_LONGER_NAMES;
        for (PsiParameter selected : parameters2) {
            try {
                settings.PREFER_LONGER_NAMES = preferLongerNames || types.get((Object)selected.getType()).size() > 1;
                BindFieldsFromParametersAction.processParameter(project2, selected, usedNames);
            }
            finally {
                settings.PREFER_LONGER_NAMES = preferLongerNames;
            }
        }
    }

    @NotNull
    private static Iterable<PsiParameter> selectParameters(@NotNull Project project2, @NotNull PsiMethod method2, @NotNull Collection<SmartPsiElementPointer<PsiParameter>> unboundedParams, boolean isInteractive) {
        if (unboundedParams.size() < 2 || !isInteractive) {
            return BindFieldsFromParametersAction.revealPointers(unboundedParams);
        }
        ParameterClassMember[] members = BindFieldsFromParametersAction.sortByParameterIndex(BindFieldsFromParametersAction.toClassMemberArray(unboundedParams), method2);
        MemberChooser<ParameterClassMember> chooser = BindFieldsFromParametersAction.showChooser(project2, method2, members);
        List<ParameterClassMember> selectedElements = chooser.getSelectedElements();
        if (chooser.getExitCode() != 0 || selectedElements == null) {
            return Collections.emptyList();
        }
        return BindFieldsFromParametersAction.revealParameterClassMembers(selectedElements);
    }

    @NotNull
    private static MemberChooser<ParameterClassMember> showChooser(@NotNull Project project2, @NotNull PsiMethod method2, @NotNull ParameterClassMember[] members) {
        MemberChooser chooser = new MemberChooser((ClassMember[])members, false, true, project2);
        chooser.selectElements(BindFieldsFromParametersAction.getInitialSelection(method2, members));
        chooser.setTitle("Choose " + (method2.isConstructor() ? "Constructor" : "Method") + " Parameters");
        chooser.show();
        return chooser;
    }

    private static ParameterClassMember[] getInitialSelection(@NotNull PsiMethod method2, @NotNull ParameterClassMember[] members) {
        PsiMethod calledMethod;
        PsiExpression expression2;
        HashSet resolvedInSuperOrThis = new HashSet();
        PsiCodeBlock body2 = method2.getBody();
        LOG.assertTrue(body2 != null);
        PsiStatement[] statements = body2.getStatements();
        if (statements.length > 0 && statements[0] instanceof PsiExpressionStatement && (expression2 = ((PsiExpressionStatement)statements[0]).getExpression()) instanceof PsiMethodCallExpression && (calledMethod = ((PsiMethodCallExpression)expression2).resolveMethod()) != null && calledMethod.isConstructor()) {
            for (PsiExpression arg : ((PsiMethodCallExpression)expression2).getArgumentList().getExpressions()) {
                if (!(arg instanceof PsiReferenceExpression)) continue;
                ContainerUtil.addIfNotNull((Object)((PsiReferenceExpression)arg).resolve(), resolvedInSuperOrThis);
            }
        }
        return ContainerUtil.findAll((Object[])members, member -> !resolvedInSuperOrThis.contains(member.getParameter())).toArray(ParameterClassMember.EMPTY_ARRAY);
    }

    @NotNull
    private static ParameterClassMember[] sortByParameterIndex(@NotNull ParameterClassMember[] members, @NotNull PsiMethod method2) {
        PsiParameterList parameterList = method2.getParameterList();
        Arrays.sort(members, (o1, o2) -> parameterList.getParameterIndex(o1.getParameter()) - parameterList.getParameterIndex(o2.getParameter()));
        return members;
    }

    @NotNull
    private static <T extends PsiElement> List<T> revealPointers(@NotNull Iterable<SmartPsiElementPointer<T>> pointers) {
        ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
        for (SmartPsiElementPointer<T> pointer : pointers) {
            result2.add(pointer.getElement());
        }
        return result2;
    }

    @NotNull
    private static List<PsiParameter> revealParameterClassMembers(@NotNull Iterable<ParameterClassMember> parameterClassMembers) {
        ArrayList<PsiParameter> result2 = new ArrayList<PsiParameter>();
        for (ParameterClassMember parameterClassMember : parameterClassMembers) {
            result2.add(parameterClassMember.getParameter());
        }
        return result2;
    }

    @NotNull
    private static ParameterClassMember[] toClassMemberArray(@NotNull Collection<SmartPsiElementPointer<PsiParameter>> unboundedParams) {
        ParameterClassMember[] result2 = new ParameterClassMember[unboundedParams.size()];
        int i2 = 0;
        for (SmartPsiElementPointer<PsiParameter> pointer : unboundedParams) {
            result2[i2++] = new ParameterClassMember((PsiParameter)pointer.getElement());
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Collection<SmartPsiElementPointer<PsiParameter>> copyUnboundedParamsAndClearOriginal(@NotNull PsiMethod method2) {
        Object object = LOCK;
        synchronized (object) {
            Collection<SmartPsiElementPointer<PsiParameter>> unboundedParams = BindFieldsFromParametersAction.getUnboundedParams(method2);
            ArrayList<SmartPsiElementPointer<PsiParameter>> result2 = new ArrayList<SmartPsiElementPointer<PsiParameter>>(unboundedParams);
            unboundedParams.clear();
            return result2;
        }
    }

    private static void processParameter(Project project2, PsiParameter parameter, Set<String> usedNames) {
        IdeDocumentHistory.getInstance(project2).includeCurrentPlaceAsChangePlace();
        PsiType type2 = FieldFromParameterUtils.getSubstitutedType(parameter);
        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project2);
        String parameterName = parameter.getName();
        String propertyName = styleManager.variableNameToPropertyName(parameterName, VariableKind.PARAMETER);
        PsiClass targetClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parameter, PsiClass.class);
        PsiElement declarationScope = parameter.getDeclarationScope();
        if (!(declarationScope instanceof PsiMethod)) {
            return;
        }
        PsiMethod method2 = (PsiMethod)declarationScope;
        boolean isMethodStatic = method2.hasModifierProperty("static");
        VariableKind kind2 = isMethodStatic ? VariableKind.STATIC_FIELD : VariableKind.FIELD;
        SuggestedNameInfo suggestedNameInfo = styleManager.suggestVariableName(kind2, propertyName, null, type2);
        String[] names = suggestedNameInfo.names;
        boolean isFinal = !isMethodStatic && method2.isConstructor();
        String name = names[0];
        if (targetClass != null) {
            for (String curName : names) {
                PsiField fieldByName;
                if (usedNames.contains(curName) || (fieldByName = targetClass.findFieldByName(curName, false)) == null || method2.isConstructor() && BindFieldsFromParametersAction.isFieldAssigned(fieldByName, method2) || !fieldByName.getType().isAssignableFrom(parameter.getType())) continue;
                name = curName;
                break;
            }
        }
        if (usedNames.contains(name)) {
            for (String curName : names) {
                if (usedNames.contains(curName)) continue;
                name = curName;
                break;
            }
        }
        String fieldName = usedNames.add(name) ? name : JavaCodeStyleManager.getInstance((Project)project2).suggestUniqueVariableName(name, (PsiElement)parameter, true);
        ApplicationManager.getApplication().runWriteAction(() -> {
            try {
                FieldFromParameterUtils.createFieldAndAddAssignment(project2, targetClass, method2, parameter, type2, fieldName, isMethodStatic, isFinal);
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        });
    }

    private static boolean isFieldAssigned(PsiField field, PsiMethod method2) {
        for (PsiReference reference : ReferencesSearch.search((PsiElement)field, (SearchScope)new LocalSearchScope((PsiElement)method2))) {
            if (!(reference instanceof PsiReferenceExpression) || !PsiUtil.isOnAssignmentLeftHand((PsiExpression)((PsiReferenceExpression)reference))) continue;
            return true;
        }
        return false;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

