/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class BreakStringOnLineBreaksIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (token.getTokenType() != JavaTokenType.STRING_LITERAL) {
            return false;
        }
        String text = token.getText();
        if (text == null) {
            return false;
        }
        int indexOfSlashN = text.indexOf("\\n");
        if (indexOfSlashN == -1 || Comparing.equal((String)text.substring(indexOfSlashN, text.length()), (String)"\\n\"")) {
            return false;
        }
        int indexOfSlashNSlashR = text.indexOf("\\n\\r");
        return indexOfSlashNSlashR == -1 || !Comparing.equal((String)text.substring(indexOfSlashNSlashR, text.length()), (String)"\\n\\r\"");
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (!(element instanceof PsiJavaToken)) {
            return;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (token.getTokenType() != JavaTokenType.STRING_LITERAL) {
            return;
        }
        String text = token.getText();
        if (text == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        token.replace((PsiElement)factory.createExpressionFromText(BreakStringOnLineBreaksIntentionAction.breakOnLineBreaks(text), element));
    }

    @NotNull
    private static String breakOnLineBreaks(@NotNull String string) {
        String result2 = StringUtil.replace((String)string, (String[])new String[]{"\\n\\r", "\\n"}, (String[])new String[]{"\\n\\r\" + \n\"", "\\n\" + \n\""});
        String redundantSuffix = " + \n\"\"";
        return result2.endsWith(" + \n\"\"") ? result2.substring(0, result2.length() - " + \n\"\"".length()) : result2;
    }

    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"intention.break.string.on.line.breaks.text", (Object[])new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }
}

