/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.impl.BaseColorIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.util.ConstantEvaluationOverflowException;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertColorRepresentationIntentionAction
extends BaseColorIntentionAction {
    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiExpressionList newArguments;
        if (!super.isAvailable(project2, editor, element)) {
            return false;
        }
        PsiNewExpression expression2 = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class, (boolean)false);
        if (expression2 == null) {
            return false;
        }
        PsiExpressionList arguments = expression2.getArgumentList();
        if (arguments == null) {
            return false;
        }
        PsiMethod constructor = expression2.resolveConstructor();
        if (constructor == null) {
            return false;
        }
        try {
            newArguments = ConvertColorRepresentationIntentionAction.createNewArguments(JavaPsiFacade.getElementFactory((Project)project2), constructor.getParameterList().getParameters(), arguments.getExpressions());
        }
        catch (ConstantEvaluationOverflowException e) {
            return false;
        }
        if (newArguments == null) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.convert.color.representation.text", (Object[])new Object[]{newArguments.getText()}));
        return true;
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiNewExpression expression2 = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class, (boolean)false);
        if (expression2 == null) {
            return;
        }
        PsiExpressionList arguments = expression2.getArgumentList();
        if (arguments == null) {
            return;
        }
        PsiMethod constructor = expression2.resolveConstructor();
        if (constructor == null) {
            return;
        }
        PsiExpressionList newArguments = ConvertColorRepresentationIntentionAction.createNewArguments(JavaPsiFacade.getElementFactory((Project)project2), constructor.getParameterList().getParameters(), arguments.getExpressions());
        if (newArguments == null) {
            return;
        }
        arguments.replace((PsiElement)newArguments);
    }

    @Nullable
    private static PsiExpressionList createNewArguments(@NotNull PsiElementFactory factory, @NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments) {
        String[] newValues = ConvertColorRepresentationIntentionAction.createArguments(parameters2, arguments);
        if (newValues == null) {
            return null;
        }
        PsiExpressionList result2 = ((PsiNewExpression)factory.createExpressionFromText("new Object()", (PsiElement)parameters2[0])).getArgumentList();
        if (result2 == null) {
            return null;
        }
        for (String value2 : newValues) {
            result2.add((PsiElement)factory.createExpressionFromText(value2, (PsiElement)parameters2[0]));
        }
        return result2;
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiParameter[] parameters2, @NotNull PsiExpression[] arguments) {
        if (parameters2.length != arguments.length) {
            return null;
        }
        switch (parameters2.length) {
            default: {
                return null;
            }
            case 1: {
                return ConvertColorRepresentationIntentionAction.createArguments(arguments[0]);
            }
            case 2: {
                return ConvertColorRepresentationIntentionAction.createArguments(arguments[0], arguments[1]);
            }
            case 3: {
                return ConvertColorRepresentationIntentionAction.createArguments(arguments[0], arguments[1], arguments[2]);
            }
            case 4: 
        }
        return ConvertColorRepresentationIntentionAction.createArguments(arguments[0], arguments[1], arguments[2], arguments[3]);
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiExpression rgbExpression) {
        return ConvertColorRepresentationIntentionAction.createArguments(rgbExpression, 3);
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiExpression rgbExpression, @NotNull PsiExpression hasAlphaExpression) {
        Boolean hasAlpha = ConvertColorRepresentationIntentionAction.computeBoolean(hasAlphaExpression);
        if (hasAlpha == null) {
            return null;
        }
        return hasAlpha != false ? ConvertColorRepresentationIntentionAction.createArguments(rgbExpression, 4) : ConvertColorRepresentationIntentionAction.createArguments(rgbExpression);
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiExpression rExpression, @NotNull PsiExpression gExpression, @NotNull PsiExpression bExpression) {
        String[] stringArray;
        Integer value2 = ConvertColorRepresentationIntentionAction.createInt(ConvertColorRepresentationIntentionAction.computeInteger(rExpression), ConvertColorRepresentationIntentionAction.computeInteger(gExpression), ConvertColorRepresentationIntentionAction.computeInteger(bExpression));
        if (value2 != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "0x" + Integer.toHexString(value2);
        } else {
            stringArray = null;
        }
        return stringArray;
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiExpression rExpression, @NotNull PsiExpression gExpression, @NotNull PsiExpression bExpression, @NotNull PsiExpression aExpression) {
        Integer value2 = ConvertColorRepresentationIntentionAction.createInt(ConvertColorRepresentationIntentionAction.computeInteger(rExpression), ConvertColorRepresentationIntentionAction.computeInteger(gExpression), ConvertColorRepresentationIntentionAction.computeInteger(bExpression), ConvertColorRepresentationIntentionAction.computeInteger(aExpression));
        if (value2 == null) {
            return null;
        }
        return new String[]{"0x" + Integer.toHexString(value2), "true"};
    }

    @Nullable
    private static String[] createArguments(@NotNull PsiExpression rgbExpression, int parts) {
        Integer rgb = ConvertColorRepresentationIntentionAction.computeInteger(rgbExpression);
        if (rgb == null) {
            return null;
        }
        String[] result2 = new String[parts];
        for (int i2 = 0; i2 < result2.length; ++i2) {
            result2[result2.length - i2 - 1] = String.valueOf(rgb >> i2 * 8 & 0xFF);
        }
        return result2;
    }

    @Nullable
    private static Integer createInt(Integer ... ints) {
        int result2 = 0;
        for (Integer i2 : ints) {
            if (i2 == null) {
                return null;
            }
            result2 = result2 << 8 | i2 & 0xFF;
        }
        return result2;
    }

    @Nullable
    public static Integer computeInteger(@NotNull PsiExpression expr) {
        Object result2 = ConvertColorRepresentationIntentionAction.compute(expr);
        return result2 instanceof Integer ? (Integer)result2 : null;
    }

    @Nullable
    public static Boolean computeBoolean(@NotNull PsiExpression expr) {
        Object result2 = ConvertColorRepresentationIntentionAction.compute(expr);
        return result2 instanceof Boolean ? (Boolean)result2 : null;
    }

    @Nullable
    private static Object compute(@NotNull PsiExpression expr) {
        return JavaConstantExpressionEvaluator.computeConstantExpression(expr, true);
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.convert.color.representation.family", (Object[])new Object[0]);
    }
}

