/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.ClassKind;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameHelper;
import com.intellij.refactoring.MoveDestination;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.move.moveClassesOrPackages.DestinationFolderComboBox;
import com.intellij.refactoring.move.moveClassesOrPackages.MultipleRootsMoveDestination;
import com.intellij.refactoring.ui.PackageNameReferenceEditorCombo;
import com.intellij.refactoring.util.RefactoringMessageUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorComboBox;
import com.intellij.ui.RecentsManager;
import com.intellij.ui.ReferenceEditorComboWithBrowseButton;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateClassDialog
extends DialogWrapper {
    private final JLabel myInformationLabel = new JLabel("#");
    private final JLabel myPackageLabel = new JLabel(CodeInsightBundle.message((String)"dialog.create.class.destination.package.label", (Object[])new Object[0]));
    private final ReferenceEditorComboWithBrowseButton myPackageComponent;
    private final JTextField myTfClassName = new MyTextField();
    private final Project myProject;
    private PsiDirectory myTargetDirectory;
    private final String myClassName;
    private final boolean myClassNameEditable;
    private final Module myModule;
    private final DestinationFolderComboBox myDestinationCB = new DestinationFolderComboBox(){

        @Override
        public String getTargetPackage() {
            return CreateClassDialog.this.myPackageComponent.getText().trim();
        }

        @Override
        protected boolean reportBaseInTestSelectionInSource() {
            return CreateClassDialog.this.reportBaseInTestSelectionInSource();
        }

        @Override
        protected boolean reportBaseInSourceSelectionInTest() {
            return CreateClassDialog.this.reportBaseInSourceSelectionInTest();
        }
    };
    @NonNls
    private static final String RECENTS_KEY = "CreateClassDialog.RecentsKey";

    public CreateClassDialog(@NotNull Project project2, @NotNull String title, @NotNull String targetClassName, @NotNull String targetPackageName, @NotNull ClassKind kind2, boolean classNameEditable, @Nullable Module defaultModule) {
        super(project2, true);
        this.myClassNameEditable = classNameEditable;
        this.myModule = defaultModule;
        this.myClassName = targetClassName;
        this.myProject = project2;
        this.myPackageComponent = new PackageNameReferenceEditorCombo(targetPackageName, this.myProject, RECENTS_KEY, CodeInsightBundle.message((String)"dialog.create.class.package.chooser.title", (Object[])new Object[0]));
        this.myPackageComponent.setTextFieldPreferredWidth(40);
        this.init();
        if (!this.myClassNameEditable) {
            this.setTitle(CodeInsightBundle.message((String)"dialog.create.class.name", (Object[])new Object[]{StringUtil.capitalize((String)kind2.getDescription()), targetClassName}));
        } else {
            this.myInformationLabel.setText(CodeInsightBundle.message((String)"dialog.create.class.label", (Object[])new Object[]{kind2.getDescription()}));
            this.setTitle(title);
        }
        this.myTfClassName.setText(this.myClassName);
        this.myDestinationCB.setData(this.myProject, this.getBaseDir(targetPackageName), new Pass<String>(){

            public void pass(String s) {
                CreateClassDialog.this.setErrorText(s, (JComponent)((Object)CreateClassDialog.this.myDestinationCB));
            }
        }, (EditorComboBox)this.myPackageComponent.getChildComponent());
    }

    protected boolean reportBaseInTestSelectionInSource() {
        return false;
    }

    protected boolean reportBaseInSourceSelectionInTest() {
        return false;
    }

    @NotNull
    protected Action[] createActions() {
        return new Action[]{this.getOKAction(), this.getCancelAction()};
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myClassNameEditable ? this.myTfClassName : this.myPackageComponent.getChildComponent();
    }

    protected JComponent createCenterPanel() {
        return new JPanel(new BorderLayout());
    }

    protected JComponent createNorthPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gbConstraints = new GridBagConstraints();
        gbConstraints.insets = JBUI.insets((int)4, (int)8);
        gbConstraints.fill = 2;
        gbConstraints.anchor = 17;
        if (this.myClassNameEditable) {
            gbConstraints.weightx = 0.0;
            gbConstraints.gridwidth = 1;
            panel2.add((Component)this.myInformationLabel, gbConstraints);
            gbConstraints.insets = JBUI.insets((int)4, (int)8);
            gbConstraints.gridx = 1;
            gbConstraints.weightx = 1.0;
            gbConstraints.gridwidth = 1;
            gbConstraints.fill = 2;
            gbConstraints.anchor = 17;
            panel2.add((Component)this.myTfClassName, gbConstraints);
            this.myTfClassName.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    CreateClassDialog.this.getOKAction().setEnabled(PsiNameHelper.getInstance((Project)CreateClassDialog.this.myProject).isIdentifier(CreateClassDialog.this.myTfClassName.getText()));
                }
            });
            this.getOKAction().setEnabled(StringUtil.isNotEmpty((String)this.myClassName));
        }
        gbConstraints.gridx = 0;
        gbConstraints.gridy = 2;
        gbConstraints.weightx = 0.0;
        gbConstraints.gridwidth = 1;
        panel2.add((Component)this.myPackageLabel, gbConstraints);
        gbConstraints.gridx = 1;
        gbConstraints.weightx = 1.0;
        new AnAction(){

            public void actionPerformed(AnActionEvent e) {
                CreateClassDialog.this.myPackageComponent.getButton().doClick();
            }
        }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(10, 64)), this.myPackageComponent.getChildComponent());
        JPanel _panel = new JPanel(new BorderLayout());
        _panel.add((Component)((Object)this.myPackageComponent), "Center");
        panel2.add((Component)_panel, gbConstraints);
        gbConstraints.gridy = 3;
        gbConstraints.gridx = 0;
        gbConstraints.gridwidth = 2;
        gbConstraints.insets.top = 12;
        gbConstraints.anchor = 17;
        gbConstraints.fill = 0;
        JBLabel label = new JBLabel(RefactoringBundle.message((String)"target.destination.folder"));
        panel2.add((Component)label, gbConstraints);
        gbConstraints.gridy = 4;
        gbConstraints.gridx = 0;
        gbConstraints.fill = 2;
        gbConstraints.insets.top = 4;
        panel2.add((Component)((Object)this.myDestinationCB), gbConstraints);
        boolean isMultipleSourceRoots = JavaProjectRootsUtil.getSuitableDestinationSourceRoots(this.myProject).size() > 1;
        this.myDestinationCB.setVisible(isMultipleSourceRoots);
        label.setVisible(isMultipleSourceRoots);
        label.setLabelFor((Component)((Object)this.myDestinationCB));
        return panel2;
    }

    public PsiDirectory getTargetDirectory() {
        return this.myTargetDirectory;
    }

    private String getPackageName() {
        String name = this.myPackageComponent.getText();
        return name != null ? name.trim() : "";
    }

    protected void doOKAction() {
        RecentsManager.getInstance(this.myProject).registerRecentEntry(RECENTS_KEY, this.myPackageComponent.getText());
        final String packageName = this.getPackageName();
        final String[] errorString = new String[1];
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            try {
                PackageWrapper targetPackage = new PackageWrapper(PsiManager.getInstance((Project)this.myProject), packageName);
                final MoveDestination destination = this.myDestinationCB.selectDirectory(targetPackage, false);
                if (destination == null) {
                    return;
                }
                this.myTargetDirectory = (PsiDirectory)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<PsiDirectory>(){

                    public PsiDirectory compute() {
                        PsiDirectory baseDir = CreateClassDialog.this.getBaseDir(packageName);
                        if (baseDir == null && destination instanceof MultipleRootsMoveDestination) {
                            errorString[0] = "Destination not found for package '" + packageName + "'";
                            return null;
                        }
                        return destination.getTargetDirectory(baseDir);
                    }
                });
                if (this.myTargetDirectory == null) {
                    return;
                }
                errorString[0] = RefactoringMessageUtil.checkCanCreateClass(this.myTargetDirectory, this.getClassName());
            }
            catch (IncorrectOperationException e) {
                errorString[0] = e.getMessage();
            }
        }, CodeInsightBundle.message((String)"create.directory.command", (Object[])new Object[0]), null);
        if (errorString[0] != null) {
            if (errorString[0].length() > 0) {
                Messages.showMessageDialog((Project)this.myProject, (String)errorString[0], (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
            }
            return;
        }
        super.doOKAction();
    }

    @Nullable
    protected PsiDirectory getBaseDir(String packageName) {
        return this.myModule == null ? null : PackageUtil.findPossiblePackageDirectoryInModule(this.myModule, packageName);
    }

    @NotNull
    public String getClassName() {
        if (this.myClassNameEditable) {
            return this.myTfClassName.getText();
        }
        return this.myClassName;
    }

    private static class MyTextField
    extends JTextField {
        private MyTextField() {
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            size.width = fontMetrics.charWidth('a') * 40;
            return size;
        }
    }
}

