/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.BaseElementAtCaretIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateSwitchIntention
extends BaseElementAtCaretIntentionAction {
    public static final String TEXT = "Create switch statement";

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiExpressionStatement expressionStatement = CreateSwitchIntention.resolveExpressionStatement(element);
        PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project2).getElementFactory();
        PsiSwitchStatement switchStatement = (PsiSwitchStatement)elementFactory.createStatementFromText(String.format("switch (%s) {}", expressionStatement.getExpression().getText()), null);
        switchStatement = (PsiSwitchStatement)expressionStatement.replace((PsiElement)switchStatement);
        CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)switchStatement);
        PsiJavaToken lBrace = switchStatement.getBody().getLBrace();
        editor.getCaretModel().moveToOffset(lBrace.getTextOffset() + lBrace.getTextLength());
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiExpressionStatement expressionStatement = CreateSwitchIntention.resolveExpressionStatement(element);
        return expressionStatement != null && CreateSwitchIntention.isValidTypeForSwitch(expressionStatement.getExpression().getType(), (PsiElement)expressionStatement);
    }

    private static PsiExpressionStatement resolveExpressionStatement(PsiElement element) {
        if (element instanceof PsiExpressionStatement) {
            return (PsiExpressionStatement)element;
        }
        PsiStatement psiStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)element, PsiStatement.class);
        return psiStatement instanceof PsiExpressionStatement ? (PsiExpressionStatement)psiStatement : null;
    }

    private static boolean isValidTypeForSwitch(@Nullable PsiType type2, PsiElement context) {
        if (type2 == null) {
            return false;
        }
        if (type2 instanceof PsiClassType) {
            PsiClass resolvedClass = ((PsiClassType)type2).resolve();
            if (resolvedClass == null) {
                return false;
            }
            return PsiUtil.isLanguageLevel5OrHigher((PsiElement)context) && resolvedClass.isEnum() || PsiUtil.isLanguageLevel7OrHigher((PsiElement)context) && "java.lang.String".equals(resolvedClass.getQualifiedName());
        }
        return type2.equals(PsiType.INT) || type2.equals(PsiType.BYTE) || type2.equals(PsiType.SHORT) || type2.equals(PsiType.CHAR);
    }

    @NotNull
    public String getFamilyName() {
        return TEXT;
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }
}

