/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.SyntheticElement;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.refactoring.encapsulateFields.EncapsulateFieldsHandler;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncapsulateFieldAction
extends BaseRefactoringIntentionAction {
    @NotNull
    public String getText() {
        return CodeInsightBundle.message((String)"intention.encapsulate.field.text", (Object[])new Object[0]);
    }

    @NotNull
    public final String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (element instanceof SyntheticElement) {
            return false;
        }
        PsiField field = EncapsulateFieldAction.getField(element);
        return field != null && !field.hasModifierProperty("final") && !field.hasModifierProperty("private");
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiField field = EncapsulateFieldAction.getField(element);
        if (field == null) {
            return;
        }
        new EncapsulateFieldsHandler().invoke(project2, new PsiElement[]{field}, null);
    }

    @Nullable
    protected static PsiField getField(@Nullable PsiElement element) {
        if (element == null || !(element instanceof PsiIdentifier)) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent == null || !(parent instanceof PsiReferenceExpression)) {
            return null;
        }
        PsiReferenceExpression ref = (PsiReferenceExpression)parent;
        PsiExpression qualifier = ref.getQualifierExpression();
        if (qualifier == null || qualifier instanceof PsiThisExpression) {
            return null;
        }
        PsiElement resolved = ref.resolve();
        if (resolved == null || !(resolved instanceof PsiField)) {
            return null;
        }
        return (PsiField)resolved;
    }

    public boolean startInWriteAction() {
        return false;
    }
}

