/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PushConditionInCallAction
extends PsiElementBaseIntentionAction {
    @NotNull
    public String getFamilyName() {
        return "Push condition inside call";
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (element instanceof PsiCompiledElement) {
            return false;
        }
        if (!element.getManager().isInProject(element)) {
            return false;
        }
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiConditionalExpression.class);
        if (conditionalExpression == null) {
            return false;
        }
        String conditionText = conditionalExpression.getCondition().getText();
        PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
        PsiExpression elseExpression2 = conditionalExpression.getElseExpression();
        return this.isAvailable(conditionText, thenExpression2, elseExpression2, 0);
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiConditionalExpression conditionalExpression = (PsiConditionalExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiConditionalExpression.class);
        if (conditionalExpression == null) {
            return;
        }
        PsiExpression thenExpression2 = conditionalExpression.getThenExpression();
        if (thenExpression2 == null) {
            return;
        }
        thenExpression2 = (PsiExpression)thenExpression2.copy();
        PushConditionInCallAction.replaceRecursively(project2, conditionalExpression, thenExpression2, conditionalExpression.getElseExpression());
        CodeStyleManager.getInstance((Project)project2).reformat(conditionalExpression.replace((PsiElement)thenExpression2));
    }

    private boolean isAvailable(String conditionText, PsiExpression thenExpression2, PsiExpression elseExpression2, int level) {
        if (!(thenExpression2 instanceof PsiCallExpression)) {
            return false;
        }
        PsiMethod thenMethod = ((PsiCallExpression)thenExpression2).resolveMethod();
        PsiExpressionList thenArgsList = ((PsiCallExpression)thenExpression2).getArgumentList();
        if (thenArgsList == null) {
            return false;
        }
        PsiExpression[] thenExpressions = thenArgsList.getExpressions();
        if (!(elseExpression2 instanceof PsiCallExpression)) {
            return false;
        }
        PsiMethod elseMethod = ((PsiCallExpression)elseExpression2).resolveMethod();
        PsiExpressionList elseArgsList = ((PsiCallExpression)elseExpression2).getArgumentList();
        if (elseArgsList == null) {
            return false;
        }
        PsiExpression[] elseExpressions = elseArgsList.getExpressions();
        if (thenMethod != elseMethod || thenMethod == null) {
            return false;
        }
        if (thenExpressions.length != elseExpressions.length) {
            return false;
        }
        Pair<PsiExpression, PsiExpression> qualifiers = PushConditionInCallAction.getQualifiers(thenExpression2, elseExpression2);
        if (qualifiers != null) {
            if (!PushConditionInCallAction.isSameCall(thenExpressions, elseExpressions) && level == 0) {
                return false;
            }
            if (level > 0) {
                this.setText("Push condition '" + conditionText + "' inside " + (thenMethod.isConstructor() ? "constructor" : "method") + " call");
                return true;
            }
            return level > 0 || this.isAvailable(conditionText, (PsiExpression)qualifiers.first, (PsiExpression)qualifiers.second, level + 1);
        }
        PsiExpression tExpr = null;
        for (int i2 = 0; i2 < thenExpressions.length; ++i2) {
            PsiExpression lExpr = thenExpressions[i2];
            PsiExpression rExpr = elseExpressions[i2];
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)lExpr, (PsiElement)rExpr)) continue;
            if (tExpr == null) {
                tExpr = lExpr;
                continue;
            }
            return false;
        }
        this.setText("Push condition '" + conditionText + "' inside " + (thenMethod.isConstructor() ? "constructor" : "method") + " call");
        return true;
    }

    private static boolean isSameCall(PsiExpression[] thenExpressions, PsiExpression[] elseExpressions) {
        for (int i2 = 0; i2 < thenExpressions.length; ++i2) {
            PsiExpression lExpr = thenExpressions[i2];
            PsiExpression rExpr = elseExpressions[i2];
            if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)lExpr, (PsiElement)rExpr)) continue;
            return false;
        }
        return true;
    }

    private static Pair<PsiExpression, PsiExpression> getQualifiers(PsiExpression thenExpression2, PsiExpression elseExpression2) {
        PsiExpression thenQualifier = null;
        PsiExpression elseQualifier = null;
        if (thenExpression2 instanceof PsiMethodCallExpression && elseExpression2 instanceof PsiMethodCallExpression) {
            thenQualifier = ((PsiMethodCallExpression)thenExpression2).getMethodExpression().getQualifierExpression();
            elseQualifier = ((PsiMethodCallExpression)elseExpression2).getMethodExpression().getQualifierExpression();
        } else if (thenExpression2 instanceof PsiNewExpression && elseExpression2 instanceof PsiNewExpression) {
            thenQualifier = ((PsiNewExpression)thenExpression2).getQualifier();
            elseQualifier = ((PsiNewExpression)elseExpression2).getQualifier();
        }
        if (thenQualifier == null ^ elseQualifier == null || thenQualifier != null && !PsiEquivalenceUtil.areElementsEquivalent((PsiElement)thenQualifier, (PsiElement)elseQualifier)) {
            return Pair.create((Object)thenQualifier, (Object)elseQualifier);
        }
        return null;
    }

    private static void replaceRecursively(@NotNull Project project2, PsiConditionalExpression conditionalExpression, PsiExpression thenExpression2, PsiExpression elseExpression2) {
        PsiExpressionList thenArgsList = ((PsiCallExpression)thenExpression2).getArgumentList();
        if (thenArgsList == null) {
            return;
        }
        PsiExpression[] thenExpressions = thenArgsList.getExpressions();
        PsiExpressionList elseArgsList = ((PsiCallExpression)elseExpression2).getArgumentList();
        if (elseArgsList == null) {
            return;
        }
        PsiExpression[] elseExpressions = elseArgsList.getExpressions();
        Pair<PsiExpression, PsiExpression> qualifiers = PushConditionInCallAction.getQualifiers(thenExpression2, elseExpression2);
        if (qualifiers != null) {
            if (PushConditionInCallAction.isSameCall(thenExpressions, elseExpressions)) {
                PushConditionInCallAction.replaceRecursively(project2, conditionalExpression, (PsiExpression)qualifiers.first, (PsiExpression)qualifiers.second);
            } else {
                PushConditionInCallAction.pushConditional(project2, conditionalExpression, thenExpression2, elseExpression2);
            }
        } else {
            PsiExpression rExpr;
            PsiExpression lExpr;
            for (int i2 = 0; i2 < thenExpressions.length && !PushConditionInCallAction.pushConditional(project2, conditionalExpression, lExpr = thenExpressions[i2], rExpr = elseExpressions[i2]); ++i2) {
            }
        }
    }

    private static boolean pushConditional(@NotNull Project project2, PsiConditionalExpression conditionalExpression, PsiExpression thenExpression2, PsiExpression elseExpression2) {
        if (!PsiEquivalenceUtil.areElementsEquivalent((PsiElement)thenExpression2, (PsiElement)elseExpression2)) {
            thenExpression2.replace((PsiElement)JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(conditionalExpression.getCondition().getText() + "?" + thenExpression2.getText() + ":" + elseExpression2.getText(), (PsiElement)thenExpression2));
            return true;
        }
        return false;
    }
}

