/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.impl.QuickEditHandler;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.DocumentWindowImpl;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.impl.source.tree.injected.Place;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Rectangle;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickEditAction
implements IntentionAction,
LowPriorityAction {
    public static final Key<QuickEditHandler> QUICK_EDIT_HANDLER = Key.create((String)"QUICK_EDIT_HANDLER");
    public static final Key<Boolean> EDIT_ACTION_AVAILABLE = Key.create((String)"EDIT_ACTION_AVAILABLE");
    private String myLastLanguageName;

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.getRangePair(file2, editor) != null;
    }

    @Nullable
    protected Pair<PsiElement, TextRange> getRangePair(PsiFile file2, Editor editor) {
        int offset = editor.getCaretModel().getOffset();
        PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)PsiTreeUtil.getParentOfType((PsiElement)file2.findElementAt(offset), PsiLanguageInjectionHost.class, (boolean)false);
        if (host == null || ElementManipulators.getManipulator((PsiElement)host) == null) {
            return null;
        }
        List injections = InjectedLanguageManager.getInstance((Project)host.getProject()).getInjectedPsiFiles((PsiElement)host);
        if (injections == null || injections.isEmpty()) {
            return null;
        }
        int offsetInElement = offset - host.getTextRange().getStartOffset();
        Pair rangePair = (Pair)ContainerUtil.find((Iterable)injections, pair -> ((TextRange)pair.second).containsRange(offsetInElement, offsetInElement));
        if (rangePair != null) {
            Language language = ((PsiElement)rangePair.first).getContainingFile().getLanguage();
            Object action = language.getUserData(EDIT_ACTION_AVAILABLE);
            if (action != null && action.equals(false)) {
                return null;
            }
            this.myLastLanguageName = language.getDisplayName();
        }
        return rangePair;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        this.invokeImpl(project2, editor, file2);
    }

    public QuickEditHandler invokeImpl(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        DocumentWindow documentWindow;
        int offset = editor.getCaretModel().getOffset();
        Pair pair = (Pair)ObjectUtils.assertNotNull(this.getRangePair(file2, editor));
        PsiFile injectedFile = (PsiFile)pair.first;
        QuickEditHandler handler2 = this.getHandler(project2, injectedFile, editor, file2);
        if (!ApplicationManager.getApplication().isUnitTestMode() && (documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)injectedFile)) != null) {
            handler2.navigate(((DocumentWindowImpl)documentWindow).hostToInjectedUnescaped(offset));
        }
        return handler2;
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    private QuickEditHandler getHandler(Project project2, PsiFile injectedFile, Editor editor, PsiFile origFile) {
        QuickEditHandler handler2 = QuickEditAction.getExistingHandler(injectedFile);
        if (handler2 != null && handler2.isValid()) {
            return handler2;
        }
        handler2 = new QuickEditHandler(project2, injectedFile, origFile, editor, this);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            injectedFile.putUserData(QUICK_EDIT_HANDLER, (Object)handler2);
        }
        return handler2;
    }

    public static QuickEditHandler getExistingHandler(@NotNull PsiFile injectedFile) {
        Place shreds = InjectedLanguageUtil.getShreds(injectedFile);
        DocumentWindow documentWindow = InjectedLanguageUtil.getDocumentWindow((PsiElement)injectedFile);
        if (shreds == null || documentWindow == null) {
            return null;
        }
        TextRange hostRange = TextRange.create((int)((PsiLanguageInjectionHost.Shred)shreds.get(0)).getHostRangeMarker().getStartOffset(), (int)((PsiLanguageInjectionHost.Shred)shreds.get(shreds.size() - 1)).getHostRangeMarker().getEndOffset());
        for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
            QuickEditHandler handler2;
            if (editor.getDocument() != documentWindow.getDelegate() || (handler2 = (QuickEditHandler)((Object)editor.getUserData(QUICK_EDIT_HANDLER))) == null || !handler2.changesRange(hostRange)) continue;
            return handler2;
        }
        return null;
    }

    protected boolean isShowInBalloon() {
        return false;
    }

    @Nullable
    protected JComponent createBalloonComponent(@NotNull PsiFile file2) {
        return null;
    }

    @NotNull
    public String getText() {
        return "Edit " + StringUtil.notNullize((String)this.myLastLanguageName, (String)"Injected") + " Fragment";
    }

    @NotNull
    public String getFamilyName() {
        return "Edit Injected Fragment";
    }

    public static Balloon.Position getBalloonPosition(Editor editor) {
        int line = editor.getCaretModel().getVisualPosition().line;
        Rectangle area = editor.getScrollingModel().getVisibleArea();
        int startLine = area.y / editor.getLineHeight() + 1;
        return (line - startLine) * editor.getLineHeight() < 200 ? Balloon.Position.below : Balloon.Position.above;
    }
}

