/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.codeInsight.intention.impl.SplitConditionUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class SplitIfAction
extends PsiElementBaseIntentionAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.SplitIfAction");

    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        PsiPolyadicExpression expression2 = SplitConditionUtil.findCondition(element);
        if (expression2 == null) {
            return false;
        }
        if (!(expression2.getParent() instanceof PsiIfStatement)) {
            return false;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)expression2.getParent();
        if (!PsiTreeUtil.isAncestor((PsiElement)ifStatement.getCondition(), (PsiElement)expression2, (boolean)false)) {
            return false;
        }
        if (ifStatement.getThenBranch() == null) {
            return false;
        }
        this.setText(CodeInsightBundle.message((String)"intention.split.if.text", (Object[])new Object[0]));
        return true;
    }

    @NotNull
    public String getFamilyName() {
        return CodeInsightBundle.message((String)"intention.split.if.family", (Object[])new Object[0]);
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        PsiJavaToken token = (PsiJavaToken)element;
        LOG.assertTrue(token.getTokenType() == JavaTokenType.ANDAND || token.getTokenType() == JavaTokenType.OROR);
        PsiPolyadicExpression expression2 = (PsiPolyadicExpression)token.getParent();
        PsiIfStatement ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)expression2, PsiIfStatement.class);
        LOG.assertTrue(PsiTreeUtil.isAncestor((PsiElement)ifStatement.getCondition(), (PsiElement)expression2, (boolean)false));
        if (token.getTokenType() == JavaTokenType.ANDAND) {
            SplitIfAction.doAndSplit(ifStatement, expression2, token, editor);
        } else if (token.getTokenType() == JavaTokenType.OROR) {
            SplitIfAction.doOrSplit(ifStatement, expression2, token, editor);
        }
    }

    private static void doAndSplit(PsiIfStatement ifStatement, PsiPolyadicExpression expression2, PsiJavaToken token, Editor editor) throws IncorrectOperationException {
        PsiExpression lOperand = SplitConditionUtil.getLOperands(expression2, token);
        PsiExpression rOperand = SplitConditionUtil.getROperands(expression2, token);
        PsiManager psiManager = ifStatement.getManager();
        PsiIfStatement subIf = (PsiIfStatement)ifStatement.copy();
        subIf.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(rOperand));
        ifStatement.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(lOperand));
        if (ifStatement.getThenBranch() instanceof PsiBlockStatement) {
            PsiBlockStatement blockStmt = (PsiBlockStatement)JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory().createStatementFromText("{}", null);
            blockStmt = (PsiBlockStatement)CodeStyleManager.getInstance((Project)psiManager.getProject()).reformat((PsiElement)blockStmt);
            blockStmt = (PsiBlockStatement)ifStatement.getThenBranch().replace((PsiElement)blockStmt);
            blockStmt.getCodeBlock().add((PsiElement)subIf);
        } else {
            ifStatement.getThenBranch().replace((PsiElement)subIf);
        }
        int offset1 = ifStatement.getCondition().getTextOffset();
        editor.getCaretModel().moveToOffset(offset1);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }

    private static void doOrSplit(PsiIfStatement ifStatement, PsiPolyadicExpression expression2, PsiJavaToken token, Editor editor) throws IncorrectOperationException {
        PsiExpression lOperand = SplitConditionUtil.getLOperands(expression2, token);
        PsiExpression rOperand = SplitConditionUtil.getROperands(expression2, token);
        PsiIfStatement secondIf = (PsiIfStatement)ifStatement.copy();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        if (elseBranch != null) {
            elseBranch = (PsiStatement)elseBranch.copy();
        }
        ifStatement.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(lOperand));
        secondIf.getCondition().replace((PsiElement)RefactoringUtil.unparenthesizeExpression(rOperand));
        ifStatement.setElseBranch((PsiStatement)secondIf);
        if (elseBranch != null) {
            secondIf.setElseBranch(elseBranch);
        }
        int offset1 = ifStatement.getCondition().getTextOffset();
        editor.getCaretModel().moveToOffset(offset1);
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
        editor.getSelectionModel().removeSelection();
    }
}

