/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.IntentionActionBean;
import com.intellij.openapi.actionSystem.ShortcutProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionActionWrapper
implements IntentionAction,
ShortcutProvider {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.intention.impl.config.IntentionActionWrapper");
    private IntentionAction myDelegate;
    private final String[] myCategories;
    private final IntentionActionBean myExtension;
    private String myFullFamilyName;

    public IntentionActionWrapper(@NotNull IntentionActionBean extension, String[] categories) {
        this.myExtension = extension;
        this.myCategories = categories;
    }

    @NotNull
    public String getText() {
        return this.getDelegate().getText();
    }

    @NotNull
    public String getFamilyName() {
        return this.getDelegate().getFamilyName();
    }

    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        return this.getDelegate().isAvailable(project2, editor, file2);
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        this.getDelegate().invoke(project2, editor, file2);
    }

    public boolean startInWriteAction() {
        return this.getDelegate().startInWriteAction();
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile file2) {
        return this.getDelegate().getElementToMakeWritable(file2);
    }

    @NotNull
    public String getFullFamilyName() {
        String result2 = this.myFullFamilyName;
        if (result2 == null) {
            result2 = this.myCategories != null ? StringUtil.join((String[])this.myCategories, (String)"/") + "/" + this.getFamilyName() : this.getFamilyName();
            this.myFullFamilyName = result2;
        }
        return result2;
    }

    public synchronized IntentionAction getDelegate() {
        if (this.myDelegate == null) {
            try {
                this.myDelegate = this.myExtension.instantiate();
            }
            catch (ClassNotFoundException e) {
                LOG.error((Throwable)e);
            }
        }
        return this.myDelegate;
    }

    public String getImplementationClassName() {
        return this.myExtension.className;
    }

    public ClassLoader getImplementationClassLoader() {
        return this.myExtension.getLoaderForClass();
    }

    public String toString() {
        return "Intention: (" + this.getDelegate().getClass() + "): '" + this.getText() + "'";
    }

    public boolean equals(Object obj) {
        return super.equals(obj) || this.getDelegate().equals(obj);
    }

    @Nullable
    public ShortcutSet getShortcut() {
        IntentionAction delegate = this.getDelegate();
        return delegate instanceof ShortcutProvider ? ((ShortcutProvider)delegate).getShortcut() : null;
    }
}

