/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl.config;

import com.intellij.codeInsight.intention.impl.config.IntentionActionMetaData;
import com.intellij.codeInsight.intention.impl.config.IntentionManagerSettings;
import com.intellij.ide.ui.OptionsTopHitProvider;
import com.intellij.ide.ui.search.BooleanOptionDescription;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntentionsOptionsTopHitProvider
extends OptionsTopHitProvider {
    @Override
    public String getId() {
        return "intentions";
    }

    @Override
    @NotNull
    public Collection<BooleanOptionDescription> getOptions(@Nullable Project project2) {
        IntentionManagerSettings settings = IntentionManagerSettings.getInstance();
        if (settings == null) {
            return Collections.emptyList();
        }
        ArrayList<Option> options = new ArrayList<Option>();
        for (IntentionActionMetaData data : settings.getMetaData()) {
            options.add(new Option(settings, data));
        }
        return Collections.unmodifiableCollection(options);
    }

    private static final class Option
    extends BooleanOptionDescription {
        private final IntentionManagerSettings mySettings;
        private final IntentionActionMetaData myMetaData;

        private Option(IntentionManagerSettings settings, IntentionActionMetaData data) {
            super(Option.getOptionName(data), "preferences.intentionPowerPack");
            this.mySettings = settings;
            this.myMetaData = data;
        }

        public boolean isOptionEnabled() {
            return this.mySettings.isEnabled(this.myMetaData);
        }

        public void setOptionState(boolean enabled) {
            this.mySettings.setEnabled(this.myMetaData, enabled);
        }

        private static String getOptionName(IntentionActionMetaData data) {
            StringBuilder sb = new StringBuilder();
            for (String category : data.myCategory) {
                sb.append(category).append(": ");
            }
            return sb.append(data.getFamily()).toString();
        }
    }
}

