/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.javadoc;

import com.intellij.codeInsight.javadoc.JavaDocCodeStyle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class JavaDocUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.javadoc.JavaDocUtil");
    @NonNls
    private static final Pattern ourTypePattern = Pattern.compile("[ ]+[^ ^\\[^\\]]");

    private JavaDocUtil() {
    }

    public static int extractReference(String text) {
        int lparenthIndex = text.indexOf(40);
        int spaceIndex = text.indexOf(32);
        if (spaceIndex < 0) {
            spaceIndex = text.length();
        }
        if (lparenthIndex < 0) {
            return spaceIndex;
        }
        if (spaceIndex < lparenthIndex) {
            return spaceIndex;
        }
        int rparenthIndex = text.indexOf(41, lparenthIndex);
        if (rparenthIndex < 0) {
            rparenthIndex = text.length() - 1;
        }
        return rparenthIndex + 1;
    }

    @Nullable
    public static PsiElement findReferenceTarget(PsiManager manager, String refText, PsiElement context) {
        return JavaDocUtil.findReferenceTarget(manager, refText, context, true);
    }

    @Nullable
    public static PsiElement findReferenceTarget(PsiManager manager, String refText, PsiElement context, boolean useNavigationElement) {
        LOG.assertTrue(context == null || context.isValid());
        if (context != null) {
            context = context.getNavigationElement();
        }
        int poundIndex = refText.indexOf(35);
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)manager.getProject());
        if (poundIndex < 0) {
            PsiClass aClass = facade.getResolveHelper().resolveReferencedClass(refText, context);
            if (aClass == null) {
                aClass = facade.findClass(refText, context.getResolveScope());
            }
            if (aClass != null) {
                return useNavigationElement ? aClass.getNavigationElement() : aClass;
            }
            PsiPackage aPackage = facade.findPackage(refText);
            if (aPackage != null) {
                return aPackage;
            }
            return null;
        }
        String classRef = refText.substring(0, poundIndex).trim();
        if (!classRef.isEmpty()) {
            PsiClass aClass = facade.getResolveHelper().resolveReferencedClass(classRef, context);
            if (aClass == null) {
                aClass = facade.findClass(classRef, context.getResolveScope());
            }
            if (aClass == null) {
                return null;
            }
            PsiElement member = JavaDocUtil.findReferencedMember(aClass, refText.substring(poundIndex + 1), context);
            return useNavigationElement && member != null ? member.getNavigationElement() : member;
        }
        String memberRefText = refText.substring(1);
        PsiElement scope = context;
        while (!(scope instanceof PsiFile)) {
            PsiElement member;
            if (scope instanceof PsiClass && (member = JavaDocUtil.findReferencedMember((PsiClass)scope, memberRefText, context)) != null) {
                return useNavigationElement ? member.getNavigationElement() : member;
            }
            scope = scope.getParent();
        }
        return null;
    }

    @Nullable
    private static PsiElement findReferencedMember(PsiClass aClass, String memberRefText, PsiElement context) {
        PsiMethod[] methods;
        int parenthIndex = memberRefText.indexOf(40);
        if (parenthIndex < 0) {
            PsiMethod[] methods2;
            String name = memberRefText;
            PsiField field = aClass.findFieldByName(name, true);
            if (field != null) {
                return field;
            }
            PsiClass inner = aClass.findInnerClassByName(name, true);
            if (inner != null) {
                return inner;
            }
            for (PsiMethod method2 : methods2 = aClass.getAllMethods()) {
                if (!method2.getName().equals(name)) continue;
                return method2;
            }
            return null;
        }
        String name = memberRefText.substring(0, parenthIndex).trim();
        int rparenIndex = memberRefText.lastIndexOf(41);
        if (rparenIndex == -1) {
            return null;
        }
        String parmsText = memberRefText.substring(parenthIndex + 1, rparenIndex).trim();
        StringTokenizer tokenizer = new StringTokenizer(parmsText.replaceAll("[*]", ""), ",");
        PsiType[] types = PsiType.createArray((int)tokenizer.countTokens());
        int i2 = 0;
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)aClass.getProject()).getElementFactory();
        while (tokenizer.hasMoreTokens()) {
            String parmText = tokenizer.nextToken().trim();
            try {
                Matcher typeMatcher = ourTypePattern.matcher(parmText);
                String typeText = parmText;
                if (typeMatcher.find()) {
                    typeText = parmText.substring(0, typeMatcher.start());
                }
                PsiType type2 = factory.createTypeFromText(typeText, context);
                types[i2++] = type2;
            }
            catch (IncorrectOperationException e) {
                LOG.info((Throwable)e);
            }
        }
        block4: for (PsiMethod method3 : methods = aClass.findMethodsByName(name, true)) {
            int parameterNumber;
            PsiParameter[] parms = method3.getParameterList().getParameters();
            if (parms.length != types.length) continue;
            for (int k = 0; k < parms.length; ++k) {
                PsiParameter parm = parms[k];
                PsiType parmType = parm.getType();
                if (types[k] != null && !TypeConversionUtil.erasure((PsiType)parmType).getCanonicalText().equals(types[k].getCanonicalText()) && !parmType.getCanonicalText().equals(types[k].getCanonicalText()) && !TypeConversionUtil.isAssignable((PsiType)parmType, (PsiType)types[k])) continue block4;
            }
            int hashIndex = memberRefText.indexOf(35, rparenIndex);
            if (hashIndex != -1 && (parameterNumber = Integer.parseInt(memberRefText.substring(hashIndex + 1))) < parms.length) {
                return method3.getParameterList().getParameters()[parameterNumber];
            }
            return method3;
        }
        return null;
    }

    @Nullable
    public static String getReferenceText(Project project2, PsiElement element) {
        PsiElement method2;
        if (element instanceof PsiPackage) {
            return ((PsiPackage)element).getQualifiedName();
        }
        if (element instanceof PsiClass) {
            String refText = ((PsiClass)element).getQualifiedName();
            if (refText != null) {
                return refText;
            }
            return ((PsiClass)element).getName();
        }
        if (element instanceof PsiField) {
            PsiField field = (PsiField)element;
            String name = field.getName();
            PsiClass aClass = field.getContainingClass();
            if (aClass != null) {
                return JavaDocUtil.getReferenceText(project2, (PsiElement)aClass) + "#" + name;
            }
            return "#" + name;
        }
        if (element instanceof PsiMethod) {
            PsiMethod method3 = (PsiMethod)element;
            String name = method3.getName();
            StringBuffer buffer = new StringBuffer();
            PsiClass aClass = method3.getContainingClass();
            if (aClass != null) {
                buffer.append(JavaDocUtil.getReferenceText(project2, (PsiElement)aClass));
            }
            buffer.append("#");
            buffer.append(name);
            buffer.append("(");
            PsiParameter[] parms = method3.getParameterList().getParameters();
            boolean spaceBeforeComma = JavaDocCodeStyle.getInstance(project2).spaceBeforeComma();
            boolean spaceAfterComma = JavaDocCodeStyle.getInstance(project2).spaceAfterComma();
            for (int i2 = 0; i2 < parms.length; ++i2) {
                PsiParameter parm = parms[i2];
                String typeText = TypeConversionUtil.erasure((PsiType)parm.getType()).getCanonicalText();
                buffer.append(typeText);
                if (i2 >= parms.length - 1) continue;
                if (spaceBeforeComma) {
                    buffer.append(" ");
                }
                buffer.append(",");
                if (!spaceAfterComma) continue;
                buffer.append(" ");
            }
            buffer.append(")");
            return buffer.toString();
        }
        if (element instanceof PsiParameter && (method2 = ((PsiParameter)element).getDeclarationScope()) instanceof PsiMethod) {
            return JavaDocUtil.getReferenceText(project2, method2) + "#" + ((PsiParameterList)element.getParent()).getParameterIndex((PsiParameter)element);
        }
        return null;
    }

    public static String getShortestClassName(PsiClass aClass, PsiElement context) {
        String shortName = aClass.getName();
        if (shortName == null) {
            shortName = "null";
        }
        for (PsiClass containingClass = aClass.getContainingClass(); containingClass != null && containingClass.isPhysical(); containingClass = containingClass.getContainingClass()) {
            shortName = containingClass.getName() + "." + shortName;
        }
        String qName = aClass.getQualifiedName();
        if (qName == null) {
            return shortName;
        }
        PsiManager manager = aClass.getManager();
        return manager.areElementsEquivalent((PsiElement)aClass, (PsiElement)JavaPsiFacade.getInstance((Project)manager.getProject()).getResolveHelper().resolveReferencedClass(shortName, context)) ? shortName : StringUtil.trimStart((String)qName, (String)"java.lang.");
    }

    public static String getLabelText(Project project2, PsiManager manager, String refText, PsiElement context) {
        PsiElement refElement = JavaDocUtil.findReferenceTarget(manager, refText, context, false);
        if (refElement == null) {
            return refText.replaceFirst("^#", "").replaceAll("#", ".");
        }
        int poundIndex = refText.indexOf(35);
        if (poundIndex < 0) {
            if (refElement instanceof PsiClass) {
                return JavaDocUtil.getShortestClassName((PsiClass)refElement, context);
            }
            return refText;
        }
        PsiClass aClass = null;
        if (refElement instanceof PsiField) {
            aClass = ((PsiField)refElement).getContainingClass();
        } else if (refElement instanceof PsiMethod) {
            aClass = ((PsiMethod)refElement).getContainingClass();
        } else if (refElement instanceof PsiClass) {
            return refText.replaceAll("#", ".");
        }
        if (aClass == null) {
            return refText;
        }
        String classRef = refText.substring(0, poundIndex).trim();
        String memberText = refText.substring(poundIndex + 1);
        String memberLabel = JavaDocUtil.getMemberLabelText(project2, manager, memberText, context);
        if (!classRef.isEmpty()) {
            PsiElement refClass = JavaDocUtil.findReferenceTarget(manager, classRef, context);
            if (refClass instanceof PsiClass) {
                for (PsiElement scope = context; scope != null && !(scope instanceof PsiFile); scope = scope.getParent()) {
                    if (!scope.equals(refClass)) continue;
                    return memberLabel;
                }
            }
            return JavaDocUtil.getLabelText(project2, manager, classRef, context) + "." + memberLabel;
        }
        return memberLabel;
    }

    private static String getMemberLabelText(Project project2, PsiManager manager, String memberText, PsiElement context) {
        int parenthIndex = memberText.indexOf(40);
        if (parenthIndex < 0) {
            return memberText;
        }
        if (!StringUtil.endsWithChar((CharSequence)memberText, (char)')')) {
            return memberText;
        }
        String parms = memberText.substring(parenthIndex + 1, memberText.length() - 1);
        StringBuffer buffer = new StringBuffer();
        boolean spaceBeforeComma = JavaDocCodeStyle.getInstance(project2).spaceBeforeComma();
        boolean spaceAfterComma = JavaDocCodeStyle.getInstance(project2).spaceAfterComma();
        StringTokenizer tokenizer = new StringTokenizer(parms, ",");
        while (tokenizer.hasMoreTokens()) {
            int index2;
            String param = tokenizer.nextToken().trim();
            int index1 = param.indexOf(91);
            if (index1 < 0) {
                index1 = param.length();
            }
            if ((index2 = param.indexOf(32)) < 0) {
                index2 = param.length();
            }
            int index = Math.min(index1, index2);
            String className = param.substring(0, index).trim();
            String shortClassName = JavaDocUtil.getLabelText(project2, manager, className, context);
            buffer.append(shortClassName);
            buffer.append(param.substring(className.length()));
            if (!tokenizer.hasMoreElements()) continue;
            if (spaceBeforeComma) {
                buffer.append(" ");
            }
            buffer.append(",");
            if (!spaceAfterComma) continue;
            buffer.append(" ");
        }
        return memberText.substring(0, parenthIndex + 1) + buffer.toString() + ")";
    }

    public static PsiClassType[] getImplementsList(PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return new PsiClassType[]{((PsiAnonymousClass)aClass).getBaseClassType()};
        }
        PsiReferenceList list = aClass.getImplementsList();
        return list == null ? PsiClassType.EMPTY_ARRAY : list.getReferencedTypes();
    }

    public static PsiClassType[] getExtendsList(PsiClass aClass) {
        if (aClass instanceof PsiAnonymousClass) {
            return new PsiClassType[]{((PsiAnonymousClass)aClass).getBaseClassType()};
        }
        PsiReferenceList list = aClass.getExtendsList();
        return list == null ? PsiClassType.EMPTY_ARRAY : list.getReferencedTypes();
    }

    public static boolean isInsidePackageInfo(@Nullable PsiDocComment containingComment) {
        return containingComment != null && containingComment.getOwner() == null && containingComment.getParent() instanceof PsiJavaFile;
    }
}

