/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.lookup;

import com.intellij.codeInsight.lookup.Classifier;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ProcessingContext;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FlatteningIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ComparingClassifier<T>
extends Classifier<T> {
    private final boolean myNegated;

    protected ComparingClassifier(Classifier<T> next, String name, boolean negated) {
        super(next, name);
        this.myNegated = negated;
    }

    @Nullable
    public abstract Comparable getWeight(T var1, ProcessingContext var2);

    @Override
    @NotNull
    public Iterable<T> classify(@NotNull Iterable<T> source, final @NotNull ProcessingContext context) {
        List nulls = null;
        TreeMap<Comparable, SmartList> map2 = new TreeMap<Comparable, SmartList>();
        for (T t : source) {
            Comparable weight = this.getWeight(t, context);
            if (weight == null) {
                if (nulls == null) {
                    nulls = new SmartList();
                }
                nulls.add(t);
                continue;
            }
            List list = (List)map2.get(weight);
            if (list == null) {
                list = new SmartList();
                map2.put(weight, (SmartList)list);
            }
            list.add(t);
        }
        final ArrayList values = new ArrayList();
        values.addAll(this.myNegated ? map2.descendingMap().values() : map2.values());
        ContainerUtil.addIfNotNull(values, (Object)nulls);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new FlatteningIterator<List<T>, T>(values.iterator()){

                    protected Iterator<T> createValueIterator(List<T> group) {
                        return ComparingClassifier.this.myNext.classify(group, context).iterator();
                    }
                };
            }
        };
    }

    @Override
    @NotNull
    public List<Pair<T, Object>> getSortingWeights(@NotNull Iterable<T> items, @NotNull ProcessingContext context) {
        return ContainerUtil.map(items, t -> new Pair(t, (Object)this.getWeight(t, context)));
    }
}

