/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiElement;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageView;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.util.Alarm;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BackgroundUpdaterTask<T>
extends Task.Backgroundable {
    protected AbstractPopup myPopup;
    protected T myComponent;
    private Ref<UsageView> myUsageView;
    private final List<PsiElement> myData = new ArrayList<PsiElement>();
    private final Alarm myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
    private final Object lock = new Object();
    private volatile boolean myCanceled;
    private volatile boolean myFinished;
    private volatile ProgressIndicator myIndicator;

    public BackgroundUpdaterTask(Project project2, String title, boolean canBeCancelled) {
        super(project2, title, canBeCancelled);
    }

    public BackgroundUpdaterTask(Project project2, String title) {
        super(project2, title);
    }

    public BackgroundUpdaterTask(Project project2, String title, boolean canBeCancelled, PerformInBackgroundOption backgroundOption) {
        super(project2, title, canBeCancelled, backgroundOption);
    }

    public void init(@NotNull AbstractPopup popup, @NotNull T component, @NotNull Ref<UsageView> usageView) {
        this.myPopup = popup;
        this.myComponent = component;
        this.myUsageView = usageView;
    }

    public abstract String getCaption(int var1);

    protected abstract void replaceModel(@NotNull List<PsiElement> var1);

    protected abstract void paintBusy(boolean var1);

    public boolean setCanceled() {
        boolean canceled = this.myCanceled;
        this.myCanceled = true;
        return canceled;
    }

    public boolean isCanceled() {
        return this.myCanceled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateComponent(PsiElement element, @Nullable Comparator comparator2) {
        UsageView view = (UsageView)this.myUsageView.get();
        if (view != null && !((UsageViewImpl)view).isDisposed()) {
            ApplicationManager.getApplication().runReadAction(() -> view.appendUsage((Usage)new UsageInfo2UsageAdapter(new UsageInfo(element))));
            return true;
        }
        if (this.myCanceled) {
            return false;
        }
        JComponent content = this.myPopup.getContent();
        if (content == null || this.myPopup.isDisposed()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.myData.contains(element)) {
                return true;
            }
            this.myData.add(element);
            if (comparator2 != null) {
                Collections.sort(this.myData, comparator2);
            }
        }
        this.myAlarm.addRequest(() -> {
            this.myAlarm.cancelAllRequests();
            this.refreshModelImmediately();
        }, 200, ModalityState.stateForComponent((Component)content));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshModelImmediately() {
        ArrayList<PsiElement> data;
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myCanceled) {
            return;
        }
        if (this.myPopup.isDisposed()) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            data = new ArrayList<PsiElement>(this.myData);
        }
        this.replaceModel(data);
        this.myPopup.setCaption(this.getCaption(this.getCurrentSize()));
        this.myPopup.pack(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentSize() {
        Object object = this.lock;
        synchronized (object) {
            return this.myData.size();
        }
    }

    public void run(@NotNull ProgressIndicator indicator) {
        this.paintBusy(true);
        this.myIndicator = indicator;
    }

    public void onSuccess() {
        this.refreshModelImmediately();
        this.paintBusy(false);
    }

    public void onFinished() {
        this.myAlarm.cancelAllRequests();
        this.myFinished = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected PsiElement getTheOnlyOneElement() {
        Object object = this.lock;
        synchronized (object) {
            if (this.myData.size() == 1) {
                return this.myData.get(0);
            }
        }
        return null;
    }

    public boolean isFinished() {
        return this.myFinished;
    }

    public boolean cancelTask() {
        ProgressIndicator indicator = this.myIndicator;
        if (indicator != null) {
            indicator.cancel();
        }
        return this.setCanceled();
    }
}

