/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.PsiElementProcessorAdapter;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.search.searches.FunctionalExpressionSearch;
import com.intellij.util.Processor;
import com.intellij.util.QueryExecutor;
import org.jetbrains.annotations.NotNull;

public class ClassImplementationsSearch
implements QueryExecutor<PsiElement, DefinitionsScopedSearch.SearchParameters> {
    public boolean execute(@NotNull DefinitionsScopedSearch.SearchParameters queryParameters, @NotNull Processor<PsiElement> consumer2) {
        PsiElement sourceElement = queryParameters.getElement();
        return !(sourceElement instanceof PsiClass) || ClassImplementationsSearch.processImplementations((PsiClass)sourceElement, consumer2, queryParameters.getScope());
    }

    public static boolean processImplementations(PsiClass psiClass, Processor<PsiElement> processor2, SearchScope scope) {
        boolean showInterfaces = Registry.is((String)"ide.goto.implementation.show.interfaces");
        if (!ClassInheritorsSearch.search((PsiClass)psiClass, (SearchScope)scope, (boolean)true).forEach((Processor)new PsiElementProcessorAdapter(element -> {
            if (!showInterfaces && element.isInterface()) {
                return true;
            }
            return processor2.process((Object)element);
        }))) {
            return false;
        }
        return FunctionalExpressionSearch.search((PsiClass)psiClass, (SearchScope)scope).forEach(arg_0 -> processor2.process(arg_0));
    }
}

