/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.AbstractDocumentationTooltipAction;
import com.intellij.codeInsight.navigation.DocPreviewUtil;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.codeInsight.navigation.ShowQuickDocAtPinnedWindowFromTooltipAction;
import com.intellij.codeInsight.navigation.actions.GotoDeclarationAction;
import com.intellij.codeInsight.navigation.actions.GotoTypeDeclarationAction;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.EditorEventMulticaster;
import com.intellij.openapi.editor.event.EditorMouseAdapter;
import com.intellij.openapi.editor.event.EditorMouseEvent;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionAdapter;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.progress.util.ReadTask;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.ElementDescriptionLocation;
import com.intellij.psi.ElementDescriptionUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiQualifiedNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ReferenceRange;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.HintListener;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.components.JBLayeredPane;
import com.intellij.usageView.UsageViewShortNameLocation;
import com.intellij.usageView.UsageViewTypeLocation;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ui.UIUtil;
import gnu.trove.TIntArrayList;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CtrlMouseHandler
extends AbstractProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.navigation.CtrlMouseHandler");
    private static final AbstractDocumentationTooltipAction[] ourTooltipActions = new AbstractDocumentationTooltipAction[]{new ShowQuickDocAtPinnedWindowFromTooltipAction()};
    private final EditorColorsManager myEditorColorsManager;
    private HighlightersSet myHighlighter;
    @JdkConstants.InputEventMask
    private int myStoredModifiers = 0;
    private TooltipProvider myTooltipProvider = null;
    private final FileEditorManager myFileEditorManager;
    private final DocumentationManager myDocumentationManager;
    @Nullable
    private Point myPrevMouseLocation;
    private LightweightHint myHint;
    private final KeyListener myEditorKeyListener = new KeyAdapter(){

        @Override
        public void keyPressed(KeyEvent e) {
            this.handleKey(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            this.handleKey(e);
        }

        private void handleKey(KeyEvent e) {
            int modifiers = e.getModifiers();
            if (modifiers == CtrlMouseHandler.this.myStoredModifiers) {
                return;
            }
            BrowseMode browseMode = CtrlMouseHandler.getBrowseMode(modifiers);
            if (browseMode == BrowseMode.None) {
                CtrlMouseHandler.this.disposeHighlighter();
                CtrlMouseHandler.this.cancelPreviousTooltip();
            } else {
                TooltipProvider tooltipProvider = CtrlMouseHandler.this.myTooltipProvider;
                if (tooltipProvider != null) {
                    if (browseMode != tooltipProvider.getBrowseMode()) {
                        CtrlMouseHandler.this.disposeHighlighter();
                    }
                    CtrlMouseHandler.this.myStoredModifiers = modifiers;
                    CtrlMouseHandler.this.cancelPreviousTooltip();
                    CtrlMouseHandler.this.myTooltipProvider = new TooltipProvider(tooltipProvider.myEditor, tooltipProvider.myPosition);
                    CtrlMouseHandler.this.myTooltipProvider.execute(browseMode);
                }
            }
        }
    };
    private final FileEditorManagerListener myFileEditorManagerListener = new FileEditorManagerListener(){

        public void selectionChanged(@NotNull FileEditorManagerEvent e) {
            CtrlMouseHandler.this.disposeHighlighter();
            CtrlMouseHandler.this.cancelPreviousTooltip();
        }
    };
    private final VisibleAreaListener myVisibleAreaListener = new VisibleAreaListener(){

        public void visibleAreaChanged(VisibleAreaEvent e) {
            CtrlMouseHandler.this.disposeHighlighter();
            CtrlMouseHandler.this.cancelPreviousTooltip();
        }
    };
    private final EditorMouseAdapter myEditorMouseAdapter = new EditorMouseAdapter(){

        public void mouseReleased(EditorMouseEvent e) {
            CtrlMouseHandler.this.disposeHighlighter();
            CtrlMouseHandler.this.cancelPreviousTooltip();
        }
    };
    private final EditorMouseMotionListener myEditorMouseMotionListener = new EditorMouseMotionAdapter(){

        public void mouseMoved(EditorMouseEvent e) {
            if (e.isConsumed() || !CtrlMouseHandler.this.myProject.isInitialized() || CtrlMouseHandler.this.myProject.isDisposed()) {
                return;
            }
            MouseEvent mouseEvent = e.getMouseEvent();
            Point prevLocation = CtrlMouseHandler.this.myPrevMouseLocation;
            CtrlMouseHandler.this.myPrevMouseLocation = mouseEvent.getLocationOnScreen();
            if (CtrlMouseHandler.this.isMouseOverTooltip(mouseEvent.getLocationOnScreen()) || ScreenUtil.isMovementTowards((Point)prevLocation, (Point)mouseEvent.getLocationOnScreen(), (Rectangle)CtrlMouseHandler.this.getHintBounds())) {
                return;
            }
            CtrlMouseHandler.this.cancelPreviousTooltip();
            CtrlMouseHandler.this.myStoredModifiers = mouseEvent.getModifiers();
            BrowseMode browseMode = CtrlMouseHandler.getBrowseMode(CtrlMouseHandler.this.myStoredModifiers);
            if (browseMode == BrowseMode.None || e.getArea() != EditorMouseEventArea.EDITING_AREA) {
                CtrlMouseHandler.this.disposeHighlighter();
                return;
            }
            Editor editor = e.getEditor();
            if (editor.getProject() != null && editor.getProject() != CtrlMouseHandler.this.myProject) {
                return;
            }
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject);
            PsiFile psiFile = documentManager.getPsiFile(editor.getDocument());
            Point point = new Point(mouseEvent.getPoint());
            if (documentManager.isCommitted(editor.getDocument())) {
                int offset = editor.logicalPositionToOffset(editor.xyToLogicalPosition(point));
                editor = InjectedLanguageUtil.getEditorForInjectedLanguageNoCommit(editor, psiFile, offset);
            }
            LogicalPosition pos = editor.xyToLogicalPosition(point);
            int offset = editor.logicalPositionToOffset(pos);
            int selStart = editor.getSelectionModel().getSelectionStart();
            int selEnd = editor.getSelectionModel().getSelectionEnd();
            if (offset >= selStart && offset < selEnd) {
                CtrlMouseHandler.this.disposeHighlighter();
                return;
            }
            CtrlMouseHandler.this.myTooltipProvider = new TooltipProvider(editor, pos);
            CtrlMouseHandler.this.myTooltipProvider.execute(browseMode);
        }
    };
    @NotNull
    private final Alarm myDocAlarm;

    private void cancelPreviousTooltip() {
        if (this.myTooltipProvider != null) {
            this.myTooltipProvider.dispose();
            this.myTooltipProvider = null;
        }
    }

    public CtrlMouseHandler(final Project project2, StartupManager startupManager, EditorColorsManager colorsManager, FileEditorManager fileEditorManager, @NotNull DocumentationManager documentationManager, final @NotNull EditorFactory editorFactory) {
        super(project2);
        this.myEditorColorsManager = colorsManager;
        startupManager.registerPostStartupActivity((Runnable)new DumbAwareRunnable(){

            public void run() {
                EditorEventMulticaster eventMulticaster = editorFactory.getEventMulticaster();
                eventMulticaster.addEditorMouseListener((EditorMouseListener)CtrlMouseHandler.this.myEditorMouseAdapter, (Disposable)project2);
                eventMulticaster.addEditorMouseMotionListener(CtrlMouseHandler.this.myEditorMouseMotionListener, (Disposable)project2);
                eventMulticaster.addCaretListener((CaretListener)new CaretAdapter(){

                    public void caretPositionChanged(CaretEvent e) {
                        if (CtrlMouseHandler.this.myHint != null) {
                            CtrlMouseHandler.this.myDocumentationManager.updateToolwindowContext();
                        }
                    }
                }, (Disposable)project2);
            }
        });
        this.myFileEditorManager = fileEditorManager;
        this.myDocumentationManager = documentationManager;
        this.myDocAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this.myProject);
    }

    @NotNull
    public String getComponentName() {
        return "CtrlMouseHandler";
    }

    private boolean isMouseOverTooltip(@NotNull Point mouseLocationOnScreen) {
        Rectangle bounds = this.getHintBounds();
        return bounds != null && bounds.contains(mouseLocationOnScreen);
    }

    @Nullable
    private Rectangle getHintBounds() {
        LightweightHint hint = this.myHint;
        if (hint == null) {
            return null;
        }
        JComponent hintComponent = hint.getComponent();
        if (!hintComponent.isShowing()) {
            return null;
        }
        return new Rectangle(hintComponent.getLocationOnScreen(), hintComponent.getSize());
    }

    @NotNull
    private static BrowseMode getBrowseMode(@JdkConstants.InputEventMask int modifiers) {
        if (modifiers != 0) {
            Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
            if (KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)activeKeymap, (int)modifiers, (String)"GotoDeclaration")) {
                return BrowseMode.Declaration;
            }
            if (KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)activeKeymap, (int)modifiers, (String)"GotoTypeDeclaration")) {
                return BrowseMode.TypeDeclaration;
            }
            if (KeymapUtil.matchActionMouseShortcutsModifiers((Keymap)activeKeymap, (int)modifiers, (String)"GotoImplementation")) {
                return BrowseMode.Implementation;
            }
        }
        return BrowseMode.None;
    }

    @Nullable
    public static String getInfo(PsiElement element, PsiElement atPointer) {
        return CtrlMouseHandler.generateInfo((PsiElement)element, (PsiElement)atPointer, (boolean)true).text;
    }

    @Nullable
    public static String getInfo(@NotNull Editor editor, BrowseMode browseMode) {
        Project project2 = editor.getProject();
        if (project2 == null) {
            return null;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return null;
        }
        Info info = CtrlMouseHandler.getInfoAt(project2, editor, file2, editor.getCaretModel().getOffset(), browseMode);
        return info == null ? null : info.getInfo().text;
    }

    @NotNull
    private static DocInfo generateInfo(PsiElement element, PsiElement atPointer, boolean fallbackToBasicInfo) {
        DocumentationProvider documentationProvider = DocumentationManager.getProviderFromElement(element, atPointer);
        String result2 = documentationProvider.getQuickNavigateInfo(element, atPointer);
        if (result2 == null && fallbackToBasicInfo) {
            result2 = CtrlMouseHandler.doGenerateInfo(element);
        }
        return result2 == null ? DocInfo.EMPTY : new DocInfo(result2, documentationProvider, element);
    }

    @Nullable
    private static String doGenerateInfo(@NotNull PsiElement element) {
        ItemPresentation presentation;
        VirtualFile virtualFile;
        if (element instanceof PsiFile && (virtualFile = ((PsiFile)element).getVirtualFile()) != null) {
            return virtualFile.getPresentableUrl();
        }
        String info = CtrlMouseHandler.getQuickNavigateInfo(element);
        if (info != null) {
            return info;
        }
        if (element instanceof NavigationItem && (presentation = ((NavigationItem)element).getPresentation()) != null) {
            return presentation.getPresentableText();
        }
        return null;
    }

    @Nullable
    private static String getQuickNavigateInfo(PsiElement element) {
        String name = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewShortNameLocation.INSTANCE);
        if (StringUtil.isEmpty((String)name)) {
            return null;
        }
        String typeName = ElementDescriptionUtil.getElementDescription((PsiElement)element, (ElementDescriptionLocation)UsageViewTypeLocation.INSTANCE);
        PsiFile file2 = element.getContainingFile();
        StringBuilder sb = new StringBuilder();
        if (StringUtil.isNotEmpty((String)typeName)) {
            sb.append(typeName).append(" ");
        }
        sb.append("\"").append(name).append("\"");
        if (file2 != null && file2.isPhysical()) {
            sb.append(" [").append(file2.getName()).append("]");
        }
        return sb.toString();
    }

    private static void showDumbModeNotification(@NotNull Project project2) {
        DumbService.getInstance((Project)project2).showDumbModeNotification("Element information is not available during index update");
    }

    @Nullable
    private Info getInfoAt(@NotNull Editor editor, @NotNull PsiFile file2, int offset, @NotNull BrowseMode browseMode) {
        return CtrlMouseHandler.getInfoAt(this.myProject, editor, file2, offset, browseMode);
    }

    @Nullable
    private static Info getInfoAt(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2, int offset, @NotNull BrowseMode browseMode) {
        PsiElement identifier;
        PsiElement elementAtPointer;
        PsiElement element;
        PsiElement targetElement = null;
        if (browseMode == BrowseMode.TypeDeclaration) {
            try {
                targetElement = GotoTypeDeclarationAction.findSymbolType(editor, offset);
            }
            catch (IndexNotReadyException e) {
                CtrlMouseHandler.showDumbModeNotification(project2);
            }
        } else if (browseMode == BrowseMode.Declaration) {
            PsiReference ref = TargetElementUtil.findReference(editor, offset);
            List<Object> resolvedElements = ref == null ? Collections.emptyList() : CtrlMouseHandler.resolve(ref);
            PsiElement resolvedElement = resolvedElements.size() == 1 ? (PsiElement)resolvedElements.get(0) : null;
            PsiElement[] targetElements = GotoDeclarationAction.findTargetElementsNoVS(project2, editor, offset, false);
            PsiElement elementAtPointer2 = file2.findElementAt(TargetElementUtil.adjustOffset(file2, editor.getDocument(), offset));
            if (targetElements != null) {
                if (targetElements.length == 0) {
                    return null;
                }
                if (targetElements.length == 1) {
                    if (targetElements[0] != resolvedElement && elementAtPointer2 != null && targetElements[0].isPhysical()) {
                        return ref != null ? new InfoSingle(ref, targetElements[0]) : new InfoSingle(elementAtPointer2, targetElements[0]);
                    }
                } else {
                    return elementAtPointer2 != null ? new InfoMultiple(elementAtPointer2) : null;
                }
            }
            if (resolvedElements.size() == 1) {
                return new InfoSingle(ref, (PsiElement)resolvedElements.get(0));
            }
            if (resolvedElements.size() > 1) {
                return elementAtPointer2 != null ? new InfoMultiple(elementAtPointer2, ref) : null;
            }
        } else if (browseMode == BrowseMode.Implementation) {
            element = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), offset);
            PsiElement[] targetElements = new ImplementationSearcher(){

                @Override
                @NotNull
                protected PsiElement[] searchDefinitions(PsiElement element, Editor editor) {
                    ArrayList found = new ArrayList(2);
                    DefinitionsScopedSearch.search((PsiElement)element, (SearchScope)7.getSearchScope(element, editor)).forEach(psiElement -> {
                        found.add(psiElement);
                        return found.size() != 2;
                    });
                    return PsiUtilCore.toPsiElementArray(found);
                }
            }.searchImplementations(editor, element, offset);
            if (targetElements == null) {
                return null;
            }
            if (targetElements.length > 1) {
                PsiElement elementAtPointer3 = file2.findElementAt(offset);
                if (elementAtPointer3 != null) {
                    return new InfoMultiple(elementAtPointer3);
                }
                return null;
            }
            if (targetElements.length == 1) {
                Navigatable descriptor = EditSourceUtil.getDescriptor((PsiElement)targetElements[0]);
                if (descriptor == null || !descriptor.canNavigate()) {
                    return null;
                }
                targetElement = targetElements[0];
            }
        }
        if (targetElement != null && targetElement.isPhysical() && (elementAtPointer = file2.findElementAt(offset)) != null) {
            return new InfoSingle(elementAtPointer, targetElement);
        }
        element = GotoDeclarationAction.findElementToShowUsagesOf(editor, offset);
        if (element instanceof PsiNameIdentifierOwner && (identifier = ((PsiNameIdentifierOwner)element).getNameIdentifier()) != null && identifier.isValid()) {
            return new Info(identifier){

                @Override
                public void showDocInfo(@NotNull DocumentationManager docManager) {
                }

                @Override
                @NotNull
                public DocInfo getInfo() {
                    String name = UsageViewUtil.getType(element) + " '" + UsageViewUtil.getShortName(element) + "'";
                    return new DocInfo("Show usages of " + name, null, element);
                }

                @Override
                public boolean isValid(@NotNull Document document) {
                    return element.isValid();
                }

                @Override
                public boolean isNavigatable() {
                    return true;
                }
            };
        }
        return null;
    }

    @NotNull
    private static List<PsiElement> resolve(@NotNull PsiReference ref) {
        PsiElement resolvedElement = ref.resolve();
        if (resolvedElement == null && ref instanceof PsiPolyVariantReference) {
            ResolveResult[] psiElements;
            ArrayList<PsiElement> result2 = new ArrayList<PsiElement>();
            for (ResolveResult resolveResult : psiElements = ((PsiPolyVariantReference)ref).multiResolve(false)) {
                if (resolveResult.getElement() == null) continue;
                result2.add(resolveResult.getElement());
            }
            return result2;
        }
        return resolvedElement == null ? Collections.emptyList() : Collections.singletonList(resolvedElement);
    }

    private void disposeHighlighter() {
        if (this.myHighlighter != null) {
            HighlightersSet highlighter = this.myHighlighter;
            this.myHighlighter = null;
            highlighter.uninstall();
            HintManager.getInstance().hideAllHints();
        }
    }

    private void fulfillDocInfo(@NotNull String header, @NotNull DocumentationProvider provider2, @NotNull PsiElement originalElement, @NotNull PsiElement anchorElement, @NotNull Consumer<String> newTextConsumer, @NotNull LightweightHint hint) {
        this.myDocAlarm.cancelAllRequests();
        this.myDocAlarm.addRequest(() -> {
            Ref fullTextRef = new Ref();
            Ref qualifiedNameRef = new Ref();
            ApplicationManager.getApplication().runReadAction(() -> {
                if (anchorElement.isValid() && originalElement.isValid()) {
                    try {
                        fullTextRef.set((Object)provider2.generateDoc(anchorElement, originalElement));
                    }
                    catch (IndexNotReadyException e) {
                        fullTextRef.set((Object)"Documentation is not available while indexing is in progress");
                    }
                    if (anchorElement instanceof PsiQualifiedNamedElement) {
                        qualifiedNameRef.set((Object)((PsiQualifiedNamedElement)anchorElement).getQualifiedName());
                    }
                }
            });
            String fullText = (String)fullTextRef.get();
            if (fullText == null) {
                return;
            }
            String updatedText = DocPreviewUtil.buildPreview(header, (String)qualifiedNameRef.get(), fullText);
            String newHtml = HintUtil.prepareHintText(updatedText, HintUtil.getInformationHint());
            UIUtil.invokeLaterIfNeeded(() -> {
                int widthIncrease;
                JComponent component = hint.getComponent();
                Dimension oldSize = component.getPreferredSize();
                newTextConsumer.consume((Object)newHtml);
                if (component instanceof QuickDocInfoPane) {
                    int buttonWidth = ((QuickDocInfoPane)((Object)((Object)((Object)component)))).getButtonWidth();
                    widthIncrease = CtrlMouseHandler.calculateWidthIncrease(buttonWidth, updatedText);
                } else {
                    widthIncrease = 0;
                }
                if (oldSize == null) {
                    return;
                }
                Dimension newSize = component.getPreferredSize();
                if (newSize.width + widthIncrease == oldSize.width) {
                    return;
                }
                component.setPreferredSize(new Dimension(newSize.width + widthIncrease, newSize.height));
                if (hint.isRealPopup()) {
                    TooltipProvider tooltipProvider = this.myTooltipProvider;
                    if (tooltipProvider != null) {
                        hint.hide();
                        tooltipProvider.showHint(new LightweightHint(component));
                    } else {
                        component.setPreferredSize(new Dimension(newSize.width + widthIncrease, oldSize.height));
                        hint.pack();
                    }
                    return;
                }
                Container topLevelLayeredPaneChild = null;
                boolean adjustBounds = false;
                for (Container current = component.getParent(); current != null; current = current.getParent()) {
                    if (current instanceof JLayeredPane) {
                        adjustBounds = true;
                        break;
                    }
                    topLevelLayeredPaneChild = current;
                }
                if (adjustBounds && topLevelLayeredPaneChild != null) {
                    Rectangle bounds = topLevelLayeredPaneChild.getBounds();
                    topLevelLayeredPaneChild.setBounds(bounds.x, bounds.y, bounds.width + newSize.width + widthIncrease - oldSize.width, bounds.height);
                }
            });
        }, 0);
    }

    private static int calculateWidthIncrease(int buttonWidth, String updatedText) {
        int maxLineWidth = 0;
        TIntArrayList lineWidths = new TIntArrayList();
        for (String lineText : StringUtil.split((String)updatedText, (String)"<br/>")) {
            String html = HintUtil.prepareHintText(lineText, HintUtil.getInformationHint());
            int width = new JLabel((String)html).getPreferredSize().width;
            maxLineWidth = Math.max(maxLineWidth, width);
            lineWidths.add(width);
        }
        if (!lineWidths.isEmpty()) {
            int firstLineAvailableTrailingWidth = maxLineWidth - lineWidths.get(0);
            if (firstLineAvailableTrailingWidth >= buttonWidth) {
                return 0;
            }
            return buttonWidth - firstLineAvailableTrailingWidth;
        }
        return 0;
    }

    @NotNull
    private HighlightersSet installHighlighterSet(@NotNull Info info, @NotNull Editor editor) {
        JComponent internalComponent = editor.getContentComponent();
        internalComponent.addKeyListener(this.myEditorKeyListener);
        editor.getScrollingModel().addVisibleAreaListener(this.myVisibleAreaListener);
        Cursor cursor = internalComponent.getCursor();
        if (info.isNavigatable()) {
            internalComponent.setCursor(Cursor.getPredefinedCursor(12));
        }
        this.myFileEditorManager.addFileEditorManagerListener(this.myFileEditorManagerListener);
        ArrayList<RangeHighlighter> highlighters = new ArrayList<RangeHighlighter>();
        TextAttributes attributes = info.isNavigatable() ? this.myEditorColorsManager.getGlobalScheme().getAttributes(EditorColors.REFERENCE_HYPERLINK_COLOR) : new TextAttributes(null, HintUtil.getInformationColor(), null, null, 0);
        for (TextRange range : info.getRanges()) {
            TextAttributes attr = NavigationUtil.patchAttributesColor(attributes, range, editor);
            RangeHighlighter highlighter = editor.getMarkupModel().addRangeHighlighter(range.getStartOffset(), range.getEndOffset(), 5900, attr, HighlighterTargetArea.EXACT_RANGE);
            highlighters.add(highlighter);
        }
        return new HighlightersSet(highlighters, editor, cursor, info);
    }

    private class QuickDocHyperlinkListener
    implements HyperlinkListener {
        @NotNull
        private final DocumentationProvider myProvider;
        @NotNull
        private final PsiElement myContext;

        QuickDocHyperlinkListener(@NotNull DocumentationProvider provider2, PsiElement context) {
            this.myProvider = provider2;
            this.myContext = context;
        }

        @Override
        public void hyperlinkUpdate(@NotNull HyperlinkEvent e) {
            if (e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            String description = e.getDescription();
            if (StringUtil.isEmpty((String)description) || !description.startsWith("psi_element://")) {
                return;
            }
            String elementName = e.getDescription().substring("psi_element://".length());
            DumbService.getInstance((Project)CtrlMouseHandler.this.myProject).withAlternativeResolveEnabled(() -> {
                PsiElement targetElement = this.myProvider.getDocumentationElementForLink(PsiManager.getInstance((Project)CtrlMouseHandler.this.myProject), elementName, this.myContext);
                if (targetElement != null) {
                    LightweightHint hint = CtrlMouseHandler.this.myHint;
                    if (hint != null) {
                        hint.hide(true);
                    }
                    CtrlMouseHandler.this.myDocumentationManager.showJavaDocInfo(targetElement, this.myContext, null);
                }
            });
        }
    }

    private class QuickDocInfoPane
    extends JBLayeredPane {
        private static final int BUTTON_HGAP = 5;
        @NotNull
        private final List<JComponent> myButtons = new ArrayList<JComponent>();
        @NotNull
        private final JComponent myBaseDocControl;
        private final int myMinWidth;
        private final int myMinHeight;
        private final int myButtonWidth;

        QuickDocInfoPane(@NotNull PsiElement documentationAnchor, @NotNull PsiElement elementUnderMouse, JComponent baseDocControl) {
            this.myBaseDocControl = baseDocControl;
            PresentationFactory presentationFactory = new PresentationFactory();
            for (AbstractDocumentationTooltipAction action : ourTooltipActions) {
                Icon icon = action.getTemplatePresentation().getIcon();
                Dimension minSize = new Dimension(icon.getIconWidth(), icon.getIconHeight());
                this.myButtons.add(new ActionButton(action, presentationFactory.getPresentation(action), "IdeTooltip", minSize));
                action.setDocInfo(documentationAnchor, elementUnderMouse);
            }
            Collections.reverse(this.myButtons);
            this.setPreferredSize(baseDocControl.getPreferredSize());
            this.setMaximumSize(baseDocControl.getMaximumSize());
            this.setMinimumSize(baseDocControl.getMinimumSize());
            this.setBackground(baseDocControl.getBackground());
            this.add(baseDocControl, 0);
            int minWidth = 0;
            int minHeight = 0;
            int buttonWidth = 0;
            for (JComponent button : this.myButtons) {
                button.setBorder(null);
                button.setBackground(baseDocControl.getBackground());
                this.add(button, 1);
                button.setVisible(false);
                Dimension preferredSize = button.getPreferredSize();
                minWidth += preferredSize.width;
                minHeight = Math.max(minHeight, preferredSize.height);
                buttonWidth = Math.max(buttonWidth, preferredSize.width);
            }
            this.myButtonWidth = buttonWidth;
            int margin = 2;
            this.myMinWidth = minWidth + margin * 2 + (this.myButtons.size() - 1) * 5;
            this.myMinHeight = minHeight + margin * 2;
        }

        public int getButtonWidth() {
            return this.myButtonWidth;
        }

        public Dimension getPreferredSize() {
            return this.expandIfNecessary(this.myBaseDocControl.getPreferredSize());
        }

        public void setPreferredSize(Dimension preferredSize) {
            super.setPreferredSize(preferredSize);
            this.myBaseDocControl.setPreferredSize(preferredSize);
        }

        public Dimension getMinimumSize() {
            return this.expandIfNecessary(this.myBaseDocControl.getMinimumSize());
        }

        public Dimension getMaximumSize() {
            return this.expandIfNecessary(this.myBaseDocControl.getMaximumSize());
        }

        @NotNull
        private Dimension expandIfNecessary(@NotNull Dimension base) {
            if (base.width >= this.myMinWidth && base.height >= this.myMinHeight) {
                return base;
            }
            return new Dimension(Math.max(this.myMinWidth, base.width), Math.max(this.myMinHeight, base.height));
        }

        public void doLayout() {
            Rectangle bounds = this.getBounds();
            this.myBaseDocControl.setBounds(new Rectangle(0, 0, bounds.width, bounds.height));
            int x = bounds.width;
            for (JComponent button : this.myButtons) {
                Dimension buttonSize = button.getPreferredSize();
                button.setBounds(x -= buttonSize.width, 0, buttonSize.width, buttonSize.height);
                x -= 5;
            }
        }

        public void mouseEntered(@NotNull MouseEvent e) {
            this.processStateChangeIfNecessary(e.getLocationOnScreen(), true);
        }

        public void mouseExited(@NotNull MouseEvent e) {
            this.processStateChangeIfNecessary(e.getLocationOnScreen(), false);
        }

        private void processStateChangeIfNecessary(@NotNull Point mouseScreenLocation, boolean mouseEntered) {
            if (CtrlMouseHandler.this.myDocumentationManager.hasActiveDockedDocWindow()) {
                return;
            }
            if (!mouseEntered && new Rectangle(this.getLocationOnScreen(), this.getSize()).contains(mouseScreenLocation)) {
                return;
            }
            for (JComponent button : this.myButtons) {
                button.setVisible(mouseEntered);
            }
        }
    }

    private static class DocInfo {
        public static final DocInfo EMPTY = new DocInfo(null, null, null);
        @Nullable
        public final String text;
        @Nullable
        public final DocumentationProvider docProvider;
        @Nullable
        public final PsiElement documentationAnchor;

        DocInfo(@Nullable String text, @Nullable DocumentationProvider provider2, @Nullable PsiElement documentationAnchor) {
            this.text = text;
            this.docProvider = provider2;
            this.documentationAnchor = documentationAnchor;
        }
    }

    private class HighlightersSet {
        @NotNull
        private final List<RangeHighlighter> myHighlighters;
        @NotNull
        private final Editor myHighlighterView;
        @NotNull
        private final Cursor myStoredCursor;
        @NotNull
        private final Info myStoredInfo;

        private HighlightersSet(@NotNull List<RangeHighlighter> highlighters, @NotNull Editor highlighterView, @NotNull Cursor storedCursor, Info storedInfo) {
            this.myHighlighters = highlighters;
            this.myHighlighterView = highlighterView;
            this.myStoredCursor = storedCursor;
            this.myStoredInfo = storedInfo;
        }

        public void uninstall() {
            for (RangeHighlighter highlighter : this.myHighlighters) {
                highlighter.dispose();
            }
            JComponent internalComponent = this.myHighlighterView.getContentComponent();
            internalComponent.setCursor(this.myStoredCursor);
            internalComponent.removeKeyListener(CtrlMouseHandler.this.myEditorKeyListener);
            this.myHighlighterView.getScrollingModel().removeVisibleAreaListener(CtrlMouseHandler.this.myVisibleAreaListener);
            CtrlMouseHandler.this.myFileEditorManager.removeFileEditorManagerListener(CtrlMouseHandler.this.myFileEditorManagerListener);
        }

        @NotNull
        public Info getStoredInfo() {
            return this.myStoredInfo;
        }
    }

    private class TooltipProvider {
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final LogicalPosition myPosition;
        private BrowseMode myBrowseMode;
        private boolean myDisposed;
        private final ProgressIndicator myProgress = new ProgressIndicatorBase();

        TooltipProvider(@NotNull Editor editor, LogicalPosition pos) {
            this.myEditor = editor;
            this.myPosition = pos;
        }

        void dispose() {
            this.myDisposed = true;
            this.myProgress.cancel();
        }

        public BrowseMode getBrowseMode() {
            return this.myBrowseMode;
        }

        void execute(@NotNull BrowseMode browseMode) {
            this.myBrowseMode = browseMode;
            Document document = this.myEditor.getDocument();
            final PsiFile file2 = PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).getPsiFile(document);
            if (file2 == null) {
                return;
            }
            if (EditorUtil.inVirtualSpace(this.myEditor, this.myPosition)) {
                CtrlMouseHandler.this.disposeHighlighter();
                return;
            }
            final int offset = this.myEditor.logicalPositionToOffset(this.myPosition);
            int selStart = this.myEditor.getSelectionModel().getSelectionStart();
            int selEnd = this.myEditor.getSelectionModel().getSelectionEnd();
            if (offset >= selStart && offset < selEnd) {
                return;
            }
            PsiDocumentManager.getInstance((Project)CtrlMouseHandler.this.myProject).performWhenAllCommitted(() -> ProgressIndicatorUtils.scheduleWithWriteActionPriority(this.myProgress, new ReadTask(){

                @Override
                @Nullable
                public ReadTask.Continuation performInReadAction(@NotNull ProgressIndicator indicator) throws ProcessCanceledException {
                    return TooltipProvider.this.doExecute(file2, offset);
                }

                @Override
                public void onCanceled(@NotNull ProgressIndicator indicator) {
                    LOG.debug("Highlighting was cancelled");
                }
            }));
        }

        @Nullable
        private ReadTask.Continuation doExecute(@NotNull PsiFile file2, int offset) {
            DocInfo docInfo;
            Info info;
            try {
                info = CtrlMouseHandler.this.getInfoAt(this.myEditor, file2, offset, this.myBrowseMode);
                if (info == null) {
                    return null;
                }
                docInfo = info.getInfo();
            }
            catch (IndexNotReadyException e) {
                CtrlMouseHandler.showDumbModeNotification(CtrlMouseHandler.this.myProject);
                return null;
            }
            LOG.debug("Obtained info about element under cursor");
            return new ReadTask.Continuation(() -> {
                if (this.myDisposed || this.myEditor.isDisposed() || !this.myEditor.getComponent().isShowing()) {
                    return;
                }
                this.showHint(info, docInfo);
            });
        }

        private void showHint(@NotNull Info info, @NotNull DocInfo docInfo) {
            if (this.myDisposed || this.myEditor.isDisposed()) {
                return;
            }
            JComponent internalComponent = this.myEditor.getContentComponent();
            if (CtrlMouseHandler.this.myHighlighter != null) {
                if (!info.isSimilarTo(CtrlMouseHandler.this.myHighlighter.getStoredInfo())) {
                    CtrlMouseHandler.this.disposeHighlighter();
                } else {
                    if (info.isNavigatable()) {
                        internalComponent.setCursor(Cursor.getPredefinedCursor(12));
                    }
                    return;
                }
            }
            if (!info.isValid(this.myEditor.getDocument()) || !info.isNavigatable() && docInfo.text == null) {
                return;
            }
            CtrlMouseHandler.this.myHighlighter = CtrlMouseHandler.this.installHighlighterSet(info, this.myEditor);
            if (docInfo.text == null) {
                return;
            }
            if (CtrlMouseHandler.this.myDocumentationManager.hasActiveDockedDocWindow()) {
                info.showDocInfo(CtrlMouseHandler.this.myDocumentationManager);
            }
            QuickDocHyperlinkListener hyperlinkListener = docInfo.docProvider == null ? null : new QuickDocHyperlinkListener(docInfo.docProvider, info.myElementAtPointer);
            final Ref quickDocPaneRef = new Ref();
            MouseAdapter mouseListener = new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    QuickDocInfoPane pane = (QuickDocInfoPane)((Object)quickDocPaneRef.get());
                    if (pane != null) {
                        pane.mouseEntered(e);
                    }
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    QuickDocInfoPane pane = (QuickDocInfoPane)((Object)quickDocPaneRef.get());
                    if (pane != null) {
                        pane.mouseExited(e);
                    }
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                }
            };
            Ref newTextConsumerRef = new Ref();
            JComponent label = HintUtil.createInformationLabel(docInfo.text, hyperlinkListener, mouseListener, (Ref<Consumer<String>>)newTextConsumerRef);
            Consumer newTextConsumer = (Consumer)newTextConsumerRef.get();
            QuickDocInfoPane quickDocPane = null;
            if (docInfo.documentationAnchor != null) {
                quickDocPane = new QuickDocInfoPane(docInfo.documentationAnchor, info.myElementAtPointer, label);
                quickDocPaneRef.set((Object)quickDocPane);
            }
            JComponent hintContent = quickDocPane == null ? label : quickDocPane;
            LightweightHint hint = new LightweightHint(hintContent);
            CtrlMouseHandler.this.myHint = hint;
            hint.addHintListener(new HintListener(){

                @Override
                public void hintHidden(EventObject event) {
                    CtrlMouseHandler.this.myHint = null;
                }
            });
            CtrlMouseHandler.this.myDocAlarm.cancelAllRequests();
            if (newTextConsumer != null && docInfo.docProvider != null && docInfo.documentationAnchor != null) {
                CtrlMouseHandler.this.fulfillDocInfo(docInfo.text, docInfo.docProvider, info.myElementAtPointer, docInfo.documentationAnchor, (Consumer<String>)newTextConsumer, hint);
            }
            this.showHint(hint);
        }

        public void showHint(@NotNull LightweightHint hint) {
            if (this.myEditor.isDisposed()) {
                return;
            }
            HintManagerImpl hintManager = HintManagerImpl.getInstanceImpl();
            short constraint = 1;
            Point p = HintManagerImpl.getHintPosition(hint, this.myEditor, this.myPosition, constraint);
            if (p.y - hint.getComponent().getPreferredSize().height < 0) {
                constraint = 2;
                p = HintManagerImpl.getHintPosition(hint, this.myEditor, this.myPosition, constraint);
            }
            hintManager.showEditorHint(hint, this.myEditor, p, 42, 0, false, HintManagerImpl.createHintHint(this.myEditor, p, hint, constraint).setContentActive(false));
        }
    }

    private static class InfoMultiple
    extends Info {
        public InfoMultiple(@NotNull PsiElement elementAtPointer) {
            super(elementAtPointer);
        }

        public InfoMultiple(@NotNull PsiElement elementAtPointer, @NotNull PsiReference ref) {
            super(elementAtPointer, ReferenceRange.getAbsoluteRanges((PsiReference)ref));
        }

        @Override
        @NotNull
        public DocInfo getInfo() {
            return new DocInfo(CodeInsightBundle.message((String)"multiple.implementations.tooltip", (Object[])new Object[0]), null, null);
        }

        @Override
        public boolean isValid(@NotNull Document document) {
            return this.rangesAreCorrect(document);
        }

        @Override
        public boolean isNavigatable() {
            return true;
        }

        @Override
        public void showDocInfo(@NotNull DocumentationManager docManager) {
        }
    }

    private static class InfoSingle
    extends Info {
        @NotNull
        private final PsiElement myTargetElement;

        public InfoSingle(@NotNull PsiElement elementAtPointer, @NotNull PsiElement targetElement) {
            super(elementAtPointer);
            this.myTargetElement = targetElement;
        }

        public InfoSingle(@NotNull PsiReference ref, @NotNull PsiElement targetElement) {
            super(ref.getElement(), ReferenceRange.getAbsoluteRanges((PsiReference)ref));
            this.myTargetElement = targetElement;
        }

        @Override
        @NotNull
        public DocInfo getInfo() {
            return this.areElementsValid() ? CtrlMouseHandler.generateInfo(this.myTargetElement, this.myElementAtPointer, this.isNavigatable()) : DocInfo.EMPTY;
        }

        private boolean areElementsValid() {
            return this.myTargetElement.isValid() && this.myElementAtPointer.isValid();
        }

        @Override
        public boolean isValid(@NotNull Document document) {
            return this.areElementsValid() && this.rangesAreCorrect(document);
        }

        @Override
        public boolean isNavigatable() {
            return this.myTargetElement != this.myElementAtPointer && this.myTargetElement != this.myElementAtPointer.getParent();
        }

        @Override
        public void showDocInfo(@NotNull DocumentationManager docManager) {
            docManager.showJavaDocInfo(this.myTargetElement, this.myElementAtPointer, null);
            docManager.setAllowContentUpdateFromContext(false);
        }
    }

    private static abstract class Info {
        @NotNull
        protected final PsiElement myElementAtPointer;
        @NotNull
        private final List<TextRange> myRanges;

        public Info(@NotNull PsiElement elementAtPointer, @NotNull List<TextRange> ranges) {
            this.myElementAtPointer = elementAtPointer;
            this.myRanges = ranges;
        }

        public Info(@NotNull PsiElement elementAtPointer) {
            this(elementAtPointer, Info.getReferenceRanges(elementAtPointer));
        }

        @NotNull
        private static List<TextRange> getReferenceRanges(@NotNull PsiElement elementAtPointer) {
            if (!elementAtPointer.isPhysical()) {
                return Collections.emptyList();
            }
            int textOffset = elementAtPointer.getTextOffset();
            TextRange range = elementAtPointer.getTextRange();
            if (range == null) {
                throw new AssertionError((Object)("Null range for " + elementAtPointer + " of " + elementAtPointer.getClass()));
            }
            if (textOffset < range.getStartOffset() || textOffset < 0) {
                LOG.error("Invalid text offset " + textOffset + " of element " + elementAtPointer + " of " + elementAtPointer.getClass());
                textOffset = range.getStartOffset();
            }
            return Collections.singletonList(new TextRange(textOffset, range.getEndOffset()));
        }

        boolean isSimilarTo(@NotNull Info that) {
            return Comparing.equal((Object)this.myElementAtPointer, (Object)that.myElementAtPointer) && this.myRanges.equals(that.myRanges);
        }

        @NotNull
        public List<TextRange> getRanges() {
            return this.myRanges;
        }

        @NotNull
        public abstract DocInfo getInfo();

        public abstract boolean isValid(@NotNull Document var1);

        public abstract boolean isNavigatable();

        public abstract void showDocInfo(@NotNull DocumentationManager var1);

        protected boolean rangesAreCorrect(@NotNull Document document) {
            TextRange docRange = new TextRange(0, document.getTextLength());
            for (TextRange range : this.getRanges()) {
                if (docRange.contains(range)) continue;
                return false;
            }
            return true;
        }
    }

    public static enum BrowseMode {
        None,
        Declaration,
        TypeDeclaration,
        Implementation;

    }
}

