/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.ContainerProvider;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.navigation.ImplementationSearcher;
import com.intellij.codeInsight.navigation.ListBackgroundUpdaterTask;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.ItemPresentation;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.containers.HashMap;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GotoImplementationHandler
extends GotoTargetHandler {
    @Override
    protected String getFeatureUsedKey() {
        return "navigation.goto.implementation";
    }

    @Override
    @Nullable
    public GotoTargetHandler.GotoData getSourceAndTargetElements(@NotNull Editor editor, PsiFile file2) {
        int offset = editor.getCaretModel().getOffset();
        PsiElement source = TargetElementUtil.getInstance().findTargetElement(editor, ImplementationSearcher.getFlags(), offset);
        if (source == null) {
            return null;
        }
        final PsiReference reference = TargetElementUtil.findReference(editor, offset);
        final TargetElementUtil instance = TargetElementUtil.getInstance();
        PsiElement[] targets = new ImplementationSearcher.FirstImplementationsSearcher(){

            @Override
            protected boolean accept(PsiElement element) {
                return instance.acceptImplementationForReference(reference, element);
            }

            @Override
            protected boolean canShowPopupWithOneItem(PsiElement element) {
                return false;
            }
        }.searchImplementations(editor, source, offset);
        if (targets == null) {
            return null;
        }
        GotoTargetHandler.GotoData gotoData = new GotoTargetHandler.GotoData(source, targets, Collections.emptyList());
        gotoData.listUpdaterTask = new ImplementationsUpdaterTask(gotoData, editor, offset, reference){

            @Override
            public void onFinished() {
                super.onFinished();
                PsiElement oneElement = this.getTheOnlyOneElement();
                if (oneElement != null && GotoImplementationHandler.this.navigateToElement(oneElement)) {
                    this.myPopup.cancel();
                }
            }
        };
        return gotoData;
    }

    private static PsiElement getContainer(PsiElement refElement) {
        for (ContainerProvider provider2 : (ContainerProvider[])ContainerProvider.EP_NAME.getExtensions()) {
            PsiElement container = provider2.getContainer(refElement);
            if (container == null) continue;
            return container;
        }
        return refElement.getParent();
    }

    @Override
    @NotNull
    protected String getChooserTitle(@NotNull PsiElement sourceElement, String name, int length, boolean finished2) {
        String fullName;
        ItemPresentation presentation = ((NavigationItem)sourceElement).getPresentation();
        if (presentation == null) {
            fullName = name;
        } else {
            PsiElement container = GotoImplementationHandler.getContainer(sourceElement);
            ItemPresentation containerPresentation = container == null || container instanceof PsiFile ? null : ((NavigationItem)container).getPresentation();
            String containerText = containerPresentation == null ? null : containerPresentation.getPresentableText();
            fullName = (containerText == null ? "" : containerText + ".") + presentation.getPresentableText();
        }
        return CodeInsightBundle.message((String)"goto.implementation.chooserTitle", (Object[])new Object[]{fullName, length, finished2 ? "" : " so far"});
    }

    @Override
    @NotNull
    protected String getFindUsagesTitle(@NotNull PsiElement sourceElement, String name, int length) {
        return CodeInsightBundle.message((String)"goto.implementation.findUsages.title", (Object[])new Object[]{name, length});
    }

    @Override
    @NotNull
    protected String getNotFoundMessage(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        return CodeInsightBundle.message((String)"goto.implementation.notFound", (Object[])new Object[0]);
    }

    private class ImplementationsUpdaterTask
    extends ListBackgroundUpdaterTask {
        private final Editor myEditor;
        private final int myOffset;
        private final GotoTargetHandler.GotoData myGotoData;
        private final Map<Object, PsiElementListCellRenderer> renderers;
        private final PsiReference myReference;

        ImplementationsUpdaterTask(@NotNull GotoTargetHandler.GotoData gotoData, Editor editor, int offset, PsiReference reference) {
            super(gotoData.source.getProject(), ImplementationSearcher.SEARCHING_FOR_IMPLEMENTATIONS);
            this.renderers = new HashMap();
            this.myEditor = editor;
            this.myOffset = offset;
            this.myGotoData = gotoData;
            this.myReference = reference;
        }

        @Override
        public void run(final @NotNull ProgressIndicator indicator) {
            super.run(indicator);
            for (PsiElement element : this.myGotoData.targets) {
                if (this.updateComponent(element, GotoImplementationHandler.this.createComparator(this.renderers, this.myGotoData))) continue;
                return;
            }
            new ImplementationSearcher.BackgroundableImplementationSearcher(){

                @Override
                protected void processElement(PsiElement element) {
                    indicator.checkCanceled();
                    if (!TargetElementUtil.getInstance().acceptImplementationForReference(ImplementationsUpdaterTask.this.myReference, element)) {
                        return;
                    }
                    if (ImplementationsUpdaterTask.this.myGotoData.addTarget(element) && !ImplementationsUpdaterTask.this.updateComponent(element, GotoImplementationHandler.this.createComparator(ImplementationsUpdaterTask.this.renderers, ImplementationsUpdaterTask.this.myGotoData))) {
                        indicator.cancel();
                    }
                }
            }.searchImplementations(this.myEditor, this.myGotoData.source, this.myOffset);
        }

        @Override
        public String getCaption(int size) {
            return GotoImplementationHandler.this.getChooserTitle(this.myGotoData.source, ((PsiNamedElement)this.myGotoData.source).getName(), size, this.isFinished());
        }
    }
}

