/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.navigation.MethodUpDownUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodDownHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        int[] offsets;
        LookupManager.getInstance(project2).hideActiveLookup();
        int caretOffset = editor.getCaretModel().getOffset();
        int caretLine = editor.getCaretModel().getLogicalPosition().line;
        for (int offset : offsets = MethodUpDownUtil.getNavigationOffsets(file2, caretOffset)) {
            int line;
            if (offset <= caretOffset || (line = editor.offsetToLogicalPosition((int)offset).line) <= caretLine) continue;
            editor.getCaretModel().removeSecondaryCarets();
            editor.getCaretModel().moveToOffset(offset);
            editor.getSelectionModel().removeSelection();
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER_DOWN);
            IdeDocumentHistory.getInstance(project2).includeCurrentCommandAsNavigation();
            break;
        }
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

