/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.navigation.MethodUpDownUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodUpHandler
implements CodeInsightActionHandler {
    public void invoke(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        LookupManager.getInstance(project2).hideActiveLookup();
        int caretOffset = editor.getCaretModel().getOffset();
        int caretLine = editor.getCaretModel().getLogicalPosition().line;
        int[] offsets = MethodUpDownUtil.getNavigationOffsets(file2, caretOffset);
        for (int i2 = offsets.length - 1; i2 >= 0; --i2) {
            int line;
            int offset = offsets[i2];
            if (offset >= caretOffset || (line = editor.offsetToLogicalPosition((int)offset).line) >= caretLine) continue;
            editor.getCaretModel().removeSecondaryCarets();
            editor.getCaretModel().moveToOffset(offset);
            editor.getSelectionModel().removeSelection();
            editor.getScrollingModel().scrollToCaret(ScrollType.CENTER_UP);
            IdeDocumentHistory.getInstance(project2).includeCurrentCommandAsNavigation();
            break;
        }
    }

    @Nullable
    public PsiElement getElementToMakeWritable(@NotNull PsiFile currentFile) {
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

