/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.ide.util.EditSourceUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.impl.EditorHistoryManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.ElementBase;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.popup.list.ListPopupImpl;
import com.intellij.ui.popup.list.PopupListElementRenderer;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NavigationUtil {
    private NavigationUtil() {
    }

    @NotNull
    public static JBPopup getPsiElementPopup(@NotNull PsiElement[] elements, String title) {
        return NavigationUtil.getPsiElementPopup(elements, new DefaultPsiElementCellRenderer(), title);
    }

    @NotNull
    public static JBPopup getPsiElementPopup(@NotNull PsiElement[] elements, @NotNull PsiElementListCellRenderer<PsiElement> renderer, String title) {
        return NavigationUtil.getPsiElementPopup((PsiElement[])elements, renderer, (String)title, (PsiElementProcessor)new PsiElementProcessor<PsiElement>(){

            public boolean execute(@NotNull PsiElement element) {
                Navigatable descriptor = EditSourceUtil.getDescriptor((PsiElement)element);
                if (descriptor != null && descriptor.canNavigate()) {
                    descriptor.navigate(true);
                }
                return true;
            }
        });
    }

    @NotNull
    public static <T extends PsiElement> JBPopup getPsiElementPopup(@NotNull T[] elements, @NotNull PsiElementListCellRenderer<T> renderer, String title, @NotNull PsiElementProcessor<T> processor2) {
        return NavigationUtil.getPsiElementPopup(elements, renderer, (String)title, processor2, null);
    }

    @NotNull
    public static <T extends PsiElement> JBPopup getPsiElementPopup(@NotNull T[] elements, @NotNull PsiElementListCellRenderer<T> renderer, @Nullable String title, @NotNull PsiElementProcessor<T> processor2, @Nullable T selection) {
        assert (elements.length > 0) : "Attempted to show a navigation popup with zero elements";
        JBList list = new JBList((Object[])elements);
        HintUpdateSupply.installSimpleHintUpdateSupply((JComponent)list);
        list.setCellRenderer(renderer);
        list.setFont(EditorUtil.getEditorFont());
        if (selection != null) {
            list.setSelectedValue(selection, true);
        }
        Runnable runnable2 = () -> NavigationUtil.lambda$getPsiElementPopup$0((JList)list, processor2);
        PopupChooserBuilder builder = new PopupChooserBuilder((JList)list);
        if (title != null) {
            builder.setTitle(title);
        }
        renderer.installSpeedSearch(builder, true);
        JBPopup popup = builder.setItemChoosenCallback(runnable2).createPopup();
        builder.getScrollPane().setBorder(null);
        builder.getScrollPane().setViewportBorder(null);
        NavigationUtil.hidePopupIfDumbModeStarts(popup, elements[0].getProject());
        return popup;
    }

    public static void hidePopupIfDumbModeStarts(final @NotNull JBPopup popup, @NotNull Project project2) {
        if (!DumbService.isDumb((Project)project2)) {
            project2.getMessageBus().connect((Disposable)popup).subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(){

                public void enteredDumbMode() {
                    popup.cancel();
                }
            });
        }
    }

    public static boolean activateFileWithPsiElement(@NotNull PsiElement elt) {
        return NavigationUtil.activateFileWithPsiElement(elt, true);
    }

    public static boolean activateFileWithPsiElement(@NotNull PsiElement elt, boolean searchForOpen) {
        return NavigationUtil.openFileWithPsiElement(elt, searchForOpen, true);
    }

    public static boolean openFileWithPsiElement(PsiElement element, boolean searchForOpen, boolean requestFocus) {
        VirtualFile virtualFile;
        boolean openAsNative = false;
        if (element instanceof PsiFile && (virtualFile = ((PsiFile)element).getVirtualFile()) != null) {
            openAsNative = ElementBase.isNativeFileType((FileType)virtualFile.getFileType());
        }
        if (searchForOpen) {
            element.putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        } else {
            element.putUserData(FileEditorManager.USE_CURRENT_WINDOW, (Object)true);
        }
        if (openAsNative || !NavigationUtil.activatePsiElementIfOpen(element, searchForOpen, requestFocus)) {
            NavigationItem navigationItem = (NavigationItem)element;
            if (!navigationItem.canNavigate()) {
                return false;
            }
            navigationItem.navigate(requestFocus);
            return true;
        }
        element.putUserData(FileEditorManager.USE_CURRENT_WINDOW, null);
        return false;
    }

    private static boolean activatePsiElementIfOpen(@NotNull PsiElement elt, boolean searchForOpen, boolean requestFocus) {
        FileEditor[] editors;
        TextRange range;
        if (!elt.isValid()) {
            return false;
        }
        PsiFile file2 = (elt = elt.getNavigationElement()).getContainingFile();
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        VirtualFile vFile = file2.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        if (!EditorHistoryManager.getInstance(elt.getProject()).hasBeenOpen(vFile)) {
            return false;
        }
        FileEditorManager fem = FileEditorManager.getInstance((Project)elt.getProject());
        if (!fem.isFileOpen(vFile)) {
            fem.openFile(vFile, requestFocus, searchForOpen);
        }
        if ((range = elt.getTextRange()) == null) {
            return false;
        }
        for (FileEditor editor : editors = fem.getEditors(vFile)) {
            Editor text;
            int offset;
            if (!(editor instanceof TextEditor) || !range.containsOffset(offset = (text = ((TextEditor)editor).getEditor()).getCaretModel().getOffset())) continue;
            fem.openFile(vFile, requestFocus, searchForOpen);
            return true;
        }
        return false;
    }

    public static TextAttributes patchAttributesColor(TextAttributes attributes, @NotNull TextRange range, @NotNull Editor editor) {
        if (attributes.getForegroundColor() == null && attributes.getEffectColor() == null) {
            return attributes;
        }
        MarkupModel model = DocumentMarkupModel.forDocument(editor.getDocument(), editor.getProject(), false);
        if (model != null && !((MarkupModelEx)model).processRangeHighlightersOverlappingWith(range.getStartOffset(), range.getEndOffset(), (Processor<? super RangeHighlighterEx>)((Processor)highlighter -> {
            TextAttributes textAttributes;
            if (highlighter.isValid() && highlighter.getTargetArea() == HighlighterTargetArea.LINES_IN_RANGE && (textAttributes = highlighter.getTextAttributes()) != null) {
                Color color = textAttributes.getBackgroundColor();
                return color == null || color.getBlue() <= 128 || color.getRed() >= 128 || color.getGreen() >= 128;
            }
            return true;
        }))) {
            TextAttributes clone = attributes.clone();
            clone.setForegroundColor(Color.orange);
            clone.setEffectColor(Color.orange);
            return clone;
        }
        return attributes;
    }

    @NotNull
    public static JBPopup getRelatedItemsPopup(List<? extends GotoRelatedItem> items, String title) {
        return NavigationUtil.getRelatedItemsPopup(items, title, false);
    }

    @NotNull
    public static JBPopup getRelatedItemsPopup(List<? extends GotoRelatedItem> items, String title, boolean showContainingModules) {
        Object[] elements = new Object[items.size()];
        HashMap<PsiElement, GotoRelatedItem> itemsMap = new HashMap<PsiElement, GotoRelatedItem>();
        for (int i2 = 0; i2 < items.size(); ++i2) {
            GotoRelatedItem item = items.get(i2);
            elements[i2] = item.getElement() != null ? item.getElement() : item;
            itemsMap.put(item.getElement(), item);
        }
        return NavigationUtil.getPsiElementPopup(elements, itemsMap, title, showContainingModules, (Processor<Object>)((Processor)element -> {
            if (element instanceof PsiElement) {
                ((GotoRelatedItem)itemsMap.get(element)).navigate();
            } else {
                ((GotoRelatedItem)element).navigate();
            }
            return true;
        }));
    }

    private static JBPopup getPsiElementPopup(Object[] elements, final Map<PsiElement, GotoRelatedItem> itemsMap, String title, final boolean showContainingModules, final Processor<Object> processor2) {
        final Ref hasMnemonic = Ref.create((Object)false);
        final DefaultPsiElementCellRenderer renderer = new DefaultPsiElementCellRenderer(){
            {
                this.setFocusBorderEnabled(false);
            }

            @Override
            public String getElementText(PsiElement element) {
                String customName = ((GotoRelatedItem)itemsMap.get(element)).getCustomName();
                return customName != null ? customName : super.getElementText(element);
            }

            @Override
            protected Icon getIcon(PsiElement element) {
                Icon customIcon = ((GotoRelatedItem)itemsMap.get(element)).getCustomIcon();
                return customIcon != null ? customIcon : super.getIcon(element);
            }

            @Override
            public String getContainerText(PsiElement element, String name) {
                String customContainerName = ((GotoRelatedItem)itemsMap.get(element)).getCustomContainerName();
                if (customContainerName != null) {
                    return customContainerName;
                }
                PsiFile file2 = element.getContainingFile();
                return file2 != null && !this.getElementText(element).equals(file2.getName()) ? "(" + file2.getName() + ")" : null;
            }

            @Override
            protected DefaultListCellRenderer getRightCellRenderer(Object value2) {
                return showContainingModules ? super.getRightCellRenderer(value2) : null;
            }

            @Override
            protected boolean customizeNonPsiElementLeftRenderer(ColoredListCellRenderer renderer, JList list, Object value2, int index, boolean selected, boolean hasFocus) {
                GotoRelatedItem item = (GotoRelatedItem)value2;
                Color color = list.getForeground();
                SimpleTextAttributes nameAttributes = new SimpleTextAttributes(0, color);
                String name = item.getCustomName();
                if (name == null) {
                    return false;
                }
                renderer.append(name, nameAttributes);
                renderer.setIcon(item.getCustomIcon());
                return true;
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                JPanel component = (JPanel)super.getListCellRendererComponent(list, value2, index, isSelected, cellHasFocus);
                if (!((Boolean)hasMnemonic.get()).booleanValue()) {
                    return component;
                }
                JPanel panelWithMnemonic = new JPanel(new BorderLayout());
                int mnemonic = NavigationUtil.getMnemonic(value2, itemsMap);
                JLabel label = new JLabel("");
                if (mnemonic != -1) {
                    label.setText(mnemonic + ".");
                    label.setDisplayedMnemonicIndex(0);
                }
                label.setPreferredSize(new JLabel("8.").getPreferredSize());
                JComponent leftRenderer = (JComponent)component.getComponents()[0];
                component.remove(leftRenderer);
                panelWithMnemonic.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 0));
                panelWithMnemonic.setBackground(leftRenderer.getBackground());
                label.setBackground(leftRenderer.getBackground());
                panelWithMnemonic.add((Component)label, "West");
                panelWithMnemonic.add((Component)leftRenderer, "Center");
                component.add(panelWithMnemonic);
                return component;
            }
        };
        final ListPopupImpl popup = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<Object>(title, Arrays.asList(elements)){

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            public String getIndexedString(Object value2) {
                if (value2 instanceof GotoRelatedItem) {
                    return ((GotoRelatedItem)value2).getCustomName();
                }
                PsiElement element = (PsiElement)value2;
                if (!element.isValid()) {
                    return "INVALID";
                }
                return renderer.getElementText(element) + " " + renderer.getContainerText(element, (String)null);
            }

            public PopupStep onChosen(Object selectedValue, boolean finalChoice) {
                processor2.process(selectedValue);
                return super.onChosen(selectedValue, finalChoice);
            }
        }){};
        popup.getList().setCellRenderer(new PopupListElementRenderer(popup){
            Map<Object, String> separators;
            {
                super(x0);
                this.separators = new HashMap<Object, String>();
                ListModel model = popup.getList().getModel();
                String current = null;
                boolean hasTitle = false;
                for (int i2 = 0; i2 < model.getSize(); ++i2) {
                    Object element = model.getElementAt(i2);
                    GotoRelatedItem item = (GotoRelatedItem)itemsMap.get(element);
                    if (item == null || StringUtil.equals(current, (CharSequence)item.getGroup())) continue;
                    current = item.getGroup();
                    this.separators.put(element, current);
                    if (hasTitle || StringUtil.isEmpty((String)current)) continue;
                    hasTitle = true;
                }
                if (!hasTitle) {
                    this.separators.remove(model.getElementAt(0));
                }
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value2, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = renderer.getListCellRendererComponent(list, value2, index, isSelected, cellHasFocus);
                String separator = this.separators.get(value2);
                if (separator != null) {
                    JPanel panel2 = new JPanel(new BorderLayout());
                    panel2.add(component, "Center");
                    SeparatorWithText sep = new SeparatorWithText(){

                        protected void paintComponent(Graphics g) {
                            g.setColor((Color)new JBColor(Color.WHITE, UIUtil.getSeparatorColor()));
                            g.fillRect(0, 0, this.getWidth(), this.getHeight());
                            super.paintComponent(g);
                        }
                    };
                    sep.setCaption(separator);
                    panel2.add((Component)sep, "North");
                    return panel2;
                }
                return component;
            }
        });
        popup.setMinimumSize(new Dimension(200, -1));
        for (Object item : elements) {
            int mnemonic = NavigationUtil.getMnemonic(item, itemsMap);
            if (mnemonic == -1) continue;
            Action action = NavigationUtil.createNumberAction(mnemonic, popup, itemsMap, processor2);
            popup.registerAction(mnemonic + "Action", KeyStroke.getKeyStroke(String.valueOf(mnemonic)), action);
            popup.registerAction(mnemonic + "Action", KeyStroke.getKeyStroke("NUMPAD" + String.valueOf(mnemonic)), action);
            hasMnemonic.set((Object)true);
        }
        return popup;
    }

    private static Action createNumberAction(final int mnemonic, final ListPopupImpl listPopup, final Map<PsiElement, GotoRelatedItem> itemsMap, final Processor<Object> processor2) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Object item : listPopup.getListStep().getValues()) {
                    if (NavigationUtil.getMnemonic(item, itemsMap) != mnemonic) continue;
                    listPopup.setFinalRunnable(() -> processor2.process(item));
                    listPopup.closeOk(null);
                }
            }
        };
    }

    private static int getMnemonic(Object item, Map<PsiElement, GotoRelatedItem> itemsMap) {
        return (item instanceof GotoRelatedItem ? (GotoRelatedItem)item : itemsMap.get((PsiElement)item)).getMnemonic();
    }

    @NotNull
    public static List<GotoRelatedItem> collectRelatedItems(@NotNull PsiElement contextElement, @Nullable DataContext dataContext) {
        LinkedHashSet items = ContainerUtil.newLinkedHashSet();
        for (GotoRelatedProvider provider2 : (GotoRelatedProvider[])Extensions.getExtensions((ExtensionPointName)GotoRelatedProvider.EP_NAME)) {
            items.addAll(provider2.getItems(contextElement));
            if (dataContext == null) continue;
            items.addAll(provider2.getItems(dataContext));
        }
        GotoRelatedItem[] result2 = items.toArray(new GotoRelatedItem[items.size()]);
        Arrays.sort(result2, (i1, i2) -> {
            String o1 = i1.getGroup();
            String o2 = i2.getGroup();
            return StringUtil.isEmpty((String)o1) ? 1 : (StringUtil.isEmpty((String)o2) ? -1 : o1.compareTo(o2));
        });
        return Arrays.asList(result2);
    }

    private static /* synthetic */ void lambda$getPsiElementPopup$0(JList list, @NotNull PsiElementProcessor processor2) {
        int[] ids = list.getSelectedIndices();
        if (ids == null || ids.length == 0) {
            return;
        }
        for (Object element : list.getSelectedValues()) {
            if (element == null) continue;
            processor2.execute((PsiElement)element);
        }
    }
}

