/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.preview;

import com.intellij.codeInsight.preview.ColorPreviewComponent;
import com.intellij.codeInsight.preview.ImagePreviewComponent;
import com.intellij.codeInsight.preview.PreviewHintProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiExpressionPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.xml.util.ColorMap;
import java.awt.Color;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class JavaPreviewHintProvider
implements PreviewHintProvider {
    private static final PsiMethodPattern DECODE_METHOD = (PsiMethodPattern)PsiJavaPatterns.psiMethod().definedInClass(Color.class.getName()).withName("decode");
    private static final PsiExpressionPattern.Capture<PsiExpression> DECODE_METHOD_CALL_PARAMETER = (PsiExpressionPattern.Capture)PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)DECODE_METHOD);
    private static final PsiMethodPattern GET_COLOR_METHOD = (PsiMethodPattern)PsiJavaPatterns.psiMethod().definedInClass(Color.class.getName()).withName("getColor");
    private static final PsiExpressionPattern.Capture<PsiExpression> GET_METHOD_CALL_PARAMETER = (PsiExpressionPattern.Capture)PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)GET_COLOR_METHOD);

    private static boolean isInsideDecodeOrGetColorMethod(PsiElement element) {
        if (element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == JavaTokenType.STRING_LITERAL) {
            element = element.getParent();
        }
        return DECODE_METHOD_CALL_PARAMETER.accepts((Object)element) || GET_METHOD_CALL_PARAMETER.accepts((Object)element);
    }

    public boolean isSupportedFile(PsiFile file2) {
        return file2 instanceof PsiJavaFile;
    }

    public JComponent getPreviewComponent(@NotNull PsiElement element) {
        PsiLiteralExpression psiLiteralExpression;
        PsiElement psiElement;
        PsiReference reference;
        PsiExpressionList argumentList;
        PsiElement psiElement2;
        PsiReference reference22;
        PsiJavaCodeReferenceElement referenceElement;
        PsiNewExpression psiNewExpression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
        if (psiNewExpression != null && (referenceElement = (PsiJavaCodeReferenceElement)PsiTreeUtil.getChildOfType((PsiElement)psiNewExpression, PsiJavaCodeReferenceElement.class)) != null && (reference22 = referenceElement.getReference()) != null && (psiElement2 = reference22.resolve()) instanceof PsiClass && "java.awt.Color".equals(((PsiClass)psiElement2).getQualifiedName()) && (argumentList = psiNewExpression.getArgumentList()) != null) {
            PsiExpression[] expressions2 = argumentList.getExpressions();
            int[] values = ArrayUtil.newIntArray((int)expressions2.length);
            float[] values2 = new float[expressions2.length];
            int i = 0;
            int j = 0;
            PsiConstantEvaluationHelper helper = JavaPsiFacade.getInstance((Project)element.getProject()).getConstantEvaluationHelper();
            for (PsiExpression each : expressions2) {
                Object o = helper.computeConstantExpression((PsiElement)each);
                if (o instanceof Integer) {
                    values[i] = (Integer)o;
                    if (expressions2.length != 1) {
                        values[i] = values[i] > 255 ? 255 : (values[i] < 0 ? 0 : values[i]);
                    }
                    ++i;
                    continue;
                }
                if (!(o instanceof Float)) continue;
                values2[j] = ((Float)o).floatValue();
                values2[j] = values2[j] > 1.0f ? 1.0f : (values2[j] < 0.0f ? 0.0f : values2[j]);
                ++j;
            }
            Color c = null;
            if (i == expressions2.length) {
                if (i == 1 && values[0] > 255) {
                    c = new Color(values[0]);
                } else {
                    switch (values.length) {
                        case 1: {
                            c = new Color(values[0]);
                            break;
                        }
                        case 3: {
                            c = new Color(values[0], values[1], values[2]);
                            break;
                        }
                        case 4: {
                            c = new Color(values[0], values[1], values[2], values[3]);
                            break;
                        }
                    }
                }
            } else if (j == expressions2.length) {
                switch (values2.length) {
                    case 3: {
                        c = new Color(values2[0], values2[1], values2[2]);
                        break;
                    }
                    case 4: {
                        c = new Color(values2[0], values2[1], values2[2], values2[3]);
                        break;
                    }
                }
            }
            if (c != null) {
                return new ColorPreviewComponent(c);
            }
        }
        if (JavaPreviewHintProvider.isInsideDecodeOrGetColorMethod(element)) {
            String color = StringUtil.unquoteString((String)element.getText());
            try {
                return new ColorPreviewComponent(Color.decode(color));
            }
            catch (NumberFormatException reference22) {
                // empty catch block
            }
        }
        if (((PsiElementPattern.Capture)PlatformPatterns.psiElement(PsiIdentifier.class).withParent((ElementPattern)PlatformPatterns.psiElement(PsiReferenceExpression.class))).accepts((Object)element) && (reference = element.getParent().getReference()) != null && (psiElement = reference.resolve()) instanceof PsiField && "java.awt.Color".equals(((PsiField)psiElement).getContainingClass().getQualifiedName())) {
            String colorName = ((PsiField)psiElement).getName().toLowerCase().replace("_", "");
            String hex = ColorMap.getHexCodeForColorName(colorName);
            return new ColorPreviewComponent(Color.decode("0x" + hex.substring(1)));
        }
        if (((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParent((ElementPattern)PlatformPatterns.psiElement(PsiLiteralExpression.class))).accepts((Object)element) && (psiLiteralExpression = (PsiLiteralExpression)element.getParent()) != null) {
            return ImagePreviewComponent.getPreviewComponent((PsiElement)psiLiteralExpression);
        }
        return null;
    }
}

