/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.problems;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.Problem;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProblemImpl
implements Problem {
    private final VirtualFile virtualFile;
    private final HighlightInfo highlightInfo;
    private final boolean isSyntax;

    public ProblemImpl(@NotNull VirtualFile virtualFile, @NotNull HighlightInfo highlightInfo, boolean isSyntax) {
        this.isSyntax = isSyntax;
        this.virtualFile = virtualFile;
        this.highlightInfo = highlightInfo;
    }

    @NotNull
    public VirtualFile getVirtualFile() {
        return this.virtualFile;
    }

    public boolean isSyntaxOnly() {
        return this.isSyntax;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProblemImpl problem = (ProblemImpl)o;
        if (this.isSyntax != problem.isSyntax) {
            return false;
        }
        if (!this.highlightInfo.equals(problem.highlightInfo)) {
            return false;
        }
        return this.virtualFile.equals(problem.virtualFile);
    }

    public int hashCode() {
        int result2 = this.virtualFile.hashCode();
        result2 = 31 * result2 + this.highlightInfo.hashCode();
        result2 = 31 * result2 + (this.isSyntax ? 1 : 0);
        return result2;
    }

    @NonNls
    public String toString() {
        return "Problem: " + this.highlightInfo;
    }
}

