/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.problems;

import com.intellij.codeInsight.daemon.impl.GeneralHighlightingPass;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.daemon.impl.HighlightInfoProcessor;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.ProgressableTextEditorHighlightingPass;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightInfoHolder;
import com.intellij.codeInsight.problems.ProblemImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatusListener;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.problems.Problem;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WolfTheProblemSolverImpl
extends WolfTheProblemSolver {
    private final Map<VirtualFile, ProblemFileInfo> myProblems = new THashMap();
    private final Collection<VirtualFile> myCheckingQueue = new THashSet(10);
    private final Project myProject;
    private final List<WolfTheProblemSolver.ProblemListener> myProblemListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final List<Condition<VirtualFile>> myFilters = ContainerUtil.createLockFreeCopyOnWriteList();
    private boolean myFiltersLoaded = false;
    private final WolfTheProblemSolver.ProblemListener fireProblemListeners = new WolfTheProblemSolver.ProblemListener(){

        public void problemsAppeared(@NotNull VirtualFile file2) {
            for (WolfTheProblemSolver.ProblemListener problemListener : WolfTheProblemSolverImpl.this.myProblemListeners) {
                problemListener.problemsAppeared(file2);
            }
        }

        public void problemsChanged(@NotNull VirtualFile file2) {
            for (WolfTheProblemSolver.ProblemListener problemListener : WolfTheProblemSolverImpl.this.myProblemListeners) {
                problemListener.problemsChanged(file2);
            }
        }

        public void problemsDisappeared(@NotNull VirtualFile file2) {
            for (WolfTheProblemSolver.ProblemListener problemListener : WolfTheProblemSolverImpl.this.myProblemListeners) {
                problemListener.problemsDisappeared(file2);
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemove(@NotNull VirtualFile problemFile) {
        ProblemFileInfo old;
        Object object = this.myProblems;
        synchronized (object) {
            old = this.myProblems.remove(problemFile);
        }
        object = this.myCheckingQueue;
        synchronized (object) {
            this.myCheckingQueue.remove(problemFile);
        }
        if (old != null) {
            this.fireProblemListeners.problemsDisappeared(problemFile);
        }
    }

    public WolfTheProblemSolverImpl(@NotNull Project project2, @NotNull PsiManager psiManager, @NotNull VirtualFileManager virtualFileManager) {
        this.myProject = project2;
        PsiTreeChangeAdapter changeListener = new PsiTreeChangeAdapter(){

            public void childAdded(@NotNull PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childRemoved(@NotNull PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childReplaced(@NotNull PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childMoved(@NotNull PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void propertyChanged(@NotNull PsiTreeChangeEvent event) {
                this.childrenChanged(event);
            }

            public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
                WolfTheProblemSolverImpl.this.clearSyntaxErrorFlag(event);
            }
        };
        psiManager.addPsiTreeChangeListener((PsiTreeChangeListener)changeListener);
        VirtualFileAdapter virtualFileListener = new VirtualFileAdapter(){

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                this.onDeleted(event.getFile());
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                this.onDeleted(event.getFile());
            }

            private void onDeleted(@NotNull VirtualFile file2) {
                if (file2.isDirectory()) {
                    WolfTheProblemSolverImpl.this.clearInvalidFiles();
                } else {
                    WolfTheProblemSolverImpl.this.doRemove(file2);
                }
            }
        };
        virtualFileManager.addVirtualFileListener((VirtualFileListener)virtualFileListener, (Disposable)this.myProject);
        FileStatusManager fileStatusManager = FileStatusManager.getInstance((Project)this.myProject);
        if (fileStatusManager != null) {
            fileStatusManager.addFileStatusListener(new FileStatusListener(){

                public void fileStatusesChanged() {
                    WolfTheProblemSolverImpl.this.clearInvalidFiles();
                }

                public void fileStatusChanged(@NotNull VirtualFile virtualFile) {
                    this.fileStatusesChanged();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearInvalidFiles() {
        VirtualFile[] virtualFileArray = this.myProblems;
        synchronized (this.myProblems) {
            VirtualFile[] files = VfsUtilCore.toVirtualFileArray(this.myProblems.keySet());
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (VirtualFile problemFile : files) {
                if (problemFile.isValid() && this.isToBeHighlighted(problemFile)) continue;
                this.doRemove(problemFile);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearSyntaxErrorFlag(@NotNull PsiTreeChangeEvent event) {
        PsiFile file2 = event.getFile();
        if (file2 == null) {
            return;
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            ProblemFileInfo info = this.myProblems.get(virtualFile);
            if (info != null) {
                info.hasSyntaxErrors = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCheckingIfVincentSolvedProblemsYet(@NotNull ProgressIndicator progress, @NotNull ProgressableTextEditorHighlightingPass pass) throws ProcessCanceledException {
        ArrayList<VirtualFile> files;
        if (!this.myProject.isOpen()) {
            return;
        }
        Collection<VirtualFile> collection = this.myCheckingQueue;
        synchronized (collection) {
            files = new ArrayList<VirtualFile>(this.myCheckingQueue);
        }
        long progressLimit = files.stream().filter(VirtualFile::isValid).mapToLong(VirtualFile::getLength).sum();
        pass.setProgressLimit(progressLimit);
        for (VirtualFile virtualFile : files) {
            progress.checkCanceled();
            if (virtualFile == null) break;
            if (!virtualFile.isValid() || this.orderVincentToCleanTheCar(virtualFile, progress)) {
                this.doRemove(virtualFile);
            }
            if (!virtualFile.isValid()) continue;
            pass.advanceProgress(virtualFile.getLength());
        }
    }

    private boolean orderVincentToCleanTheCar(@NotNull VirtualFile file2, @NotNull ProgressIndicator progressIndicator) throws ProcessCanceledException {
        if (!this.isToBeHighlighted(file2)) {
            this.clearProblems(file2);
            return true;
        }
        if (this.hasSyntaxErrors(file2)) {
            return false;
        }
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (this.willBeHighlightedAnyway(file2)) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile == null) {
            return false;
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return false;
        }
        final AtomicReference error = new AtomicReference();
        final AtomicBoolean hasErrorElement = new AtomicBoolean();
        try {
            GeneralHighlightingPass pass = new GeneralHighlightingPass(this.myProject, psiFile, document, 0, document.getTextLength(), false, new ProperTextRange(0, document.getTextLength()), null, HighlightInfoProcessor.getEmpty()){

                @Override
                protected HighlightInfoHolder createInfoHolder(@NotNull PsiFile file2) {
                    return new HighlightInfoHolder(file2, new HighlightInfoFilter[0]){

                        @Override
                        public boolean add(@Nullable HighlightInfo info) {
                            if (info != null && info.getSeverity() == HighlightSeverity.ERROR) {
                                error.set(info);
                                hasErrorElement.set(myHasErrorElement);
                                throw new ProcessCanceledException();
                            }
                            return super.add(info);
                        }
                    };
                }
            };
            pass.collectInformation(progressIndicator);
        }
        catch (ProcessCanceledException e) {
            if (error.get() != null) {
                ProblemImpl problem = new ProblemImpl(file2, (HighlightInfo)error.get(), hasErrorElement.get());
                this.reportProblems(file2, Collections.singleton(problem));
            }
            return false;
        }
        this.clearProblems(file2);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSyntaxErrors(VirtualFile file2) {
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            ProblemFileInfo info = this.myProblems.get(file2);
            return info != null && info.hasSyntaxErrors;
        }
    }

    private boolean willBeHighlightedAnyway(VirtualFile file2) {
        FileEditor[] selectedEditors;
        for (FileEditor editor : selectedEditors = FileEditorManager.getInstance((Project)this.myProject).getSelectedEditors()) {
            if (!(editor instanceof TextEditor)) continue;
            Document document = ((TextEditor)editor).getEditor().getDocument();
            PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.myProject).getCachedPsiFile(document);
            if (psiFile == null || !Comparing.equal((Object)file2, (Object)psiFile.getVirtualFile())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasProblemFilesBeneath(@NotNull Condition<VirtualFile> condition2) {
        if (!this.myProject.isOpen()) {
            return false;
        }
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            if (!this.myProblems.isEmpty()) {
                for (VirtualFile problemFile : this.myProblems.keySet()) {
                    if (!problemFile.isValid() || !condition2.value((Object)problemFile)) continue;
                    return true;
                }
            }
            return false;
        }
    }

    public boolean hasProblemFilesBeneath(@NotNull Module scope) {
        return this.hasProblemFilesBeneath((Condition<VirtualFile>)((Condition)virtualFile -> ModuleUtilCore.moduleContainsFile((Module)scope, (VirtualFile)virtualFile, (boolean)false)));
    }

    public void addProblemListener(@NotNull WolfTheProblemSolver.ProblemListener listener2) {
        this.myProblemListeners.add(listener2);
    }

    public void addProblemListener(final @NotNull WolfTheProblemSolver.ProblemListener listener2, @NotNull Disposable parentDisposable) {
        this.addProblemListener(listener2);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                WolfTheProblemSolverImpl.this.removeProblemListener(listener2);
            }
        });
    }

    public void removeProblemListener(@NotNull WolfTheProblemSolver.ProblemListener listener2) {
        this.myProblemListeners.remove(listener2);
    }

    public void registerFileHighlightFilter(final @NotNull Condition<VirtualFile> filter, @NotNull Disposable parentDisposable) {
        this.myFilters.add(filter);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                WolfTheProblemSolverImpl.this.myFilters.remove(filter);
            }
        });
    }

    public void queue(VirtualFile suspiciousFile) {
        if (!this.isToBeHighlighted(suspiciousFile)) {
            return;
        }
        this.doQueue(suspiciousFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQueue(@NotNull VirtualFile suspiciousFile) {
        Collection<VirtualFile> collection = this.myCheckingQueue;
        synchronized (collection) {
            this.myCheckingQueue.add(suspiciousFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isProblemFile(VirtualFile virtualFile) {
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            return this.myProblems.containsKey(virtualFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isToBeHighlighted(@Nullable VirtualFile virtualFile) {
        if (virtualFile == null) {
            return false;
        }
        List<Condition<VirtualFile>> list = this.myFilters;
        synchronized (list) {
            if (!this.myFiltersLoaded) {
                this.myFiltersLoaded = true;
                this.myFilters.addAll(Arrays.asList(Extensions.getExtensions((ExtensionPointName)FILTER_EP_NAME, (AreaInstance)this.myProject)));
            }
        }
        for (Condition condition2 : this.myFilters) {
            ProgressManager.checkCanceled();
            if (!condition2.value((Object)virtualFile)) continue;
            return true;
        }
        return false;
    }

    public void weHaveGotProblems(@NotNull VirtualFile virtualFile, @NotNull List<Problem> problems) {
        if (problems.isEmpty()) {
            return;
        }
        if (!this.isToBeHighlighted(virtualFile)) {
            return;
        }
        this.weHaveGotNonIgnorableProblems(virtualFile, problems);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void weHaveGotNonIgnorableProblems(@NotNull VirtualFile virtualFile, @NotNull List<Problem> problems) {
        if (problems.isEmpty()) {
            return;
        }
        boolean fireListener = false;
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            ProblemFileInfo storedProblems = this.myProblems.get(virtualFile);
            if (storedProblems == null) {
                storedProblems = new ProblemFileInfo();
                this.myProblems.put(virtualFile, storedProblems);
                fireListener = true;
            }
            storedProblems.problems.addAll(problems);
        }
        this.doQueue(virtualFile);
        if (fireListener) {
            this.fireProblemListeners.problemsAppeared(virtualFile);
        }
    }

    public void clearProblems(@NotNull VirtualFile virtualFile) {
        this.doRemove(virtualFile);
    }

    public Problem convertToProblem(@Nullable VirtualFile virtualFile, int line, int column, @NotNull String[] message2) {
        if (virtualFile == null || virtualFile.isDirectory() || virtualFile.getFileType().isBinary()) {
            return null;
        }
        HighlightInfo info = (HighlightInfo)ReadAction.compute(() -> {
            TextRange textRange = WolfTheProblemSolverImpl.getTextRange(virtualFile, line, column);
            String description = StringUtil.join((String[])message2, (String)"\n");
            return HighlightInfo.newHighlightInfo(HighlightInfoType.ERROR).range(textRange).descriptionAndTooltip(description).create();
        });
        if (info == null) {
            return null;
        }
        return new ProblemImpl(virtualFile, info, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportProblems(@NotNull VirtualFile file2, @NotNull Collection<Problem> problems) {
        boolean fireChanged;
        boolean hasProblemsBefore;
        if (problems.isEmpty()) {
            this.clearProblems(file2);
            return;
        }
        if (!this.isToBeHighlighted(file2)) {
            return;
        }
        Map<VirtualFile, ProblemFileInfo> map2 = this.myProblems;
        synchronized (map2) {
            ProblemFileInfo oldInfo = this.myProblems.remove(file2);
            hasProblemsBefore = oldInfo != null;
            ProblemFileInfo newInfo = new ProblemFileInfo();
            this.myProblems.put(file2, newInfo);
            for (Problem problem : problems) {
                newInfo.problems.add(problem);
                ProblemFileInfo problemFileInfo = newInfo;
                problemFileInfo.hasSyntaxErrors = problemFileInfo.hasSyntaxErrors | ((ProblemImpl)problem).isSyntaxOnly();
            }
            fireChanged = hasProblemsBefore && !oldInfo.equals(newInfo);
        }
        this.doQueue(file2);
        if (!hasProblemsBefore) {
            this.fireProblemListeners.problemsAppeared(file2);
        } else if (fireChanged) {
            this.fireProblemListeners.problemsChanged(file2);
        }
    }

    @NotNull
    private static TextRange getTextRange(@NotNull VirtualFile virtualFile, int line, int column) {
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (line > document.getLineCount()) {
            line = document.getLineCount();
        }
        line = line <= 0 ? 0 : line - 1;
        int offset = document.getLineStartOffset(line) + (column <= 0 ? 0 : column - 1);
        return new TextRange(offset, offset);
    }

    private static class ProblemFileInfo {
        private final Collection<Problem> problems = new THashSet();
        private boolean hasSyntaxErrors;

        private ProblemFileInfo() {
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProblemFileInfo that = (ProblemFileInfo)o;
            return this.hasSyntaxErrors == that.hasSyntaxErrors && this.problems.equals(that.problems);
        }

        public int hashCode() {
            int result2 = this.problems.hashCode();
            result2 = 31 * result2 + (this.hasSyntaxErrors ? 1 : 0);
            return result2;
        }
    }
}

