/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.quickfix;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiReference;
import com.intellij.util.ReflectionUtil;
import org.jetbrains.annotations.NotNull;

public abstract class UnresolvedReferenceQuickFixProvider<T extends PsiReference> {
    private static final ExtensionPointName<UnresolvedReferenceQuickFixProvider> EXTENSION_NAME = ExtensionPointName.create((String)"com.intellij.codeInsight.unresolvedReferenceQuickFixProvider");

    public static <T extends PsiReference> void registerReferenceFixes(@NotNull T ref, @NotNull QuickFixActionRegistrar registrar) {
        boolean dumb = DumbService.getInstance((Project)ref.getElement().getProject()).isDumb();
        UnresolvedReferenceQuickFixProvider[] fixProviders = (UnresolvedReferenceQuickFixProvider[])Extensions.getExtensions(EXTENSION_NAME);
        Class<?> referenceClass = ref.getClass();
        for (UnresolvedReferenceQuickFixProvider each : fixProviders) {
            if (dumb && !DumbService.isDumbAware((Object)each) || !ReflectionUtil.isAssignable(each.getReferenceClass(), referenceClass)) continue;
            each.registerFixes(ref, registrar);
        }
    }

    public abstract void registerFixes(@NotNull T var1, @NotNull QuickFixActionRegistrar var2);

    @NotNull
    public abstract Class<T> getReferenceClass();
}

