/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template;

import com.intellij.codeInsight.completion.JavaKeywordCompletion;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.EverywhereContextType;
import com.intellij.codeInsight.template.JavaStringContextType;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.ide.highlighter.JavaFileHighlighter;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JavaCodeContextType
extends TemplateContextType {
    protected JavaCodeContextType(@NotNull @NonNls String id, @NotNull String presentableName, @Nullable Class<? extends TemplateContextType> baseContextType) {
        super(id, presentableName, baseContextType);
    }

    public boolean isInContext(@NotNull PsiFile file2, int offset) {
        if (PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset).isKindOf((Language)JavaLanguage.INSTANCE)) {
            PsiElement element = file2.findElementAt(offset);
            if (element instanceof PsiWhiteSpace) {
                return false;
            }
            return element != null && this.isInContext(element);
        }
        return false;
    }

    protected abstract boolean isInContext(@NotNull PsiElement var1);

    @NotNull
    public SyntaxHighlighter createHighlighter() {
        return new JavaFileHighlighter();
    }

    public Document createDocument(CharSequence text, Project project2) {
        if (project2 == null) {
            return super.createDocument(text, project2);
        }
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        JavaCodeFragmentFactory factory = JavaCodeFragmentFactory.getInstance((Project)project2);
        JavaCodeFragment fragment = factory.createCodeBlockCodeFragment((String)text, (PsiElement)psiFacade.findPackage(""), true);
        DaemonCodeAnalyzer.getInstance((Project)project2).setHighlightingEnabled((PsiFile)fragment, false);
        return PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)fragment);
    }

    private static boolean isAfterExpression(PsiElement element) {
        PsiExpression prevExpr;
        ProcessingContext context = new ProcessingContext();
        return ((PsiElementPattern.Capture)((PsiElementPattern.Capture)PlatformPatterns.psiElement().withAncestor(1, (ElementPattern)StandardPatterns.instanceOf(PsiExpression.class))).afterLeaf((ElementPattern)PlatformPatterns.psiElement().withAncestor(1, (ElementPattern)PlatformPatterns.psiElement(PsiExpression.class).save("prevExpr")))).accepts((Object)element, context) && (prevExpr = (PsiExpression)context.get((Object)"prevExpr")).getTextRange().getEndOffset() <= element.getTextRange().getStartOffset();
    }

    public static class Declaration
    extends JavaCodeContextType {
        public Declaration() {
            super("JAVA_DECLARATION", "Declaration", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            if (Statement.isStatementContext(element) || Expression.isExpressionContext(element)) {
                return false;
            }
            return JavaKeywordCompletion.isSuitableForClass(element) || JavaKeywordCompletion.isInsideParameterList(element);
        }
    }

    public static class Expression
    extends JavaCodeContextType {
        public Expression() {
            super("JAVA_EXPRESSION", "Expression", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            return Expression.isExpressionContext(element);
        }

        private static boolean isExpressionContext(PsiElement element) {
            PsiElement parent = element.getParent();
            if (!(parent instanceof PsiJavaCodeReferenceElement)) {
                return false;
            }
            if (((PsiJavaCodeReferenceElement)parent).isQualified()) {
                return false;
            }
            if (parent.getParent() instanceof PsiMethodCallExpression || parent.getParent() instanceof PsiReferenceList) {
                return false;
            }
            if (((PsiElementPattern.Capture)PlatformPatterns.psiElement().withParents(new Class[]{PsiTypeElement.class, PsiMember.class})).accepts((Object)parent)) {
                return false;
            }
            if (JavaKeywordCompletion.isInsideParameterList(element)) {
                return false;
            }
            return !JavaCodeContextType.isAfterExpression(element);
        }
    }

    public static class Statement
    extends JavaCodeContextType {
        public Statement() {
            super("JAVA_STATEMENT", "Statement", Generic.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            return Statement.isStatementContext(element);
        }

        private static boolean isStatementContext(PsiElement element) {
            PsiElement body2;
            if (JavaCodeContextType.isAfterExpression(element) || JavaStringContextType.isStringLiteral(element)) {
                return false;
            }
            PsiElement statement2 = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiStatement.class, PsiLambdaExpression.class});
            if (statement2 instanceof PsiLambdaExpression && (body2 = ((PsiLambdaExpression)statement2).getBody()) != null && PsiTreeUtil.isAncestor((PsiElement)body2, (PsiElement)element, (boolean)false)) {
                statement2 = body2;
            }
            return statement2 != null && statement2.getTextRange().getStartOffset() == element.getTextRange().getStartOffset();
        }
    }

    public static class Generic
    extends JavaCodeContextType {
        public Generic() {
            super("JAVA_CODE", "Java", EverywhereContextType.class);
        }

        @Override
        protected boolean isInContext(@NotNull PsiElement element) {
            return true;
        }
    }
}

