/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet;

import com.intellij.codeInsight.template.emmet.CollectCustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.EmmetException;
import com.intellij.codeInsight.template.emmet.EmmetPreviewHint;
import com.intellij.codeInsight.template.emmet.ZenCodingTemplate;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Producer;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EmmetPreviewUtil {
    private EmmetPreviewUtil() {
    }

    @Nullable
    public static String calculateTemplateText(@NotNull Editor editor, @NotNull PsiFile file2, boolean expandPrimitiveAbbreviations) {
        if (file2 instanceof XmlFile) {
            String templatePrefix;
            PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(editor.getDocument());
            CollectCustomTemplateCallback callback = new CollectCustomTemplateCallback(editor, file2);
            PsiElement context = callback.getContext();
            ZenCodingGenerator generator = ZenCodingTemplate.findApplicableDefaultGenerator(context, false);
            if (generator != null && generator instanceof XmlZenCodingGenerator && (templatePrefix = new ZenCodingTemplate().computeTemplateKeyWithoutContextChecking(callback)) != null) {
                try {
                    String templateText;
                    ZenCodingTemplate.expand(templatePrefix, callback, generator, Collections.emptyList(), expandPrimitiveAbbreviations, 0);
                    TemplateImpl template = callback.getGeneratedTemplate();
                    String string = templateText = template != null ? template.getTemplateText() : null;
                    if (!StringUtil.isEmpty((String)templateText)) {
                        return template.isToReformat() ? EmmetPreviewUtil.reformatTemplateText(file2, templateText) : templateText;
                    }
                }
                catch (EmmetException e) {
                    return e.getMessage();
                }
            }
        }
        return null;
    }

    public static void addEmmetPreviewListeners(final @NotNull Editor editor, final @NotNull PsiFile file2, final boolean expandPrimitiveAbbreviations) {
        editor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(@NotNull DocumentEvent e) {
                EmmetPreviewHint existingHint = EmmetPreviewHint.getExistingHint(editor);
                if (existingHint != null) {
                    existingHint.updateText(new TemplateTextProducer(editor, file2, expandPrimitiveAbbreviations));
                } else {
                    e.getDocument().removeDocumentListener((DocumentListener)this);
                }
            }
        });
        editor.getCaretModel().addCaretListener((CaretListener)new CaretAdapter(){

            public void caretPositionChanged(@NotNull CaretEvent e) {
                EmmetPreviewHint existingHint = EmmetPreviewHint.getExistingHint(e.getEditor());
                if (existingHint != null) {
                    existingHint.updateText(new TemplateTextProducer(editor, file2, expandPrimitiveAbbreviations));
                } else {
                    e.getEditor().getCaretModel().removeCaretListener((CaretListener)this);
                }
            }
        });
    }

    private static String reformatTemplateText(@NotNull PsiFile file2, @NotNull String templateText) {
        PsiFile copy = PsiFileFactory.getInstance((Project)file2.getProject()).createFileFromText(file2.getName(), file2.getFileType(), (CharSequence)templateText);
        VirtualFile vFile = copy.getVirtualFile();
        if (vFile != null) {
            vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        }
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> CodeStyleManager.getInstance((Project)file2.getProject()).reformat((PsiElement)copy)));
        return copy.getText();
    }

    private static class TemplateTextProducer
    implements Producer<String> {
        @NotNull
        private final Editor myEditor;
        @NotNull
        private final PsiFile myFile;
        private final boolean myExpandPrimitiveAbbreviations;

        public TemplateTextProducer(@NotNull Editor editor, @NotNull PsiFile file2, boolean expandPrimitiveAbbreviations) {
            this.myEditor = editor;
            this.myFile = file2;
            this.myExpandPrimitiveAbbreviations = expandPrimitiveAbbreviations;
        }

        @Nullable
        public String produce() {
            return EmmetPreviewUtil.calculateTemplateText(this.myEditor, this.myFile, this.myExpandPrimitiveAbbreviations);
        }
    }
}

