/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.filters;

import com.intellij.codeInsight.template.XslTextContextType;
import com.intellij.codeInsight.template.emmet.filters.ZenCodingFilter;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGeneratorImpl;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class XslZenCodingFilter
extends ZenCodingFilter {
    private final XmlZenCodingGenerator myDelegate = new XmlZenCodingGeneratorImpl();
    @NonNls
    private static final String SELECT_ATTR_NAME = "select";

    @Override
    @NotNull
    public GenerationNode filterNode(@NotNull GenerationNode node) {
        XmlTag tag;
        XmlDocument document;
        TemplateToken token = node.getTemplateToken();
        if (token != null && (document = token.getFile().getDocument()) != null && (tag = document.getRootTag()) != null) {
            if (token.getAttributes().containsKey(SELECT_ATTR_NAME)) {
                return node;
            }
            ApplicationManager.getApplication().runWriteAction(() -> {
                XmlAttribute attribute;
                if (XslZenCodingFilter.isOurTag(tag, node.getChildren().size() > 0) && (attribute = tag.getAttribute(SELECT_ATTR_NAME)) != null) {
                    attribute.delete();
                }
            });
            return node;
        }
        return node;
    }

    private static boolean isOurTag(XmlTag tag, boolean hasChildren) {
        if (hasChildren) {
            String name = tag.getLocalName();
            return name.equals("with-param") || name.equals("variable");
        }
        return false;
    }

    @Override
    public boolean isMyContext(@NotNull PsiElement context) {
        return this.myDelegate.isMyContext(context, true) || this.myDelegate.isMyContext(context, false);
    }

    @Override
    @NotNull
    public String getSuffix() {
        return "xsl";
    }

    @Override
    public boolean isAppliedByDefault(@NotNull PsiElement context) {
        return XslTextContextType.isXslOrXsltFile(context.getContainingFile()) || super.isAppliedByDefault(context);
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return "XSL tuning";
    }
}

