/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.generators;

import com.intellij.application.options.emmet.EmmetOptions;
import com.intellij.codeInsight.template.HtmlTextContextType;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.generators.XmlZenCodingGenerator;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.XmlRecursiveElementVisitor;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlZenCodingGeneratorImpl
extends XmlZenCodingGenerator {
    public static final XmlZenCodingGeneratorImpl INSTANCE = new XmlZenCodingGeneratorImpl();

    private static boolean isTrueXml(FileType type2) {
        return type2 == StdFileTypes.XHTML || type2 == StdFileTypes.JSPX || type2 == StdFileTypes.XML;
    }

    @Override
    @NotNull
    public String toString(@NotNull XmlTag tag, @NotNull Map<String, String> attributes, boolean hasChildren, @NotNull PsiElement context) {
        FileType fileType = context.getContainingFile().getFileType();
        if (XmlZenCodingGeneratorImpl.isTrueXml(fileType)) {
            CommandProcessor.getInstance().runUndoTransparentAction(() -> XmlZenCodingGeneratorImpl.closeUnclosingTags(tag));
        }
        return tag.getContainingFile().getText();
    }

    @Override
    @NotNull
    public String buildAttributesString(@NotNull Map<String, String> attributes, boolean hasChildren, int numberInIteration, int totalIterations, @Nullable String surroundedText) {
        StringBuilder result2 = new StringBuilder();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            String name = entry.getKey();
            String value2 = ZenCodingUtil.getValue(entry.getValue(), numberInIteration, totalIterations, surroundedText);
            result2.append(XmlZenCodingGeneratorImpl.getAttributeString(name, value2));
            result2.append(' ');
        }
        return result2.toString().trim();
    }

    @Override
    public boolean isMyContext(@NotNull PsiElement context, boolean wrapping) {
        return this.isMyLanguage(context.getLanguage()) && (wrapping || HtmlTextContextType.isInContext(context));
    }

    protected boolean isMyLanguage(Language language) {
        return language instanceof XMLLanguage;
    }

    @Override
    public String getSuffix() {
        return "html";
    }

    @Override
    public boolean isEnabled() {
        return EmmetOptions.getInstance().isEmmetEnabled();
    }

    @Override
    public boolean isAppliedByDefault(@NotNull PsiElement context) {
        return true;
    }

    private static String getAttributeString(String name, String value2) {
        return name + "=\"" + value2 + '\"';
    }

    private static void closeUnclosingTags(@NotNull XmlTag root) {
        final ArrayList tagToClose = new ArrayList();
        Project project2 = root.getProject();
        final SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project2);
        root.accept((PsiElementVisitor)new XmlRecursiveElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                if (!XmlZenCodingGeneratorImpl.isTagClosed(tag)) {
                    tagToClose.add(pointerManager.createSmartPsiElementPointer((PsiElement)tag));
                }
            }
        });
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        for (SmartPsiElementPointer pointer : tagToClose) {
            Document document;
            ASTNode child;
            XmlTag tag = (XmlTag)pointer.getElement();
            if (tag == null || (child = XmlChildRole.START_TAG_END_FINDER.findChild(tag.getNode())) == null) continue;
            int offset = child.getTextRange().getStartOffset();
            VirtualFile file2 = tag.getContainingFile().getVirtualFile();
            if (file2 == null || (document = FileDocumentManager.getInstance().getDocument(file2)) == null) continue;
            documentManager.doPostponedOperationsAndUnblockDocument(document);
            ApplicationManager.getApplication().runWriteAction(() -> {
                document.replaceString(offset, tag.getTextRange().getEndOffset(), (CharSequence)"/>");
                documentManager.commitDocument(document);
            });
        }
    }

    private static boolean isTagClosed(@NotNull XmlTag tag) {
        ASTNode node = tag.getNode();
        assert (node != null);
        ASTNode emptyTagEnd = XmlChildRole.EMPTY_TAG_END_FINDER.findChild(node);
        ASTNode endTagEnd = XmlChildRole.CLOSING_TAG_START_FINDER.findChild(node);
        return emptyTagEnd != null || endTagEnd != null;
    }
}

