/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AddOperationNode
extends ZenCodingNode {
    private final ZenCodingNode myLeftOperand;
    private final ZenCodingNode myRightOperand;

    public AddOperationNode(@NotNull ZenCodingNode leftOperand2, @NotNull ZenCodingNode rightOperand2) {
        this.myLeftOperand = leftOperand2;
        this.myRightOperand = rightOperand2;
    }

    public ZenCodingNode getLeftOperand() {
        return this.myLeftOperand;
    }

    public ZenCodingNode getRightOperand() {
        return this.myRightOperand;
    }

    @Override
    @NotNull
    public List<ZenCodingNode> getChildren() {
        return ContainerUtil.newLinkedList((Object[])new ZenCodingNode[]{this.myLeftOperand, this.myRightOperand});
    }

    @Override
    @NotNull
    public List<GenerationNode> expand(int numberInIteration, int totalIterations, String surroundedText, CustomTemplateCallback callback, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        ArrayList<GenerationNode> result2 = new ArrayList<GenerationNode>();
        List<GenerationNode> leftNodes = this.myLeftOperand.expand(numberInIteration, totalIterations, surroundedText, callback, false, parent);
        result2.addAll(leftNodes);
        result2.addAll(this.myRightOperand.expand(numberInIteration, totalIterations, surroundedText, callback, insertSurroundedTextAtTheEnd, parent));
        return result2;
    }

    public String toString() {
        return "+";
    }

    @Override
    public int getApproximateOutputLength(CustomTemplateCallback callback) {
        return this.myLeftOperand.getApproximateOutputLength(callback) + this.myRightOperand.getApproximateOutputLength(callback);
    }
}

