/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.tokens;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.tokens.ZenCodingToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.LocalTimeCounter;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateToken
extends ZenCodingToken {
    public static final String ATTRS = "ATTRS";
    public static final TemplateToken EMPTY_TEMPLATE_TOKEN = new TemplateToken("", Collections.emptyMap());
    @NotNull
    private final String myKey;
    private TemplateImpl myTemplate;
    @NotNull
    private final Map<String, String> myAttributes;
    private XmlFile myFile;

    public TemplateToken(@NotNull String key2) {
        this(key2, Collections.emptyMap());
    }

    public TemplateToken(@NotNull String key2, @NotNull Map<String, String> attribute2value) {
        this.myKey = key2;
        this.myAttributes = attribute2value;
    }

    @NotNull
    public Map<String, String> getAttributes() {
        return this.myAttributes;
    }

    public XmlFile getFile() {
        return this.myFile;
    }

    public void setFile(XmlFile file2) {
        this.myFile = file2;
    }

    @NotNull
    public String getKey() {
        return this.myKey;
    }

    public boolean setTemplate(@NotNull TemplateImpl template, @NotNull CustomTemplateCallback callback) {
        this.myTemplate = template;
        XmlFile xmlFile = TemplateToken.parseXmlFileInTemplate(template, callback, this.getAttributes());
        this.setFile(xmlFile);
        XmlTag tag = xmlFile.getRootTag();
        return this.getAttributes().isEmpty() || tag != null;
    }

    private static boolean containsAttrsVar(@NotNull TemplateImpl template) {
        for (int i2 = 0; i2 < template.getVariableCount(); ++i2) {
            String varName = template.getVariableNameAt(i2);
            if (!ATTRS.equals(varName)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static XmlFile parseXmlFileInTemplate(@NotNull TemplateImpl template, @NotNull CustomTemplateCallback callback, @NotNull Map<String, String> attributes) {
        XmlFile xmlFile;
        VirtualFile vFile;
        XmlFile dummyFile;
        XmlTag dummyRootTag = null;
        String templateString = template.getString();
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)callback.getProject());
        if (!TemplateToken.containsAttrsVar(template) && (dummyRootTag = (dummyFile = (XmlFile)psiFileFactory.createFileFromText("dummy.html", (Language)HTMLLanguage.INSTANCE, (CharSequence)templateString, false, true)).getRootTag()) != null) {
            TemplateToken.addMissingAttributes(dummyRootTag, attributes);
        }
        if ((vFile = (xmlFile = (XmlFile)psiFileFactory.createFileFromText("dummy.xml", (FileType)StdFileTypes.XML, (CharSequence)(templateString = dummyRootTag != null ? dummyRootTag.getContainingFile().getText() : templateString), LocalTimeCounter.currentTime(), true)).getVirtualFile()) != null) {
            vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        }
        return xmlFile;
    }

    private static void addMissingAttributes(@NotNull XmlTag tag, @NotNull Map<String, String> attributes) {
        for (Map.Entry<String, String> attribute : attributes.entrySet()) {
            XmlTag htmlTag;
            XmlAttribute newAttribute;
            if ("%default".equals(attribute.getKey()) || tag.getAttribute(attribute.getKey()) != null || (newAttribute = (XmlAttribute)ArrayUtil.getFirstElement((Object[])(htmlTag = XmlElementFactory.getInstance((Project)tag.getProject()).createHTMLTagFromText("<dummy " + attribute.getKey() + "=\"\"/>")).getAttributes())) == null) continue;
            tag.add((PsiElement)newAttribute);
        }
    }

    @Nullable
    public TemplateImpl getTemplate() {
        return this.myTemplate;
    }

    @NotNull
    public String toString() {
        return "TEMPLATE";
    }
}

