/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateColors;
import com.intellij.codeInsight.template.impl.TemplateContext;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateTextLexer;
import com.intellij.codeInsight.template.impl.TemplateTokenType;
import com.intellij.ide.DataManager;
import com.intellij.lexer.Lexer;
import com.intellij.lexer.MergingLexerAdapter;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.LayerDescriptor;
import com.intellij.openapi.editor.ex.util.LayeredLexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.PlainSyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateEditorUtil {
    private TemplateEditorUtil() {
    }

    public static Editor createEditor(boolean isReadOnly, CharSequence text) {
        return TemplateEditorUtil.createEditor(isReadOnly, text, null);
    }

    public static Editor createEditor(boolean isReadOnly, CharSequence text, @Nullable TemplateContext context) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext());
        return TemplateEditorUtil.createEditor(isReadOnly, TemplateEditorUtil.createDocument(text, context, project2), project2);
    }

    private static Document createDocument(CharSequence text, @Nullable TemplateContext context, Project project2) {
        if (context != null) {
            for (TemplateContextType type2 : TemplateManagerImpl.getAllContextTypes()) {
                if (!context.isEnabled(type2)) continue;
                return type2.createDocument(text, project2);
            }
        }
        return EditorFactory.getInstance().createDocument(text);
    }

    private static Editor createEditor(boolean isReadOnly, Document document, Project project2) {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Editor editor = isReadOnly ? editorFactory.createViewer(document, project2) : editorFactory.createEditor(document, project2);
        editor.getContentComponent().setFocusable(!isReadOnly);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setCaretRowShown(false);
        EditorColorsScheme scheme2 = editor.getColorsScheme();
        VirtualFile file2 = FileDocumentManager.getInstance().getFile(document);
        if (file2 != null) {
            EditorHighlighter highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(file2, scheme2, project2);
            ((EditorEx)editor).setHighlighter(highlighter);
        }
        return editor;
    }

    public static void setHighlighter(Editor editor, @Nullable TemplateContext templateContext) {
        SyntaxHighlighter highlighter = null;
        if (templateContext != null) {
            TemplateContextType type2;
            TemplateContextType[] templateContextTypeArray = TemplateManagerImpl.getAllContextTypes();
            int n = templateContextTypeArray.length;
            for (int j = 0; !(j >= n || templateContext.isEnabled(type2 = templateContextTypeArray[j]) && (highlighter = type2.createHighlighter()) != null); ++j) {
            }
        }
        TemplateEditorUtil.setHighlighter((EditorEx)editor, highlighter);
    }

    public static void setHighlighter(@NotNull Editor editor, @Nullable TemplateContextType templateContextType) {
        TemplateEditorUtil.setHighlighter((EditorEx)editor, templateContextType != null ? templateContextType.createHighlighter() : null);
    }

    private static void setHighlighter(EditorEx editor, @Nullable SyntaxHighlighter highlighter) {
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        LayeredLexerEditorHighlighter layeredHighlighter = new LayeredLexerEditorHighlighter((SyntaxHighlighter)new TemplateHighlighter(), editorColorsScheme);
        layeredHighlighter.registerLayer(TemplateTokenType.TEXT, new LayerDescriptor((SyntaxHighlighter)ObjectUtils.notNull((Object)highlighter, (Object)new PlainSyntaxHighlighter()), ""));
        editor.setHighlighter(layeredHighlighter);
    }

    private static class TemplateHighlighter
    extends SyntaxHighlighterBase {
        private final Lexer myLexer = new MergingLexerAdapter((Lexer)new TemplateTextLexer(), TokenSet.create((IElementType[])new IElementType[]{TemplateTokenType.TEXT}));

        @NotNull
        public Lexer getHighlightingLexer() {
            return this.myLexer;
        }

        @NotNull
        public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
            return tokenType == TemplateTokenType.VARIABLE ? TemplateHighlighter.pack((TextAttributesKey)TemplateColors.TEMPLATE_VARIABLE_ATTRIBUTES) : EMPTY;
        }
    }
}

