/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiElementResult;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;

public class ComponentTypeOfMacro
extends Macro {
    public String getName() {
        return "componentTypeOf";
    }

    public String getPresentableName() {
        return CodeInsightBundle.message((String)"macro.component.type.of.array", (Object[])new Object[0]);
    }

    public LookupElement[] calculateLookupItems(@NotNull Expression[] params, ExpressionContext context) {
        if (params.length != 1) {
            return null;
        }
        LookupElement[] lookupItems = params[0].calculateLookupItems(context);
        if (lookupItems == null) {
            return null;
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        for (LookupElement element : lookupItems) {
            PsiType psiType;
            PsiTypeLookupItem lookupItem = (PsiTypeLookupItem)element.as(PsiTypeLookupItem.CLASS_CONDITION_KEY);
            if (lookupItem == null || !((psiType = lookupItem.getType()) instanceof PsiArrayType)) continue;
            result2.add(PsiTypeLookupItem.createLookupItem(((PsiArrayType)psiType).getComponentType(), null));
        }
        return lookupItems;
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        PsiType type2;
        PsiType type3;
        if (params.length != 1) {
            return null;
        }
        Result result2 = params[0].calculateResult(context);
        if (result2 == null) {
            return null;
        }
        if (result2 instanceof PsiTypeResult && (type3 = ((PsiTypeResult)result2).getType()) instanceof PsiArrayType) {
            return new PsiTypeResult(((PsiArrayType)type3).getComponentType(), context.getProject());
        }
        PsiExpression expr = MacroUtil.resultToPsiExpression(result2, context);
        PsiType psiType = type2 = expr == null ? MacroUtil.resultToPsiType(result2, context) : expr.getType();
        if (type2 instanceof PsiArrayType) {
            return new PsiTypeResult(((PsiArrayType)type2).getComponentType(), context.getProject());
        }
        LookupElement[] elements = params[0].calculateLookupItems(context);
        if (elements != null) {
            for (LookupElement element : elements) {
                PsiType psiType2;
                PsiTypeLookupItem typeLookupItem = (PsiTypeLookupItem)element.as(PsiTypeLookupItem.CLASS_CONDITION_KEY);
                if (typeLookupItem == null || !((psiType2 = typeLookupItem.getType()) instanceof PsiArrayType)) continue;
                return new PsiTypeResult(((PsiArrayType)psiType2).getComponentType(), context.getProject());
            }
        }
        return new PsiElementResult(null);
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

