/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import org.jetbrains.annotations.NotNull;

public class MethodReturnTypeMacro
extends Macro {
    public String getName() {
        return "methodReturnType";
    }

    public String getPresentableName() {
        return "methodReturnType()";
    }

    @NotNull
    public String getDefaultValue() {
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        for (PsiElement place = context.getPsiElementAtStartOffset(); place != null; place = place.getParent()) {
            if (!(place instanceof PsiMethod)) continue;
            return new PsiTypeResult(((PsiMethod)place).getReturnType(), place.getProject());
        }
        return null;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

