/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.PsiTypeResult;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.util.RefactoringUtil;
import org.jetbrains.annotations.NotNull;

public class RightSideTypeMacro
extends Macro {
    public String getName() {
        return "rightSideType";
    }

    public String getPresentableName() {
        return CodeInsightBundle.message((String)"macro.right.side.type", (Object[])new Object[0]);
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        int offset = context.getStartOffset();
        Project project2 = context.getProject();
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(context.getEditor().getDocument());
        PsiElement element = file2.findElementAt(offset);
        if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{PsiAssignmentExpression.class, PsiVariable.class})) instanceof PsiAssignmentExpression) {
            PsiAssignmentExpression assignment = (PsiAssignmentExpression)element;
            PsiExpression rhs = assignment.getRExpression();
            if (rhs == null) {
                return null;
            }
            PsiType rhsType = rhs.getType();
            if (rhsType == null) {
                return null;
            }
            return new PsiTypeResult(rhsType, project2);
        }
        if (element instanceof PsiVariable) {
            PsiVariable var = (PsiVariable)element;
            PsiExpression initializer = var.getInitializer();
            if (initializer == null) {
                return null;
            }
            PsiType type2 = RefactoringUtil.getTypeByExpression(initializer);
            if (type2 == null) {
                return null;
            }
            return new PsiTypeResult(type2, project2);
        }
        return null;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

