/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.settings;

import com.intellij.application.options.editor.EditorOptionsProvider;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.postfix.settings.PostfixDescriptionPanel;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateMetaData;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesCheckboxTree;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.lang.LanguageExtensionPoint;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixTemplatesConfigurable
implements SearchableConfigurable,
EditorOptionsProvider,
Configurable.NoScroll {
    public static final Comparator<PostfixTemplate> TEMPLATE_COMPARATOR = (o1, o2) -> o1.getKey().compareTo(o2.getKey());
    @Nullable
    private PostfixTemplatesCheckboxTree myCheckboxTree;
    @NotNull
    private final PostfixTemplatesSettings myTemplatesSettings;
    @Nullable
    private PostfixDescriptionPanel myInnerPostfixDescriptionPanel;
    private MultiMap<String, PostfixTemplate> templateMultiMap;
    private JComponent myPanel;
    private JBCheckBox myCompletionEnabledCheckbox;
    private JBCheckBox myPostfixTemplatesEnabled;
    private JPanel myTemplatesTreeContainer;
    private ComboBox myShortcutComboBox;
    private JPanel myDescriptionPanel;
    private static final String SPACE = CodeInsightBundle.message((String)"template.shortcut.space", (Object[])new Object[0]);
    private static final String TAB = CodeInsightBundle.message((String)"template.shortcut.tab", (Object[])new Object[0]);
    private static final String ENTER = CodeInsightBundle.message((String)"template.shortcut.enter", (Object[])new Object[0]);

    public PostfixTemplatesConfigurable() {
        this.$$$setupUI$$$();
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        if (settings == null) {
            throw new RuntimeException("Can't retrieve postfix template settings");
        }
        this.myTemplatesSettings = settings;
        LanguageExtensionPoint[] extensions = (LanguageExtensionPoint[])new ExtensionPointName("com.intellij.codeInsight.template.postfixTemplateProvider").getExtensions();
        this.templateMultiMap = MultiMap.create();
        for (LanguageExtensionPoint extension : extensions) {
            ArrayList postfixTemplates = ContainerUtil.newArrayList(((PostfixTemplateProvider)extension.getInstance()).getTemplates());
            if (postfixTemplates.isEmpty()) continue;
            ContainerUtil.sort((List)postfixTemplates, TEMPLATE_COMPARATOR);
            this.templateMultiMap.putValues((Object)extension.getKey(), (Collection)postfixTemplates);
        }
        this.myPostfixTemplatesEnabled.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PostfixTemplatesConfigurable.this.updateComponents();
            }
        });
        this.myShortcutComboBox.addItem((Object)TAB);
        this.myShortcutComboBox.addItem((Object)SPACE);
        this.myShortcutComboBox.addItem((Object)ENTER);
        this.myDescriptionPanel.setLayout(new BorderLayout());
    }

    private void createTree() {
        this.myCheckboxTree = new PostfixTemplatesCheckboxTree(){

            @Override
            protected void selectionChanged() {
                PostfixTemplatesConfigurable.this.resetDescriptionPanel();
            }
        };
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add(ScrollPaneFactory.createScrollPane((Component)((Object)this.myCheckboxTree)));
        this.myTemplatesTreeContainer.setLayout(new BorderLayout());
        this.myTemplatesTreeContainer.add(panel2);
    }

    private void resetDescriptionPanel() {
        if (null != this.myCheckboxTree && null != this.myInnerPostfixDescriptionPanel) {
            this.myInnerPostfixDescriptionPanel.reset(PostfixTemplateMetaData.createMetaData(this.myCheckboxTree.getTemplate()));
        }
    }

    @NotNull
    public String getId() {
        return "reference.settingsdialog.IDE.editor.postfix.templates";
    }

    @Nullable
    public String getHelpTopic() {
        return this.getId();
    }

    @Nls
    public String getDisplayName() {
        return "Postfix Completion";
    }

    @Nullable
    public PostfixTemplatesCheckboxTree getTemplatesTree() {
        return this.myCheckboxTree;
    }

    @NotNull
    public JComponent createComponent() {
        GuiUtils.replaceJSplitPaneWithIDEASplitter((JComponent)this.myPanel);
        if (null == this.myInnerPostfixDescriptionPanel) {
            this.myInnerPostfixDescriptionPanel = new PostfixDescriptionPanel();
            this.myDescriptionPanel.add(this.myInnerPostfixDescriptionPanel.getComponent());
        }
        if (null == this.myCheckboxTree) {
            this.createTree();
            this.myCheckboxTree.initTree(this.templateMultiMap);
        }
        return this.myPanel;
    }

    public void apply() throws ConfigurationException {
        if (this.myCheckboxTree != null) {
            this.myTemplatesSettings.setLangDisabledTemplates(this.myCheckboxTree.getState());
            this.myTemplatesSettings.setPostfixTemplatesEnabled(this.myPostfixTemplatesEnabled.isSelected());
            this.myTemplatesSettings.setTemplatesCompletionEnabled(this.myCompletionEnabledCheckbox.isSelected());
            this.myTemplatesSettings.setShortcut(PostfixTemplatesConfigurable.stringToShortcut((String)this.myShortcutComboBox.getSelectedItem()));
        }
    }

    public void reset() {
        if (this.myCheckboxTree != null) {
            this.myCheckboxTree.setState(this.myTemplatesSettings.getLangDisabledTemplates());
            this.myPostfixTemplatesEnabled.setSelected(this.myTemplatesSettings.isPostfixTemplatesEnabled());
            this.myCompletionEnabledCheckbox.setSelected(this.myTemplatesSettings.isTemplatesCompletionEnabled());
            this.myShortcutComboBox.setSelectedItem((Object)PostfixTemplatesConfigurable.shortcutToString((char)this.myTemplatesSettings.getShortcut()));
            this.resetDescriptionPanel();
            this.updateComponents();
        }
    }

    public boolean isModified() {
        if (this.myCheckboxTree == null) {
            return false;
        }
        return this.myPostfixTemplatesEnabled.isSelected() != this.myTemplatesSettings.isPostfixTemplatesEnabled() || this.myCompletionEnabledCheckbox.isSelected() != this.myTemplatesSettings.isTemplatesCompletionEnabled() || PostfixTemplatesConfigurable.stringToShortcut((String)this.myShortcutComboBox.getSelectedItem()) != this.myTemplatesSettings.getShortcut() || !this.myCheckboxTree.getState().equals(this.myTemplatesSettings.getLangDisabledTemplates());
    }

    public void disposeUIResources() {
        if (this.myInnerPostfixDescriptionPanel != null) {
            Disposer.dispose((Disposable)this.myInnerPostfixDescriptionPanel);
        }
        this.myCheckboxTree = null;
    }

    private void updateComponents() {
        boolean pluginEnabled = this.myPostfixTemplatesEnabled.isSelected();
        this.myCompletionEnabledCheckbox.setVisible(!LiveTemplateCompletionContributor.shouldShowAllTemplates());
        this.myCompletionEnabledCheckbox.setEnabled(pluginEnabled);
        this.myShortcutComboBox.setEnabled(pluginEnabled);
        if (this.myCheckboxTree != null) {
            this.myCheckboxTree.setEnabled(pluginEnabled);
        }
    }

    private static char stringToShortcut(@NotNull String string) {
        if (SPACE.equals(string)) {
            return ' ';
        }
        if (ENTER.equals(string)) {
            return '\n';
        }
        return '\t';
    }

    private static String shortcutToString(char shortcut) {
        if (shortcut == ' ') {
            return SPACE;
        }
        if (shortcut == '\n') {
            return ENTER;
        }
        return TAB;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JPanel jPanel2;
        ComboBox comboBox;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JPanel jPanel3 = new JPanel();
        this.myPanel = jPanel3;
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myPostfixTemplatesEnabled = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Enable postfix completion");
        jBCheckBox2.setMnemonic('E');
        jBCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBCheckBox2, new GridConstraints(0, 0, 1, 2, 1, 1, 3, 1, null, null, null));
        this.myCompletionEnabledCheckbox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Show postfix templates in completion autopopup");
        jBCheckBox.setMnemonic('S');
        jBCheckBox.setDisplayedMnemonicIndex(0);
        jPanel3.add((Component)jBCheckBox, new GridConstraints(1, 0, 1, 2, 0, 1, 3, 1, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Expand templates with");
        jPanel3.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 1, null, null, null, 1));
        this.myShortcutComboBox = comboBox = new ComboBox();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        comboBox.setModel(defaultComboBoxModel);
        jPanel3.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 1, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JSplitPane jSplitPane = new JSplitPane();
        jPanel4.add((Component)jSplitPane, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(200, 200), null));
        this.myTemplatesTreeContainer = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setLeftComponent(jPanel2);
        this.myDescriptionPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jSplitPane.setRightComponent(jPanel);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

