/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.SuggestVariableNameMacro;
import com.intellij.codeInsight.template.postfix.templates.StringBasedPostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ForIndexedPostfixTemplate
extends StringBasedPostfixTemplate {
    public static final Condition<PsiElement> IS_NUMBER_OR_ARRAY_OR_ITERABLE = element -> JavaPostfixTemplatesUtils.IS_ITERABLE_OR_ARRAY.value(element) || JavaPostfixTemplatesUtils.IS_NUMBER.value(element);

    protected ForIndexedPostfixTemplate(@NotNull String key2, @NotNull String example) {
        super(key2, example, JavaPostfixTemplatesUtils.selectorTopmost(IS_NUMBER_OR_ARRAY_OR_ITERABLE));
    }

    @Override
    public void setVariables(@NotNull Template template, @NotNull PsiElement element) {
        MacroCallNode index = new MacroCallNode(new SuggestVariableNameMacro());
        template.addVariable("index", index, index, true);
    }

    @Override
    public final String getTemplateString(@NotNull PsiElement element) {
        PsiExpression expr = (PsiExpression)element;
        String bound = ForIndexedPostfixTemplate.getExpressionBound(expr);
        if (bound == null) {
            return null;
        }
        return this.getStringTemplate(expr).replace("$bound$", bound).replace("$type$", ForIndexedPostfixTemplate.suggestIndexType(expr));
    }

    @NotNull
    protected abstract String getStringTemplate(@NotNull PsiExpression var1);

    @Nullable
    private static String getExpressionBound(@NotNull PsiExpression expr) {
        PsiType type2 = expr.getType();
        if (JavaPostfixTemplatesUtils.isNumber(type2)) {
            return expr.getText();
        }
        if (JavaPostfixTemplatesUtils.isArray(type2)) {
            return expr.getText() + ".length";
        }
        if (JavaPostfixTemplatesUtils.isIterable(type2)) {
            return expr.getText() + ".size()";
        }
        return null;
    }

    @NotNull
    private static String suggestIndexType(@NotNull PsiExpression expr) {
        PsiType type2 = expr.getType();
        if (JavaPostfixTemplatesUtils.isNumber(type2)) {
            return type2.getCanonicalText();
        }
        return "int";
    }

    @Override
    protected boolean shouldAddExpressionToContext() {
        return false;
    }
}

