/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.StringBasedPostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FormatPostfixTemplate
extends StringBasedPostfixTemplate {
    private static final Condition<PsiElement> IS_STRING = expr -> {
        if (!(expr instanceof PsiExpression)) {
            return false;
        }
        PsiType type2 = ((PsiExpression)expr).getType();
        return type2 != null && "java.lang.String".equals(type2.getCanonicalText());
    };

    public FormatPostfixTemplate() {
        super("format", "String.format(expr)", JavaPostfixTemplatesUtils.selectorAllExpressionsWithCurrentOffset(IS_STRING));
    }

    @Override
    @Nullable
    public String getTemplateString(@NotNull PsiElement element) {
        return "String.format($expr$, $END$)";
    }

    @Override
    protected PsiElement getElementToRemove(PsiElement expr) {
        return expr;
    }
}

