/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.ide.plugins.cl.PluginClassLoader;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LanguagePostfixTemplate
extends LanguageExtension<PostfixTemplateProvider> {
    private static final Logger LOG = Logger.getInstance(LanguagePostfixTemplate.class);
    public static final LanguagePostfixTemplate LANG_EP = new LanguagePostfixTemplate();
    public static final String EP_NAME = "com.intellij.codeInsight.template.postfixTemplateProvider";

    private LanguagePostfixTemplate() {
        super(EP_NAME);
    }

    @NotNull
    protected List<PostfixTemplateProvider> buildExtensions(@NotNull String stringKey, @NotNull Language key2) {
        List providers = super.buildExtensions(stringKey, (Object)key2);
        LanguagePostfixTemplate.validateTemplatesForLanguage(key2, providers);
        return providers;
    }

    private static void validateTemplatesForLanguage(Language key2, List<PostfixTemplateProvider> providers) {
        HashMap templateKeys = ContainerUtil.newHashMap();
        for (PostfixTemplateProvider provider2 : providers) {
            for (PostfixTemplate template : provider2.getTemplates()) {
                PostfixTemplateProvider oldProvider = templateKeys.put(template.getKey(), provider2);
                if (oldProvider == null) continue;
                String oldPlugin = LanguagePostfixTemplate.getPluginId(oldProvider);
                String newPlugin = LanguagePostfixTemplate.getPluginId(provider2);
                LOG.error("Duplicated postfix completion key '" + template.getKey() + "' for language " + key2.getID() + ". Possible you need to disable one of the plugins: " + oldPlugin + ", " + newPlugin);
            }
        }
    }

    @NotNull
    private static String getPluginId(@NotNull PostfixTemplateProvider provider2) {
        ClassLoader loader = provider2.getClass().getClassLoader();
        if (loader instanceof PluginClassLoader) {
            return ((PluginClassLoader)((Object)loader)).getPluginId().getIdString();
        }
        return "";
    }
}

