/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.StringBasedPostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.JavaPostfixTemplatesUtils;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OptionalPostfixTemplate
extends StringBasedPostfixTemplate {
    public OptionalPostfixTemplate() {
        super("opt", "Optional.ofNullable(expr)", JavaPostfixTemplatesUtils.atLeastJava8Selector(JavaPostfixTemplatesUtils.selectorTopmost(JavaPostfixTemplatesUtils.IS_NON_VOID)));
    }

    @Override
    @Nullable
    public String getTemplateString(@NotNull PsiElement element) {
        PsiType type2;
        String className = "Optional";
        String methodName = "ofNullable";
        if (element instanceof PsiExpression && (type2 = ((PsiExpression)element).getType()) instanceof PsiPrimitiveType) {
            if (PsiType.INT.equals((Object)type2)) {
                className = "OptionalInt";
            } else if (PsiType.DOUBLE.equals((Object)type2)) {
                className = "OptionalDouble";
            } else if (PsiType.LONG.equals((Object)type2)) {
                className = "OptionalLong";
            }
            methodName = "of";
        }
        return "java.util." + className + "." + methodName + "($expr$)";
    }
}

