/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.google.common.collect.Sets;
import com.intellij.codeInsight.template.CustomLiveTemplateBase;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.CustomLiveTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.LanguagePostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.diagnostic.AttachmentFactory;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.UndoConstants;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.templateLanguages.TemplateLanguageUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PostfixLiveTemplate
extends CustomLiveTemplateBase {
    public static final String POSTFIX_TEMPLATE_ID = "POSTFIX_TEMPLATE_ID";
    private static final Logger LOG = Logger.getInstance(PostfixLiveTemplate.class);

    @NotNull
    public Set<String> getAllTemplateKeys(PsiFile file2, int offset) {
        HashSet keys = Sets.newHashSet();
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset);
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(language)) {
            keys.addAll(PostfixLiveTemplate.getKeys(provider2));
        }
        return keys;
    }

    @Nullable
    private static String computeTemplateKeyWithoutContextChecking(@NotNull PostfixTemplateProvider provider2, @NotNull CharSequence documentContent, int currentOffset) {
        int startOffset;
        if (documentContent.length() < startOffset) {
            return null;
        }
        for (startOffset = currentOffset; startOffset > 0; --startOffset) {
            char currentChar = documentContent.charAt(startOffset - 1);
            if (Character.isJavaIdentifierPart(currentChar)) continue;
            if (!provider2.isTerminalSymbol(currentChar)) {
                return null;
            }
            --startOffset;
            break;
        }
        return String.valueOf(documentContent.subSequence(startOffset, currentOffset));
    }

    @Override
    @Nullable
    public String computeTemplateKey(@NotNull CustomTemplateCallback callback) {
        Editor editor = callback.getEditor();
        CharSequence charsSequence = editor.getDocument().getCharsSequence();
        int offset = editor.getCaretModel().getOffset();
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback))) {
            String key2 = PostfixLiveTemplate.computeTemplateKeyWithoutContextChecking(provider2, charsSequence, offset);
            if (key2 == null || !PostfixLiveTemplate.isApplicableTemplate(provider2, key2, callback.getFile(), editor)) continue;
            return key2;
        }
        return null;
    }

    @Override
    @Nullable
    public String computeTemplateKeyWithoutContextChecking(@NotNull CustomTemplateCallback callback) {
        Editor editor = callback.getEditor();
        int currentOffset = editor.getCaretModel().getOffset();
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback))) {
            String key2 = PostfixLiveTemplate.computeTemplateKeyWithoutContextChecking(provider2, editor.getDocument().getCharsSequence(), currentOffset);
            if (key2 == null) continue;
            return key2;
        }
        return null;
    }

    @Override
    public boolean supportsMultiCaret() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void expand(@NotNull String key2, @NotNull CustomTemplateCallback callback) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("editing.completion.postfix");
        Editor editor = callback.getEditor();
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback))) {
            PostfixTemplate postfixTemplate = PostfixLiveTemplate.getTemplate(provider2, key2);
            if (postfixTemplate == null) continue;
            PsiFile file2 = callback.getContext().getContainingFile();
            if (PostfixLiveTemplate.isApplicableTemplate(provider2, key2, file2, editor)) {
                int offset = PostfixLiveTemplate.deleteTemplateKey(file2, editor, key2);
                try {
                    provider2.preExpand(file2, editor);
                    PsiElement context = CustomTemplateCallback.getContext(file2, PostfixLiveTemplate.positiveOffset(offset));
                    PostfixLiveTemplate.expandTemplate(postfixTemplate, editor, context);
                }
                finally {
                    provider2.afterExpand(file2, editor);
                }
            } else if (editor.getCaretModel().getAllCarets().size() == 1) {
                LOG.error("Template not found by key: " + key2 + "; offset = " + callback.getOffset(), new Attachment[]{AttachmentFactory.createAttachment(callback.getFile().getVirtualFile())});
            }
            return;
        }
        if (editor.getCaretModel().getAllCarets().size() == 1) {
            LOG.error("Template not found by key: " + key2 + "; offset = " + callback.getOffset(), new Attachment[]{AttachmentFactory.createAttachment(callback.getFile().getVirtualFile())});
        }
    }

    @Override
    public boolean isApplicable(PsiFile file2, int offset, boolean wrapping) {
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        if (wrapping || file2 == null || settings == null || !settings.isPostfixTemplatesEnabled()) {
            return false;
        }
        Language language = PsiUtilCore.getLanguageAtOffset((PsiFile)file2, (int)offset);
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(language)) {
            if (!StringUtil.isNotEmpty((String)PostfixLiveTemplate.computeTemplateKeyWithoutContextChecking(provider2, file2.getText(), offset + 1))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsWrapping() {
        return false;
    }

    @Override
    public void wrap(@NotNull String selection, @NotNull CustomTemplateCallback callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public String getTitle() {
        return "Postfix";
    }

    @Override
    public char getShortcut() {
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        return settings != null ? (char)settings.getShortcut() : (char)'\t';
    }

    @Override
    public boolean hasCompletionItem(@NotNull PsiFile file2, int offset) {
        return true;
    }

    @Override
    @NotNull
    public Collection<? extends CustomLiveTemplateLookupElement> getLookupElements(@NotNull PsiFile file2, @NotNull Editor editor, int offset) {
        HashSet result2 = ContainerUtil.newHashSet();
        CustomTemplateCallback callback = new CustomTemplateCallback(editor, file2);
        for (PostfixTemplateProvider provider2 : LanguagePostfixTemplate.LANG_EP.allForLanguage(PostfixLiveTemplate.getLanguage(callback))) {
            String key2 = this.computeTemplateKeyWithoutContextChecking(callback);
            if (key2 == null || editor.getCaretModel().getCaretCount() != 1) continue;
            Condition<PostfixTemplate> isApplicationTemplateFunction = PostfixLiveTemplate.createIsApplicationTemplateFunction(provider2, key2, file2, editor);
            for (PostfixTemplate postfixTemplate : provider2.getTemplates()) {
                if (!isApplicationTemplateFunction.value((Object)postfixTemplate)) continue;
                result2.add(new PostfixTemplateLookupElement(this, postfixTemplate, postfixTemplate.getKey(), provider2, false));
            }
        }
        return result2;
    }

    private static void expandTemplate(@NotNull PostfixTemplate template, @NotNull Editor editor, @NotNull PsiElement context) {
        if (template.startInWriteAction()) {
            ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(context.getProject(), () -> template.expand(context, editor), "Expand postfix template", (Object)POSTFIX_TEMPLATE_ID));
        } else {
            template.expand(context, editor);
        }
    }

    private static int deleteTemplateKey(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull String key2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        int currentOffset = editor.getCaretModel().getOffset();
        int newOffset = currentOffset - key2.length();
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().runUndoTransparentAction(() -> {
            Document document = editor.getDocument();
            document.deleteString(newOffset, currentOffset);
            editor.getCaretModel().moveToOffset(newOffset);
            PsiDocumentManager.getInstance((Project)file2.getProject()).commitDocument(document);
        }));
        return newOffset;
    }

    private static Condition<PostfixTemplate> createIsApplicationTemplateFunction(@NotNull PostfixTemplateProvider provider2, @NotNull String key2, @NotNull PsiFile file2, @NotNull Editor editor) {
        int currentOffset = editor.getCaretModel().getOffset();
        int newOffset = currentOffset - key2.length();
        CharSequence fileContent = editor.getDocument().getCharsSequence();
        StringBuilder fileContentWithoutKey = new StringBuilder();
        fileContentWithoutKey.append(fileContent.subSequence(0, newOffset));
        fileContentWithoutKey.append(fileContent.subSequence(currentOffset, fileContent.length()));
        PsiFile copyFile = PostfixLiveTemplate.copyFile(file2, fileContentWithoutKey);
        Document copyDocument = copyFile.getViewProvider().getDocument();
        if (copyDocument == null) {
            return Conditions.alwaysFalse();
        }
        copyDocument = (copyFile = provider2.preCheck(copyFile, editor, newOffset)).getViewProvider().getDocument();
        if (copyDocument == null) {
            return Conditions.alwaysFalse();
        }
        PsiElement context = CustomTemplateCallback.getContext(copyFile, PostfixLiveTemplate.positiveOffset(newOffset));
        Document finalCopyDocument = copyDocument;
        return template -> template != null && template.isEnabled(provider2) && template.isApplicable(context, finalCopyDocument, newOffset);
    }

    @NotNull
    public static PsiFile copyFile(@NotNull PsiFile file2, @NotNull StringBuilder fileContentWithoutKey) {
        VirtualFile vFile;
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)file2.getProject());
        PsiFile copy = psiFileFactory.createFileFromText(file2.getName(), file2.getFileType(), (CharSequence)fileContentWithoutKey);
        if (copy instanceof PsiFileImpl) {
            ((PsiFileImpl)copy).setOriginalFile(TemplateLanguageUtil.getBaseFile((PsiFile)file2));
        }
        if ((vFile = copy.getVirtualFile()) != null) {
            vFile.putUserData(UndoConstants.DONT_RECORD_UNDO, (Object)Boolean.TRUE);
        }
        return copy;
    }

    public static boolean isApplicableTemplate(@NotNull PostfixTemplateProvider provider2, @NotNull String key2, @NotNull PsiFile file2, @NotNull Editor editor) {
        return PostfixLiveTemplate.createIsApplicationTemplateFunction(provider2, key2, file2, editor).value((Object)PostfixLiveTemplate.getTemplate(provider2, key2));
    }

    @NotNull
    private static Set<String> getKeys(@NotNull PostfixTemplateProvider provider2) {
        HashSet result2 = ContainerUtil.newHashSet();
        for (PostfixTemplate template : provider2.getTemplates()) {
            result2.add(template.getKey());
        }
        return result2;
    }

    @Nullable
    private static PostfixTemplate getTemplate(@NotNull PostfixTemplateProvider provider2, @Nullable String key2) {
        for (PostfixTemplate template : provider2.getTemplates()) {
            if (!template.getKey().equals(key2)) continue;
            return template;
        }
        return null;
    }

    private static Language getLanguage(@NotNull CustomTemplateCallback callback) {
        return callback.getContext().getLanguage();
    }

    private static int positiveOffset(int offset) {
        return offset > 0 ? offset - 1 : offset;
    }
}

