/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.settings.PostfixTemplateMetaData;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class PostfixTemplate {
    @NotNull
    private final String myPresentableName;
    @NotNull
    private final String myKey;
    @NotNull
    private final String myDescription;
    @NotNull
    private final String myExample;

    protected PostfixTemplate(@NotNull String name, @NotNull String example) {
        this(name, "." + name, example);
    }

    protected PostfixTemplate(@NotNull String name, @NotNull String key2, @NotNull String example) {
        String tempDescription;
        this.myPresentableName = name;
        this.myKey = key2;
        this.myExample = example;
        try {
            tempDescription = new PostfixTemplateMetaData(this).getDescription().getText();
        }
        catch (IOException e) {
            tempDescription = "Under construction";
        }
        this.myDescription = tempDescription;
    }

    @NotNull
    public final String getKey() {
        return this.myKey;
    }

    @NotNull
    public String getPresentableName() {
        return this.myPresentableName;
    }

    @NotNull
    public String getDescription() {
        return this.myDescription;
    }

    @NotNull
    public String getExample() {
        return this.myExample;
    }

    public boolean startInWriteAction() {
        return true;
    }

    public boolean isEnabled(PostfixTemplateProvider provider2) {
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        return settings != null && settings.isPostfixTemplatesEnabled() && settings.isTemplateEnabled(this, provider2);
    }

    public abstract boolean isApplicable(@NotNull PsiElement var1, @NotNull Document var2, int var3);

    public abstract void expand(@NotNull PsiElement var1, @NotNull Editor var2);
}

