/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateExpressionSelector;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplatesUtils;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Pass;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.IntroduceTargetChooser;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class PostfixTemplateWithExpressionSelector
extends PostfixTemplate {
    @NotNull
    private final PostfixTemplateExpressionSelector mySelector;

    protected PostfixTemplateWithExpressionSelector(@NotNull String name, @NotNull String key2, @NotNull String example, @NotNull PostfixTemplateExpressionSelector selector2) {
        super(name, key2, example);
        this.mySelector = selector2;
    }

    protected PostfixTemplateWithExpressionSelector(@NotNull String name, @NotNull String example, @NotNull PostfixTemplateExpressionSelector selector2) {
        super(name, example);
        this.mySelector = selector2;
    }

    @Override
    public final boolean isApplicable(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        return this.mySelector.hasExpression(context, copyDocument, newOffset);
    }

    @Override
    public final void expand(@NotNull PsiElement context, final @NotNull Editor editor) {
        List<PsiElement> expressions2 = this.mySelector.getExpressions(context, editor.getDocument(), editor.getCaretModel().getOffset());
        if (expressions2.isEmpty()) {
            PostfixTemplatesUtils.showErrorHint(context.getProject(), editor);
            return;
        }
        if (expressions2.size() == 1) {
            this.prepareAndExpandForChooseExpression(expressions2.get(0), editor);
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            PsiElement item = (PsiElement)ContainerUtil.getLastItem(expressions2);
            assert (item != null);
            this.prepareAndExpandForChooseExpression(item, editor);
            return;
        }
        IntroduceTargetChooser.showChooser(editor, expressions2, new Pass<PsiElement>(){

            public void pass(@NotNull PsiElement e) {
                PostfixTemplateWithExpressionSelector.this.prepareAndExpandForChooseExpression(e, editor);
            }
        }, this.mySelector.getRenderer(), "Expressions", 0, ScopeHighlighter.NATURAL_RANGER);
    }

    protected void prepareAndExpandForChooseExpression(@NotNull PsiElement expression2, @NotNull Editor editor) {
        ApplicationManager.getApplication().runWriteAction(() -> CommandProcessor.getInstance().executeCommand(expression2.getProject(), () -> this.expandForChooseExpression(expression2, editor), "Expand postfix template", (Object)"POSTFIX_TEMPLATE_ID"));
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    protected abstract void expandForChooseExpression(@NotNull PsiElement var1, @NotNull Editor var2);
}

